@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property computeReservation Value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html).
 * @property shareDecaySeconds
 * @property shareDistributions One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
 */
public data class GetSchedulingPolicyFairSharePolicy(
    public val computeReservation: Int,
    public val shareDecaySeconds: Int,
    public val shareDistributions: List<GetSchedulingPolicyFairSharePolicyShareDistribution>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetSchedulingPolicyFairSharePolicy): GetSchedulingPolicyFairSharePolicy = GetSchedulingPolicyFairSharePolicy(
            computeReservation = javaType.computeReservation(),
            shareDecaySeconds = javaType.shareDecaySeconds(),
            shareDistributions = javaType.shareDistributions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.GetSchedulingPolicyFairSharePolicyShareDistribution.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
