@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property shareIdentifier Fair share identifier or fair share identifier prefix. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
 * @property weightFactor Weight factor for the fair share identifier. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
 */
public data class GetSchedulingPolicyFairSharePolicyShareDistribution(
    public val shareIdentifier: String,
    public val weightFactor: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetSchedulingPolicyFairSharePolicyShareDistribution): GetSchedulingPolicyFairSharePolicyShareDistribution =
            GetSchedulingPolicyFairSharePolicyShareDistribution(
                shareIdentifier = javaType.shareIdentifier(),
                weightFactor = javaType.weightFactor(),
            )
    }
}
