@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property containers Properties of the container that's used on the Amazon EKS pod. See containers below.
 * @property dnsPolicy DNS policy for the pod. The default value is `ClusterFirst`. If the `host_network` argument is not specified, the default is `ClusterFirstWithHostNet`. `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see Pod's DNS policy in the Kubernetes documentation.
 * @property hostNetwork Whether the pod uses the hosts' network IP address. The default value is `true`. Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
 * @property imagePullSecrets List of Kubernetes secret resources. See `image_pull_secret` below.
 * @property metadata Metadata about the Kubernetes pod.
 * @property serviceAccountName Name of the service account that's used to run the pod.
 * @property volumes Volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
 */
public data class JobDefinitionEksPropertiesPodProperties(
    public val containers: JobDefinitionEksPropertiesPodPropertiesContainers,
    public val dnsPolicy: String? = null,
    public val hostNetwork: Boolean? = null,
    public val imagePullSecrets: List<JobDefinitionEksPropertiesPodPropertiesImagePullSecret>? = null,
    public val metadata: JobDefinitionEksPropertiesPodPropertiesMetadata? = null,
    public val serviceAccountName: String? = null,
    public val volumes: List<JobDefinitionEksPropertiesPodPropertiesVolume>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.JobDefinitionEksPropertiesPodProperties): JobDefinitionEksPropertiesPodProperties = JobDefinitionEksPropertiesPodProperties(
            containers = javaType.containers().let({ args0 ->
                com.pulumi.aws.batch.kotlin.outputs.JobDefinitionEksPropertiesPodPropertiesContainers.Companion.toKotlin(args0)
            }),
            dnsPolicy = javaType.dnsPolicy().map({ args0 -> args0 }).orElse(null),
            hostNetwork = javaType.hostNetwork().map({ args0 -> args0 }).orElse(null),
            imagePullSecrets = javaType.imagePullSecrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.JobDefinitionEksPropertiesPodPropertiesImagePullSecret.Companion.toKotlin(args0)
                })
            }),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.JobDefinitionEksPropertiesPodPropertiesMetadata.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceAccountName = javaType.serviceAccountName().map({ args0 -> args0 }).orElse(null),
            volumes = javaType.volumes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.JobDefinitionEksPropertiesPodPropertiesVolume.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
