@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property args Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
 * @property commands Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
 * @property envs Environment variables to pass to a container. See EKS Environment below.
 * @property image Docker image used to start the container.
 * @property imagePullPolicy Image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
 * @property name Name of the container. If the name isn't specified, the default name "Default" is used. Each container in a pod must have a unique name.
 * @property resources Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
 * @property securityContext Security context for a job.
 * @property volumeMounts Volume mounts for the container.
 */
public data class JobDefinitionEksPropertiesPodPropertiesContainers(
    public val args: List<String>? = null,
    public val commands: List<String>? = null,
    public val envs: List<JobDefinitionEksPropertiesPodPropertiesContainersEnv>? = null,
    public val image: String,
    public val imagePullPolicy: String? = null,
    public val name: String? = null,
    public val resources: JobDefinitionEksPropertiesPodPropertiesContainersResources? = null,
    public val securityContext: JobDefinitionEksPropertiesPodPropertiesContainersSecurityContext? =
        null,
    public val volumeMounts: List<JobDefinitionEksPropertiesPodPropertiesContainersVolumeMount>? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.JobDefinitionEksPropertiesPodPropertiesContainers): JobDefinitionEksPropertiesPodPropertiesContainers =
            JobDefinitionEksPropertiesPodPropertiesContainers(
                args = javaType.args().map({ args0 -> args0 }),
                commands = javaType.commands().map({ args0 -> args0 }),
                envs = javaType.envs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.JobDefinitionEksPropertiesPodPropertiesContainersEnv.Companion.toKotlin(args0)
                    })
                }),
                image = javaType.image(),
                imagePullPolicy = javaType.imagePullPolicy().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                resources = javaType.resources().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.JobDefinitionEksPropertiesPodPropertiesContainersResources.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                securityContext = javaType.securityContext().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.JobDefinitionEksPropertiesPodPropertiesContainersSecurityContext.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                volumeMounts = javaType.volumeMounts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.JobDefinitionEksPropertiesPodPropertiesContainersVolumeMount.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
