@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property computeEnvironment The Amazon Resource Name (ARN) of the compute environment.
 * @property order The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower order integer value is tried for job placement first.
 */
public data class JobQueueComputeEnvironmentOrder(
    public val computeEnvironment: String,
    public val order: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.JobQueueComputeEnvironmentOrder): JobQueueComputeEnvironmentOrder = JobQueueComputeEnvironmentOrder(
            computeEnvironment = javaType.computeEnvironment(),
            order = javaType.order(),
        )
    }
}
