@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property shareIdentifier A fair share identifier or fair share identifier prefix. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
 * @property weightFactor The weight factor for the fair share identifier. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
 */
public data class SchedulingPolicyFairSharePolicyShareDistribution(
    public val shareIdentifier: String,
    public val weightFactor: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.SchedulingPolicyFairSharePolicyShareDistribution): SchedulingPolicyFairSharePolicyShareDistribution =
            SchedulingPolicyFairSharePolicyShareDistribution(
                shareIdentifier = javaType.shareIdentifier(),
                weightFactor = javaType.weightFactor().map({ args0 -> args0 }).orElse(null),
            )
    }
}
