@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bcmdata.kotlin

import com.pulumi.aws.bcmdata.kotlin.outputs.ExportExport
import com.pulumi.aws.bcmdata.kotlin.outputs.ExportTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.bcmdata.kotlin.outputs.ExportExport.Companion.toKotlin as exportExportToKotlin
import com.pulumi.aws.bcmdata.kotlin.outputs.ExportTimeouts.Companion.toKotlin as exportTimeoutsToKotlin

/**
 * Builder for [Export].
 */
@PulumiTagMarker
public class ExportResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExportArgs = ExportArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExportArgsBuilder.() -> Unit) {
        val builder = ExportArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Export {
        val builtJavaResource = com.pulumi.aws.bcmdata.Export(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Export(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS BCM Data Exports Export.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.bcmdata.Export("test", {"export": {
 *     name: "testexample",
 *     dataQueries: [{
 *         queryStatement: "SELECT identity_line_item_id, identity_time_interval, line_item_product_code,line_item_unblended_cost FROM COST_AND_USAGE_REPORT",
 *         tableConfigurations: {
 *             COST_AND_USAGE_REPORT: {
 *                 TIME_GRANULARITY: "HOURLY",
 *                 INCLUDE_RESOURCES: "FALSE",
 *                 INCLUDE_MANUAL_DISCOUNT_COMPATIBILITY: "FALSE",
 *                 INCLUDE_SPLIT_COST_ALLOCATION_DATA: "FALSE",
 *             },
 *         },
 *     }],
 *     destinationConfigurations: [{
 *         s3Destinations: [{
 *             s3Bucket: testAwsS3Bucket.bucket,
 *             s3Prefix: testAwsS3Bucket.bucketPrefix,
 *             s3Region: testAwsS3Bucket.region,
 *             s3OutputConfigurations: [{
 *                 overwrite: "OVERWRITE_REPORT",
 *                 format: "TEXT_OR_CSV",
 *                 compression: "GZIP",
 *                 outputType: "CUSTOM",
 *             }],
 *         }],
 *     }],
 *     refreshCadences: [{
 *         frequency: "SYNCHRONOUS",
 *     }],
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.bcmdata.Export("test", export={
 *     "name": "testexample",
 *     "data_queries": [{
 *         "query_statement": "SELECT identity_line_item_id, identity_time_interval, line_item_product_code,line_item_unblended_cost FROM COST_AND_USAGE_REPORT",
 *         "table_configurations": {
 *             "cos_t__an_d__usag_e__report": {
 *                 "tim_e__granularity": "HOURLY",
 *                 "includ_e__resources": "FALSE",
 *                 "includ_e__manua_l__discoun_t__compatibility": "FALSE",
 *                 "includ_e__spli_t__cos_t__allocatio_n__data": "FALSE",
 *             },
 *         },
 *     }],
 *     "destination_configurations": [{
 *         "s3_destinations": [{
 *             "s3_bucket": test_aws_s3_bucket["bucket"],
 *             "s3_prefix": test_aws_s3_bucket["bucketPrefix"],
 *             "s3_region": test_aws_s3_bucket["region"],
 *             "s3_output_configurations": [{
 *                 "overwrite": "OVERWRITE_REPORT",
 *                 "format": "TEXT_OR_CSV",
 *                 "compression": "GZIP",
 *                 "output_type": "CUSTOM",
 *             }],
 *         }],
 *     }],
 *     "refresh_cadences": [{
 *         "frequency": "SYNCHRONOUS",
 *     }],
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.BcmData.Export("test", new()
 *     {
 *         ExportDetails = new Aws.BcmData.Inputs.ExportExportArgs
 *         {
 *             Name = "testexample",
 *             DataQueries = new[]
 *             {
 *                 new Aws.BcmData.Inputs.ExportExportDataQueryArgs
 *                 {
 *                     QueryStatement = "SELECT identity_line_item_id, identity_time_interval, line_item_product_code,line_item_unblended_cost FROM COST_AND_USAGE_REPORT",
 *                     TableConfigurations =
 *                     {
 *                         { "COST_AND_USAGE_REPORT",
 *                         {
 *                             { "TIME_GRANULARITY", "HOURLY" },
 *                             { "INCLUDE_RESOURCES", "FALSE" },
 *                             { "INCLUDE_MANUAL_DISCOUNT_COMPATIBILITY", "FALSE" },
 *                             { "INCLUDE_SPLIT_COST_ALLOCATION_DATA", "FALSE" },
 *                         } },
 *                     },
 *                 },
 *             },
 *             DestinationConfigurations = new[]
 *             {
 *                 new Aws.BcmData.Inputs.ExportExportDestinationConfigurationArgs
 *                 {
 *                     S3Destinations = new[]
 *                     {
 *                         new Aws.BcmData.Inputs.ExportExportDestinationConfigurationS3DestinationArgs
 *                         {
 *                             S3Bucket = testAwsS3Bucket.Bucket,
 *                             S3Prefix = testAwsS3Bucket.BucketPrefix,
 *                             S3Region = testAwsS3Bucket.Region,
 *                             S3OutputConfigurations = new[]
 *                             {
 *                                 new Aws.BcmData.Inputs.ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs
 *                                 {
 *                                     Overwrite = "OVERWRITE_REPORT",
 *                                     Format = "TEXT_OR_CSV",
 *                                     Compression = "GZIP",
 *                                     OutputType = "CUSTOM",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             RefreshCadences = new[]
 *             {
 *                 new Aws.BcmData.Inputs.ExportExportRefreshCadenceArgs
 *                 {
 *                     Frequency = "SYNCHRONOUS",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bcmdata"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := bcmdata.NewExport(ctx, "test", &bcmdata.ExportArgs{
 * 			Export: &bcmdata.ExportExportArgs{
 * 				Name: pulumi.String("testexample"),
 * 				DataQueries: bcmdata.ExportExportDataQueryArray{
 * 					&bcmdata.ExportExportDataQueryArgs{
 * 						QueryStatement: pulumi.String("SELECT identity_line_item_id, identity_time_interval, line_item_product_code,line_item_unblended_cost FROM COST_AND_USAGE_REPORT"),
 * 						TableConfigurations: pulumi.StringMapMap{
 * 							"COST_AND_USAGE_REPORT": pulumi.StringMap{
 * 								"TIME_GRANULARITY":                      pulumi.String("HOURLY"),
 * 								"INCLUDE_RESOURCES":                     pulumi.String("FALSE"),
 * 								"INCLUDE_MANUAL_DISCOUNT_COMPATIBILITY": pulumi.String("FALSE"),
 * 								"INCLUDE_SPLIT_COST_ALLOCATION_DATA":    pulumi.String("FALSE"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				DestinationConfigurations: bcmdata.ExportExportDestinationConfigurationArray{
 * 					&bcmdata.ExportExportDestinationConfigurationArgs{
 * 						S3Destinations: bcmdata.ExportExportDestinationConfigurationS3DestinationArray{
 * 							&bcmdata.ExportExportDestinationConfigurationS3DestinationArgs{
 * 								S3Bucket: pulumi.Any(testAwsS3Bucket.Bucket),
 * 								S3Prefix: pulumi.Any(testAwsS3Bucket.BucketPrefix),
 * 								S3Region: pulumi.Any(testAwsS3Bucket.Region),
 * 								S3OutputConfigurations: bcmdata.ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArray{
 * 									&bcmdata.ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs{
 * 										Overwrite:   pulumi.String("OVERWRITE_REPORT"),
 * 										Format:      pulumi.String("TEXT_OR_CSV"),
 * 										Compression: pulumi.String("GZIP"),
 * 										OutputType:  pulumi.String("CUSTOM"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				RefreshCadences: bcmdata.ExportExportRefreshCadenceArray{
 * 					&bcmdata.ExportExportRefreshCadenceArgs{
 * 						Frequency: pulumi.String("SYNCHRONOUS"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.bcmdata.Export;
 * import com.pulumi.aws.bcmdata.ExportArgs;
 * import com.pulumi.aws.bcmdata.inputs.ExportExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Export("test", ExportArgs.builder()
 *             .export(ExportExportArgs.builder()
 *                 .name("testexample")
 *                 .dataQueries(ExportExportDataQueryArgs.builder()
 *                     .queryStatement("SELECT identity_line_item_id, identity_time_interval, line_item_product_code,line_item_unblended_cost FROM COST_AND_USAGE_REPORT")
 *                     .tableConfigurations(Map.of("COST_AND_USAGE_REPORT", Map.ofEntries(
 *                         Map.entry("TIME_GRANULARITY", "HOURLY"),
 *                         Map.entry("INCLUDE_RESOURCES", "FALSE"),
 *                         Map.entry("INCLUDE_MANUAL_DISCOUNT_COMPATIBILITY", "FALSE"),
 *                         Map.entry("INCLUDE_SPLIT_COST_ALLOCATION_DATA", "FALSE")
 *                     )))
 *                     .build())
 *                 .destinationConfigurations(ExportExportDestinationConfigurationArgs.builder()
 *                     .s3Destinations(ExportExportDestinationConfigurationS3DestinationArgs.builder()
 *                         .s3Bucket(testAwsS3Bucket.bucket())
 *                         .s3Prefix(testAwsS3Bucket.bucketPrefix())
 *                         .s3Region(testAwsS3Bucket.region())
 *                         .s3OutputConfigurations(ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs.builder()
 *                             .overwrite("OVERWRITE_REPORT")
 *                             .format("TEXT_OR_CSV")
 *                             .compression("GZIP")
 *                             .outputType("CUSTOM")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .refreshCadences(ExportExportRefreshCadenceArgs.builder()
 *                     .frequency("SYNCHRONOUS")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:bcmdata:Export
 *     properties:
 *       export:
 *         name: testexample
 *         dataQueries:
 *           - queryStatement: SELECT identity_line_item_id, identity_time_interval, line_item_product_code,line_item_unblended_cost FROM COST_AND_USAGE_REPORT
 *             tableConfigurations:
 *               COST_AND_USAGE_REPORT:
 *                 TIME_GRANULARITY: HOURLY
 *                 INCLUDE_RESOURCES: FALSE
 *                 INCLUDE_MANUAL_DISCOUNT_COMPATIBILITY: FALSE
 *                 INCLUDE_SPLIT_COST_ALLOCATION_DATA: FALSE
 *         destinationConfigurations:
 *           - s3Destinations:
 *               - s3Bucket: ${testAwsS3Bucket.bucket}
 *                 s3Prefix: ${testAwsS3Bucket.bucketPrefix}
 *                 s3Region: ${testAwsS3Bucket.region}
 *                 s3OutputConfigurations:
 *                   - overwrite: OVERWRITE_REPORT
 *                     format: TEXT_OR_CSV
 *                     compression: GZIP
 *                     outputType: CUSTOM
 *         refreshCadences:
 *           - frequency: SYNCHRONOUS
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import BCM Data Exports Export using the export ARN. For example:
 * ```sh
 * $ pulumi import aws:bcmdata/export:Export example arn:aws:bcm-data-exports:us-east-1:123456789012:export/CostUsageReport-9f1c75f3-f982-4d9a-b936-1e7ecab814b7
 * ```
 */
public class Export internal constructor(
    override val javaResource: com.pulumi.aws.bcmdata.Export,
) : KotlinCustomResource(javaResource, ExportMapper) {
    /**
     * The details of the export, including data query, name, description, and destination configuration.  See the `export` argument reference below.
     */
    public val export: Output<ExportExport>?
        get() = javaResource.export().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    exportExportToKotlin(args0)
                })
            }).orElse(null)
        })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<ExportTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    exportTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ExportMapper : ResourceMapper<Export> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.bcmdata.Export::class == javaResource::class

    override fun map(javaResource: Resource): Export = Export(
        javaResource as
            com.pulumi.aws.bcmdata.Export,
    )
}

/**
 * @see [Export].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Export].
 */
public suspend fun export(name: String, block: suspend ExportResourceBuilder.() -> Unit): Export {
    val builder = ExportResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Export].
 * @param name The _unique_ name of the resulting resource.
 */
public fun export(name: String): Export {
    val builder = ExportResourceBuilder()
    builder.name(name)
    return builder.build()
}
