@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bcmdata.kotlin

import com.pulumi.aws.bcmdata.ExportArgs.builder
import com.pulumi.aws.bcmdata.kotlin.inputs.ExportExportArgs
import com.pulumi.aws.bcmdata.kotlin.inputs.ExportExportArgsBuilder
import com.pulumi.aws.bcmdata.kotlin.inputs.ExportTimeoutsArgs
import com.pulumi.aws.bcmdata.kotlin.inputs.ExportTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS BCM Data Exports Export.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.bcmdata.Export("test", {"export": {
 *     name: "testexample",
 *     dataQueries: [{
 *         queryStatement: "SELECT identity_line_item_id, identity_time_interval, line_item_product_code,line_item_unblended_cost FROM COST_AND_USAGE_REPORT",
 *         tableConfigurations: {
 *             COST_AND_USAGE_REPORT: {
 *                 TIME_GRANULARITY: "HOURLY",
 *                 INCLUDE_RESOURCES: "FALSE",
 *                 INCLUDE_MANUAL_DISCOUNT_COMPATIBILITY: "FALSE",
 *                 INCLUDE_SPLIT_COST_ALLOCATION_DATA: "FALSE",
 *             },
 *         },
 *     }],
 *     destinationConfigurations: [{
 *         s3Destinations: [{
 *             s3Bucket: testAwsS3Bucket.bucket,
 *             s3Prefix: testAwsS3Bucket.bucketPrefix,
 *             s3Region: testAwsS3Bucket.region,
 *             s3OutputConfigurations: [{
 *                 overwrite: "OVERWRITE_REPORT",
 *                 format: "TEXT_OR_CSV",
 *                 compression: "GZIP",
 *                 outputType: "CUSTOM",
 *             }],
 *         }],
 *     }],
 *     refreshCadences: [{
 *         frequency: "SYNCHRONOUS",
 *     }],
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.bcmdata.Export("test", export={
 *     "name": "testexample",
 *     "data_queries": [{
 *         "query_statement": "SELECT identity_line_item_id, identity_time_interval, line_item_product_code,line_item_unblended_cost FROM COST_AND_USAGE_REPORT",
 *         "table_configurations": {
 *             "cos_t__an_d__usag_e__report": {
 *                 "tim_e__granularity": "HOURLY",
 *                 "includ_e__resources": "FALSE",
 *                 "includ_e__manua_l__discoun_t__compatibility": "FALSE",
 *                 "includ_e__spli_t__cos_t__allocatio_n__data": "FALSE",
 *             },
 *         },
 *     }],
 *     "destination_configurations": [{
 *         "s3_destinations": [{
 *             "s3_bucket": test_aws_s3_bucket["bucket"],
 *             "s3_prefix": test_aws_s3_bucket["bucketPrefix"],
 *             "s3_region": test_aws_s3_bucket["region"],
 *             "s3_output_configurations": [{
 *                 "overwrite": "OVERWRITE_REPORT",
 *                 "format": "TEXT_OR_CSV",
 *                 "compression": "GZIP",
 *                 "output_type": "CUSTOM",
 *             }],
 *         }],
 *     }],
 *     "refresh_cadences": [{
 *         "frequency": "SYNCHRONOUS",
 *     }],
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.BcmData.Export("test", new()
 *     {
 *         ExportDetails = new Aws.BcmData.Inputs.ExportExportArgs
 *         {
 *             Name = "testexample",
 *             DataQueries = new[]
 *             {
 *                 new Aws.BcmData.Inputs.ExportExportDataQueryArgs
 *                 {
 *                     QueryStatement = "SELECT identity_line_item_id, identity_time_interval, line_item_product_code,line_item_unblended_cost FROM COST_AND_USAGE_REPORT",
 *                     TableConfigurations =
 *                     {
 *                         { "COST_AND_USAGE_REPORT",
 *                         {
 *                             { "TIME_GRANULARITY", "HOURLY" },
 *                             { "INCLUDE_RESOURCES", "FALSE" },
 *                             { "INCLUDE_MANUAL_DISCOUNT_COMPATIBILITY", "FALSE" },
 *                             { "INCLUDE_SPLIT_COST_ALLOCATION_DATA", "FALSE" },
 *                         } },
 *                     },
 *                 },
 *             },
 *             DestinationConfigurations = new[]
 *             {
 *                 new Aws.BcmData.Inputs.ExportExportDestinationConfigurationArgs
 *                 {
 *                     S3Destinations = new[]
 *                     {
 *                         new Aws.BcmData.Inputs.ExportExportDestinationConfigurationS3DestinationArgs
 *                         {
 *                             S3Bucket = testAwsS3Bucket.Bucket,
 *                             S3Prefix = testAwsS3Bucket.BucketPrefix,
 *                             S3Region = testAwsS3Bucket.Region,
 *                             S3OutputConfigurations = new[]
 *                             {
 *                                 new Aws.BcmData.Inputs.ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs
 *                                 {
 *                                     Overwrite = "OVERWRITE_REPORT",
 *                                     Format = "TEXT_OR_CSV",
 *                                     Compression = "GZIP",
 *                                     OutputType = "CUSTOM",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             RefreshCadences = new[]
 *             {
 *                 new Aws.BcmData.Inputs.ExportExportRefreshCadenceArgs
 *                 {
 *                     Frequency = "SYNCHRONOUS",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bcmdata"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := bcmdata.NewExport(ctx, "test", &bcmdata.ExportArgs{
 * 			Export: &bcmdata.ExportExportArgs{
 * 				Name: pulumi.String("testexample"),
 * 				DataQueries: bcmdata.ExportExportDataQueryArray{
 * 					&bcmdata.ExportExportDataQueryArgs{
 * 						QueryStatement: pulumi.String("SELECT identity_line_item_id, identity_time_interval, line_item_product_code,line_item_unblended_cost FROM COST_AND_USAGE_REPORT"),
 * 						TableConfigurations: pulumi.StringMapMap{
 * 							"COST_AND_USAGE_REPORT": pulumi.StringMap{
 * 								"TIME_GRANULARITY":                      pulumi.String("HOURLY"),
 * 								"INCLUDE_RESOURCES":                     pulumi.String("FALSE"),
 * 								"INCLUDE_MANUAL_DISCOUNT_COMPATIBILITY": pulumi.String("FALSE"),
 * 								"INCLUDE_SPLIT_COST_ALLOCATION_DATA":    pulumi.String("FALSE"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				DestinationConfigurations: bcmdata.ExportExportDestinationConfigurationArray{
 * 					&bcmdata.ExportExportDestinationConfigurationArgs{
 * 						S3Destinations: bcmdata.ExportExportDestinationConfigurationS3DestinationArray{
 * 							&bcmdata.ExportExportDestinationConfigurationS3DestinationArgs{
 * 								S3Bucket: pulumi.Any(testAwsS3Bucket.Bucket),
 * 								S3Prefix: pulumi.Any(testAwsS3Bucket.BucketPrefix),
 * 								S3Region: pulumi.Any(testAwsS3Bucket.Region),
 * 								S3OutputConfigurations: bcmdata.ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArray{
 * 									&bcmdata.ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs{
 * 										Overwrite:   pulumi.String("OVERWRITE_REPORT"),
 * 										Format:      pulumi.String("TEXT_OR_CSV"),
 * 										Compression: pulumi.String("GZIP"),
 * 										OutputType:  pulumi.String("CUSTOM"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				RefreshCadences: bcmdata.ExportExportRefreshCadenceArray{
 * 					&bcmdata.ExportExportRefreshCadenceArgs{
 * 						Frequency: pulumi.String("SYNCHRONOUS"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.bcmdata.Export;
 * import com.pulumi.aws.bcmdata.ExportArgs;
 * import com.pulumi.aws.bcmdata.inputs.ExportExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Export("test", ExportArgs.builder()
 *             .export(ExportExportArgs.builder()
 *                 .name("testexample")
 *                 .dataQueries(ExportExportDataQueryArgs.builder()
 *                     .queryStatement("SELECT identity_line_item_id, identity_time_interval, line_item_product_code,line_item_unblended_cost FROM COST_AND_USAGE_REPORT")
 *                     .tableConfigurations(Map.of("COST_AND_USAGE_REPORT", Map.ofEntries(
 *                         Map.entry("TIME_GRANULARITY", "HOURLY"),
 *                         Map.entry("INCLUDE_RESOURCES", "FALSE"),
 *                         Map.entry("INCLUDE_MANUAL_DISCOUNT_COMPATIBILITY", "FALSE"),
 *                         Map.entry("INCLUDE_SPLIT_COST_ALLOCATION_DATA", "FALSE")
 *                     )))
 *                     .build())
 *                 .destinationConfigurations(ExportExportDestinationConfigurationArgs.builder()
 *                     .s3Destinations(ExportExportDestinationConfigurationS3DestinationArgs.builder()
 *                         .s3Bucket(testAwsS3Bucket.bucket())
 *                         .s3Prefix(testAwsS3Bucket.bucketPrefix())
 *                         .s3Region(testAwsS3Bucket.region())
 *                         .s3OutputConfigurations(ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs.builder()
 *                             .overwrite("OVERWRITE_REPORT")
 *                             .format("TEXT_OR_CSV")
 *                             .compression("GZIP")
 *                             .outputType("CUSTOM")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .refreshCadences(ExportExportRefreshCadenceArgs.builder()
 *                     .frequency("SYNCHRONOUS")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:bcmdata:Export
 *     properties:
 *       export:
 *         name: testexample
 *         dataQueries:
 *           - queryStatement: SELECT identity_line_item_id, identity_time_interval, line_item_product_code,line_item_unblended_cost FROM COST_AND_USAGE_REPORT
 *             tableConfigurations:
 *               COST_AND_USAGE_REPORT:
 *                 TIME_GRANULARITY: HOURLY
 *                 INCLUDE_RESOURCES: FALSE
 *                 INCLUDE_MANUAL_DISCOUNT_COMPATIBILITY: FALSE
 *                 INCLUDE_SPLIT_COST_ALLOCATION_DATA: FALSE
 *         destinationConfigurations:
 *           - s3Destinations:
 *               - s3Bucket: ${testAwsS3Bucket.bucket}
 *                 s3Prefix: ${testAwsS3Bucket.bucketPrefix}
 *                 s3Region: ${testAwsS3Bucket.region}
 *                 s3OutputConfigurations:
 *                   - overwrite: OVERWRITE_REPORT
 *                     format: TEXT_OR_CSV
 *                     compression: GZIP
 *                     outputType: CUSTOM
 *         refreshCadences:
 *           - frequency: SYNCHRONOUS
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import BCM Data Exports Export using the export ARN. For example:
 * ```sh
 * $ pulumi import aws:bcmdata/export:Export example arn:aws:bcm-data-exports:us-east-1:123456789012:export/CostUsageReport-9f1c75f3-f982-4d9a-b936-1e7ecab814b7
 * ```
 * @property export The details of the export, including data query, name, description, and destination configuration.  See the `export` argument reference below.
 * @property tags
 * @property timeouts
 */
public data class ExportArgs(
    public val export: Output<ExportExportArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<ExportTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.bcmdata.ExportArgs> {
    override fun toJava(): com.pulumi.aws.bcmdata.ExportArgs =
        com.pulumi.aws.bcmdata.ExportArgs.builder()
            .export(export?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ExportArgs].
 */
@PulumiTagMarker
public class ExportArgsBuilder internal constructor() {
    private var export: Output<ExportExportArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<ExportTimeoutsArgs>? = null

    /**
     * @param value The details of the export, including data query, name, description, and destination configuration.  See the `export` argument reference below.
     */
    @JvmName("ojgmfthdwfegjycl")
    public suspend fun export(`value`: Output<ExportExportArgs>) {
        this.export = value
    }

    /**
     * @param value
     */
    @JvmName("jssgoikgrammqxmi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("kiwhlkgpnjnmmocw")
    public suspend fun timeouts(`value`: Output<ExportTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The details of the export, including data query, name, description, and destination configuration.  See the `export` argument reference below.
     */
    @JvmName("kqcvovwbdwehtlmp")
    public suspend fun export(`value`: ExportExportArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.export = mapped
    }

    /**
     * @param argument The details of the export, including data query, name, description, and destination configuration.  See the `export` argument reference below.
     */
    @JvmName("wmwkqawnvkfbavoq")
    public suspend fun export(argument: suspend ExportExportArgsBuilder.() -> Unit) {
        val toBeMapped = ExportExportArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.export = mapped
    }

    /**
     * @param value
     */
    @JvmName("jkvrixnmnucjfptv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("wdjesskjfxmphcnr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("xfbksapvialfgfxa")
    public suspend fun timeouts(`value`: ExportTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lksydylicmvgqdno")
    public suspend fun timeouts(argument: suspend ExportTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ExportTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): ExportArgs = ExportArgs(
        export = export,
        tags = tags,
        timeouts = timeouts,
    )
}
