@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bcmdata.kotlin.inputs

import com.pulumi.aws.bcmdata.inputs.ExportExportArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dataQueries Data query for this specific data export. See the `data_query` argument reference below.
 * @property description Description for this specific data export.
 * @property destinationConfigurations Destination configuration for this specific data export. See the `destination_configurations` argument reference below.
 * @property exportArn Amazon Resource Name (ARN) for this export.
 * @property name Name of this specific data export.
 * @property refreshCadences Cadence for Amazon Web Services to update the export in your S3 bucket. See the `refresh_cadence` argument reference below.
 */
public data class ExportExportArgs(
    public val dataQueries: Output<List<ExportExportDataQueryArgs>>? = null,
    public val description: Output<String>? = null,
    public val destinationConfigurations: Output<List<ExportExportDestinationConfigurationArgs>>? =
        null,
    public val exportArn: Output<String>? = null,
    public val name: Output<String>,
    public val refreshCadences: Output<List<ExportExportRefreshCadenceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.bcmdata.inputs.ExportExportArgs> {
    override fun toJava(): com.pulumi.aws.bcmdata.inputs.ExportExportArgs =
        com.pulumi.aws.bcmdata.inputs.ExportExportArgs.builder()
            .dataQueries(
                dataQueries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationConfigurations(
                destinationConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .exportArn(exportArn?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .refreshCadences(
                refreshCadences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExportExportArgs].
 */
@PulumiTagMarker
public class ExportExportArgsBuilder internal constructor() {
    private var dataQueries: Output<List<ExportExportDataQueryArgs>>? = null

    private var description: Output<String>? = null

    private var destinationConfigurations: Output<List<ExportExportDestinationConfigurationArgs>>? =
        null

    private var exportArn: Output<String>? = null

    private var name: Output<String>? = null

    private var refreshCadences: Output<List<ExportExportRefreshCadenceArgs>>? = null

    /**
     * @param value Data query for this specific data export. See the `data_query` argument reference below.
     */
    @JvmName("hecpwrfngpbdiqeg")
    public suspend fun dataQueries(`value`: Output<List<ExportExportDataQueryArgs>>) {
        this.dataQueries = value
    }

    @JvmName("bxalhcqioufyguwv")
    public suspend fun dataQueries(vararg values: Output<ExportExportDataQueryArgs>) {
        this.dataQueries = Output.all(values.asList())
    }

    /**
     * @param values Data query for this specific data export. See the `data_query` argument reference below.
     */
    @JvmName("kvavtqkileccdxhc")
    public suspend fun dataQueries(values: List<Output<ExportExportDataQueryArgs>>) {
        this.dataQueries = Output.all(values)
    }

    /**
     * @param value Description for this specific data export.
     */
    @JvmName("sbejibjghnbxjxrs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Destination configuration for this specific data export. See the `destination_configurations` argument reference below.
     */
    @JvmName("cnxdanrtcwwcnadn")
    public suspend fun destinationConfigurations(`value`: Output<List<ExportExportDestinationConfigurationArgs>>) {
        this.destinationConfigurations = value
    }

    @JvmName("nmvjnuespohatgoe")
    public suspend fun destinationConfigurations(vararg values: Output<ExportExportDestinationConfigurationArgs>) {
        this.destinationConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Destination configuration for this specific data export. See the `destination_configurations` argument reference below.
     */
    @JvmName("teokkovypyfvgbwg")
    public suspend fun destinationConfigurations(values: List<Output<ExportExportDestinationConfigurationArgs>>) {
        this.destinationConfigurations = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) for this export.
     */
    @JvmName("xhuidkeudotfinfw")
    public suspend fun exportArn(`value`: Output<String>) {
        this.exportArn = value
    }

    /**
     * @param value Name of this specific data export.
     */
    @JvmName("aupvgfpehtgfyycs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Cadence for Amazon Web Services to update the export in your S3 bucket. See the `refresh_cadence` argument reference below.
     */
    @JvmName("osuyjbetovmjwpig")
    public suspend fun refreshCadences(`value`: Output<List<ExportExportRefreshCadenceArgs>>) {
        this.refreshCadences = value
    }

    @JvmName("upmvtfhooakujqei")
    public suspend fun refreshCadences(vararg values: Output<ExportExportRefreshCadenceArgs>) {
        this.refreshCadences = Output.all(values.asList())
    }

    /**
     * @param values Cadence for Amazon Web Services to update the export in your S3 bucket. See the `refresh_cadence` argument reference below.
     */
    @JvmName("ihgstybkhnvckjke")
    public suspend fun refreshCadences(values: List<Output<ExportExportRefreshCadenceArgs>>) {
        this.refreshCadences = Output.all(values)
    }

    /**
     * @param value Data query for this specific data export. See the `data_query` argument reference below.
     */
    @JvmName("jvvfwxcetetmejml")
    public suspend fun dataQueries(`value`: List<ExportExportDataQueryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataQueries = mapped
    }

    /**
     * @param argument Data query for this specific data export. See the `data_query` argument reference below.
     */
    @JvmName("lenljwlgirscpabi")
    public suspend fun dataQueries(argument: List<suspend ExportExportDataQueryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExportExportDataQueryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataQueries = mapped
    }

    /**
     * @param argument Data query for this specific data export. See the `data_query` argument reference below.
     */
    @JvmName("axhhdxyrqbvkjfsh")
    public suspend fun dataQueries(vararg argument: suspend ExportExportDataQueryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExportExportDataQueryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataQueries = mapped
    }

    /**
     * @param argument Data query for this specific data export. See the `data_query` argument reference below.
     */
    @JvmName("srchvnjvneilditk")
    public suspend fun dataQueries(argument: suspend ExportExportDataQueryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExportExportDataQueryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataQueries = mapped
    }

    /**
     * @param values Data query for this specific data export. See the `data_query` argument reference below.
     */
    @JvmName("xvyyiqdjximmrslg")
    public suspend fun dataQueries(vararg values: ExportExportDataQueryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataQueries = mapped
    }

    /**
     * @param value Description for this specific data export.
     */
    @JvmName("ajrcjhcdjkljbdxw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Destination configuration for this specific data export. See the `destination_configurations` argument reference below.
     */
    @JvmName("buvixmwmflwdpwjk")
    public suspend fun destinationConfigurations(`value`: List<ExportExportDestinationConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationConfigurations = mapped
    }

    /**
     * @param argument Destination configuration for this specific data export. See the `destination_configurations` argument reference below.
     */
    @JvmName("jbvhhdlbfiqentpi")
    public suspend fun destinationConfigurations(argument: List<suspend ExportExportDestinationConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExportExportDestinationConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationConfigurations = mapped
    }

    /**
     * @param argument Destination configuration for this specific data export. See the `destination_configurations` argument reference below.
     */
    @JvmName("jegwtdusfkjbschf")
    public suspend fun destinationConfigurations(vararg argument: suspend ExportExportDestinationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExportExportDestinationConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationConfigurations = mapped
    }

    /**
     * @param argument Destination configuration for this specific data export. See the `destination_configurations` argument reference below.
     */
    @JvmName("vqsqnsbkqjfhvptn")
    public suspend fun destinationConfigurations(argument: suspend ExportExportDestinationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExportExportDestinationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.destinationConfigurations = mapped
    }

    /**
     * @param values Destination configuration for this specific data export. See the `destination_configurations` argument reference below.
     */
    @JvmName("mtcfpatpormysphs")
    public suspend fun destinationConfigurations(vararg values: ExportExportDestinationConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationConfigurations = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) for this export.
     */
    @JvmName("pfegpqkjfkwwaidy")
    public suspend fun exportArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportArn = mapped
    }

    /**
     * @param value Name of this specific data export.
     */
    @JvmName("bgnacfgvuwsywbwm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Cadence for Amazon Web Services to update the export in your S3 bucket. See the `refresh_cadence` argument reference below.
     */
    @JvmName("fltdnqitayyocfbq")
    public suspend fun refreshCadences(`value`: List<ExportExportRefreshCadenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshCadences = mapped
    }

    /**
     * @param argument Cadence for Amazon Web Services to update the export in your S3 bucket. See the `refresh_cadence` argument reference below.
     */
    @JvmName("whikbmbunlxheyeu")
    public suspend fun refreshCadences(argument: List<suspend ExportExportRefreshCadenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExportExportRefreshCadenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.refreshCadences = mapped
    }

    /**
     * @param argument Cadence for Amazon Web Services to update the export in your S3 bucket. See the `refresh_cadence` argument reference below.
     */
    @JvmName("vlvwkbdlbodcpyev")
    public suspend fun refreshCadences(vararg argument: suspend ExportExportRefreshCadenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExportExportRefreshCadenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.refreshCadences = mapped
    }

    /**
     * @param argument Cadence for Amazon Web Services to update the export in your S3 bucket. See the `refresh_cadence` argument reference below.
     */
    @JvmName("kwldpewggxoraoan")
    public suspend fun refreshCadences(argument: suspend ExportExportRefreshCadenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExportExportRefreshCadenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.refreshCadences = mapped
    }

    /**
     * @param values Cadence for Amazon Web Services to update the export in your S3 bucket. See the `refresh_cadence` argument reference below.
     */
    @JvmName("bkrfeikwktwkmbah")
    public suspend fun refreshCadences(vararg values: ExportExportRefreshCadenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refreshCadences = mapped
    }

    internal fun build(): ExportExportArgs = ExportExportArgs(
        dataQueries = dataQueries,
        description = description,
        destinationConfigurations = destinationConfigurations,
        exportArn = exportArn,
        name = name ?: throw PulumiNullFieldException("name"),
        refreshCadences = refreshCadences,
    )
}
