@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bcmdata.kotlin.inputs

import com.pulumi.aws.bcmdata.inputs.ExportExportDataQueryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property queryStatement Query statement.
 * @property tableConfigurations Table configuration.
 */
public data class ExportExportDataQueryArgs(
    public val queryStatement: Output<String>,
    public val tableConfigurations: Output<Map<String, Map<String, String>>>? = null,
) : ConvertibleToJava<com.pulumi.aws.bcmdata.inputs.ExportExportDataQueryArgs> {
    override fun toJava(): com.pulumi.aws.bcmdata.inputs.ExportExportDataQueryArgs =
        com.pulumi.aws.bcmdata.inputs.ExportExportDataQueryArgs.builder()
            .queryStatement(queryStatement.applyValue({ args0 -> args0 }))
            .tableConfigurations(
                tableConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.map({ args0 ->
                                args0.key.to(args0.value)
                            }).toMap(),
                        )
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ExportExportDataQueryArgs].
 */
@PulumiTagMarker
public class ExportExportDataQueryArgsBuilder internal constructor() {
    private var queryStatement: Output<String>? = null

    private var tableConfigurations: Output<Map<String, Map<String, String>>>? = null

    /**
     * @param value Query statement.
     */
    @JvmName("ydchmusqppdarndh")
    public suspend fun queryStatement(`value`: Output<String>) {
        this.queryStatement = value
    }

    /**
     * @param value Table configuration.
     */
    @JvmName("vycegbxfbdodhafq")
    public suspend fun tableConfigurations(`value`: Output<Map<String, Map<String, String>>>) {
        this.tableConfigurations = value
    }

    /**
     * @param value Query statement.
     */
    @JvmName("egxhecktqcslgicd")
    public suspend fun queryStatement(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStatement = mapped
    }

    /**
     * @param value Table configuration.
     */
    @JvmName("kvoxanimhbduvake")
    public suspend fun tableConfigurations(`value`: Map<String, Map<String, String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableConfigurations = mapped
    }

    /**
     * @param values Table configuration.
     */
    @JvmName("tsifdcllguelvtny")
    public fun tableConfigurations(vararg values: Pair<String, Map<String, String>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableConfigurations = mapped
    }

    internal fun build(): ExportExportDataQueryArgs = ExportExportDataQueryArgs(
        queryStatement = queryStatement ?: throw PulumiNullFieldException("queryStatement"),
        tableConfigurations = tableConfigurations,
    )
}
