@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bcmdata.kotlin.inputs

import com.pulumi.aws.bcmdata.inputs.ExportExportDestinationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property s3Destinations Object that describes the destination of the data exports file. See the `s3_destination` argument reference below.
 */
public data class ExportExportDestinationConfigurationArgs(
    public val s3Destinations: Output<List<ExportExportDestinationConfigurationS3DestinationArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.bcmdata.inputs.ExportExportDestinationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bcmdata.inputs.ExportExportDestinationConfigurationArgs =
        com.pulumi.aws.bcmdata.inputs.ExportExportDestinationConfigurationArgs.builder()
            .s3Destinations(
                s3Destinations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExportExportDestinationConfigurationArgs].
 */
@PulumiTagMarker
public class ExportExportDestinationConfigurationArgsBuilder internal constructor() {
    private var s3Destinations: Output<List<ExportExportDestinationConfigurationS3DestinationArgs>>? =
        null

    /**
     * @param value Object that describes the destination of the data exports file. See the `s3_destination` argument reference below.
     */
    @JvmName("oowygbcmjqivpwwd")
    public suspend fun s3Destinations(`value`: Output<List<ExportExportDestinationConfigurationS3DestinationArgs>>) {
        this.s3Destinations = value
    }

    @JvmName("agusumiiterknrqh")
    public suspend fun s3Destinations(vararg values: Output<ExportExportDestinationConfigurationS3DestinationArgs>) {
        this.s3Destinations = Output.all(values.asList())
    }

    /**
     * @param values Object that describes the destination of the data exports file. See the `s3_destination` argument reference below.
     */
    @JvmName("mupintrdaqlengcc")
    public suspend fun s3Destinations(values: List<Output<ExportExportDestinationConfigurationS3DestinationArgs>>) {
        this.s3Destinations = Output.all(values)
    }

    /**
     * @param value Object that describes the destination of the data exports file. See the `s3_destination` argument reference below.
     */
    @JvmName("uoymqpyeagagueiv")
    public suspend fun s3Destinations(`value`: List<ExportExportDestinationConfigurationS3DestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Destinations = mapped
    }

    /**
     * @param argument Object that describes the destination of the data exports file. See the `s3_destination` argument reference below.
     */
    @JvmName("abycgwvokqjyvcfh")
    public suspend fun s3Destinations(argument: List<suspend ExportExportDestinationConfigurationS3DestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExportExportDestinationConfigurationS3DestinationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.s3Destinations = mapped
    }

    /**
     * @param argument Object that describes the destination of the data exports file. See the `s3_destination` argument reference below.
     */
    @JvmName("uuvxhrebifnmwmki")
    public suspend fun s3Destinations(vararg argument: suspend ExportExportDestinationConfigurationS3DestinationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExportExportDestinationConfigurationS3DestinationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.s3Destinations = mapped
    }

    /**
     * @param argument Object that describes the destination of the data exports file. See the `s3_destination` argument reference below.
     */
    @JvmName("vbqnwpqbaetqacal")
    public suspend fun s3Destinations(argument: suspend ExportExportDestinationConfigurationS3DestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ExportExportDestinationConfigurationS3DestinationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.s3Destinations = mapped
    }

    /**
     * @param values Object that describes the destination of the data exports file. See the `s3_destination` argument reference below.
     */
    @JvmName("wslwxteqjimbheib")
    public suspend fun s3Destinations(vararg values: ExportExportDestinationConfigurationS3DestinationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Destinations = mapped
    }

    internal fun build(): ExportExportDestinationConfigurationArgs =
        ExportExportDestinationConfigurationArgs(
            s3Destinations = s3Destinations,
        )
}
