@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bcmdata.kotlin.inputs

import com.pulumi.aws.bcmdata.inputs.ExportExportDestinationConfigurationS3DestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property s3Bucket Name of the Amazon S3 bucket used as the destination of a data export file.
 * @property s3OutputConfigurations Output configuration for the data export. See the `s3_output_configurations` argument reference below.
 * @property s3Prefix S3 path prefix you want prepended to the name of your data export.
 * @property s3Region S3 bucket region.
 */
public data class ExportExportDestinationConfigurationS3DestinationArgs(
    public val s3Bucket: Output<String>,
    public val s3OutputConfigurations: Output<List<ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs>>? =
        null,
    public val s3Prefix: Output<String>,
    public val s3Region: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.bcmdata.inputs.ExportExportDestinationConfigurationS3DestinationArgs> {
    override fun toJava(): com.pulumi.aws.bcmdata.inputs.ExportExportDestinationConfigurationS3DestinationArgs =
        com.pulumi.aws.bcmdata.inputs.ExportExportDestinationConfigurationS3DestinationArgs.builder()
            .s3Bucket(s3Bucket.applyValue({ args0 -> args0 }))
            .s3OutputConfigurations(
                s3OutputConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .s3Prefix(s3Prefix.applyValue({ args0 -> args0 }))
            .s3Region(s3Region.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExportExportDestinationConfigurationS3DestinationArgs].
 */
@PulumiTagMarker
public class ExportExportDestinationConfigurationS3DestinationArgsBuilder internal constructor() {
    private var s3Bucket: Output<String>? = null

    private var s3OutputConfigurations:
        Output<List<ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs>>? =
        null

    private var s3Prefix: Output<String>? = null

    private var s3Region: Output<String>? = null

    /**
     * @param value Name of the Amazon S3 bucket used as the destination of a data export file.
     */
    @JvmName("yuxurntmjeawjpxk")
    public suspend fun s3Bucket(`value`: Output<String>) {
        this.s3Bucket = value
    }

    /**
     * @param value Output configuration for the data export. See the `s3_output_configurations` argument reference below.
     */
    @JvmName("linwybdehaiyhgsn")
    public suspend fun s3OutputConfigurations(`value`: Output<List<ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs>>) {
        this.s3OutputConfigurations = value
    }

    @JvmName("iwicpfghfrxxeslr")
    public suspend fun s3OutputConfigurations(vararg values: Output<ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs>) {
        this.s3OutputConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Output configuration for the data export. See the `s3_output_configurations` argument reference below.
     */
    @JvmName("qvbxtfcchndtqbtm")
    public suspend fun s3OutputConfigurations(values: List<Output<ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs>>) {
        this.s3OutputConfigurations = Output.all(values)
    }

    /**
     * @param value S3 path prefix you want prepended to the name of your data export.
     */
    @JvmName("kcxrlxtmgwekrdiw")
    public suspend fun s3Prefix(`value`: Output<String>) {
        this.s3Prefix = value
    }

    /**
     * @param value S3 bucket region.
     */
    @JvmName("nxxpwwavupkpwihb")
    public suspend fun s3Region(`value`: Output<String>) {
        this.s3Region = value
    }

    /**
     * @param value Name of the Amazon S3 bucket used as the destination of a data export file.
     */
    @JvmName("qvduluccgyowuvii")
    public suspend fun s3Bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Bucket = mapped
    }

    /**
     * @param value Output configuration for the data export. See the `s3_output_configurations` argument reference below.
     */
    @JvmName("hqgvqavkytokmjcb")
    public suspend fun s3OutputConfigurations(`value`: List<ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3OutputConfigurations = mapped
    }

    /**
     * @param argument Output configuration for the data export. See the `s3_output_configurations` argument reference below.
     */
    @JvmName("oqemedkxnqmfrodo")
    public suspend fun s3OutputConfigurations(argument: List<suspend ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.s3OutputConfigurations = mapped
    }

    /**
     * @param argument Output configuration for the data export. See the `s3_output_configurations` argument reference below.
     */
    @JvmName("oexkssbxyuvrfbok")
    public suspend fun s3OutputConfigurations(vararg argument: suspend ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.s3OutputConfigurations = mapped
    }

    /**
     * @param argument Output configuration for the data export. See the `s3_output_configurations` argument reference below.
     */
    @JvmName("eyqprbfqcncckuqf")
    public suspend fun s3OutputConfigurations(argument: suspend ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.s3OutputConfigurations = mapped
    }

    /**
     * @param values Output configuration for the data export. See the `s3_output_configurations` argument reference below.
     */
    @JvmName("ykyfovekahrentby")
    public suspend fun s3OutputConfigurations(vararg values: ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3OutputConfigurations = mapped
    }

    /**
     * @param value S3 path prefix you want prepended to the name of your data export.
     */
    @JvmName("usfirhvhueqaihck")
    public suspend fun s3Prefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Prefix = mapped
    }

    /**
     * @param value S3 bucket region.
     */
    @JvmName("urekravwfdlwddjl")
    public suspend fun s3Region(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Region = mapped
    }

    internal fun build(): ExportExportDestinationConfigurationS3DestinationArgs =
        ExportExportDestinationConfigurationS3DestinationArgs(
            s3Bucket = s3Bucket ?: throw PulumiNullFieldException("s3Bucket"),
            s3OutputConfigurations = s3OutputConfigurations,
            s3Prefix = s3Prefix ?: throw PulumiNullFieldException("s3Prefix"),
            s3Region = s3Region ?: throw PulumiNullFieldException("s3Region"),
        )
}
