@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bcmdata.kotlin.inputs

import com.pulumi.aws.bcmdata.inputs.ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property compression Compression type for the data export. Valid values `GZIP`, `PARQUET`.
 * @property format File format for the data export. Valid values `TEXT_OR_CSV` or `PARQUET`.
 * @property outputType Output type for the data export. Valid value `CUSTOM`.
 * @property overwrite The rule to follow when generating a version of the data export file. You have the choice to overwrite the previous version or to be delivered in addition to the previous versions. Overwriting exports can save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data over time. Valid values `CREATE_NEW_REPORT` or `OVERWRITE_REPORT`.
 */
public data class ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs(
    public val compression: Output<String>,
    public val format: Output<String>,
    public val outputType: Output<String>,
    public val overwrite: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.bcmdata.inputs.ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bcmdata.inputs.ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs =
        com.pulumi.aws.bcmdata.inputs.ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs.builder()
            .compression(compression.applyValue({ args0 -> args0 }))
            .format(format.applyValue({ args0 -> args0 }))
            .outputType(outputType.applyValue({ args0 -> args0 }))
            .overwrite(overwrite.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs].
 */
@PulumiTagMarker
public class ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgsBuilder
internal constructor() {
    private var compression: Output<String>? = null

    private var format: Output<String>? = null

    private var outputType: Output<String>? = null

    private var overwrite: Output<String>? = null

    /**
     * @param value Compression type for the data export. Valid values `GZIP`, `PARQUET`.
     */
    @JvmName("tqhywsgrvihxvqav")
    public suspend fun compression(`value`: Output<String>) {
        this.compression = value
    }

    /**
     * @param value File format for the data export. Valid values `TEXT_OR_CSV` or `PARQUET`.
     */
    @JvmName("enudrixbpqpogdbn")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value Output type for the data export. Valid value `CUSTOM`.
     */
    @JvmName("itymqopqehnwnddq")
    public suspend fun outputType(`value`: Output<String>) {
        this.outputType = value
    }

    /**
     * @param value The rule to follow when generating a version of the data export file. You have the choice to overwrite the previous version or to be delivered in addition to the previous versions. Overwriting exports can save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data over time. Valid values `CREATE_NEW_REPORT` or `OVERWRITE_REPORT`.
     */
    @JvmName("eftgwrvfqpfesaiq")
    public suspend fun overwrite(`value`: Output<String>) {
        this.overwrite = value
    }

    /**
     * @param value Compression type for the data export. Valid values `GZIP`, `PARQUET`.
     */
    @JvmName("xjkwtdqkjgjbhgax")
    public suspend fun compression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value File format for the data export. Valid values `TEXT_OR_CSV` or `PARQUET`.
     */
    @JvmName("jjjhxklbiaddqwdw")
    public suspend fun format(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Output type for the data export. Valid value `CUSTOM`.
     */
    @JvmName("jojiissewmkgmwmk")
    public suspend fun outputType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputType = mapped
    }

    /**
     * @param value The rule to follow when generating a version of the data export file. You have the choice to overwrite the previous version or to be delivered in addition to the previous versions. Overwriting exports can save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data over time. Valid values `CREATE_NEW_REPORT` or `OVERWRITE_REPORT`.
     */
    @JvmName("udnximdibscxaxep")
    public suspend fun overwrite(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overwrite = mapped
    }

    internal fun build(): ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs =
        ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs(
            compression = compression ?: throw PulumiNullFieldException("compression"),
            format = format ?: throw PulumiNullFieldException("format"),
            outputType = outputType ?: throw PulumiNullFieldException("outputType"),
            overwrite = overwrite ?: throw PulumiNullFieldException("overwrite"),
        )
}
