@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bcmdata.kotlin.inputs

import com.pulumi.aws.bcmdata.inputs.ExportExportRefreshCadenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property frequency Frequency that data exports are updated. The export refreshes each time the source data updates, up to three times daily. Valid values `SYNCHRONOUS`.
 */
public data class ExportExportRefreshCadenceArgs(
    public val frequency: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.bcmdata.inputs.ExportExportRefreshCadenceArgs> {
    override fun toJava(): com.pulumi.aws.bcmdata.inputs.ExportExportRefreshCadenceArgs =
        com.pulumi.aws.bcmdata.inputs.ExportExportRefreshCadenceArgs.builder()
            .frequency(frequency.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExportExportRefreshCadenceArgs].
 */
@PulumiTagMarker
public class ExportExportRefreshCadenceArgsBuilder internal constructor() {
    private var frequency: Output<String>? = null

    /**
     * @param value Frequency that data exports are updated. The export refreshes each time the source data updates, up to three times daily. Valid values `SYNCHRONOUS`.
     */
    @JvmName("pcnvqwiriwrfybyh")
    public suspend fun frequency(`value`: Output<String>) {
        this.frequency = value
    }

    /**
     * @param value Frequency that data exports are updated. The export refreshes each time the source data updates, up to three times daily. Valid values `SYNCHRONOUS`.
     */
    @JvmName("fnedsoxdojrsmrdy")
    public suspend fun frequency(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    internal fun build(): ExportExportRefreshCadenceArgs = ExportExportRefreshCadenceArgs(
        frequency = frequency ?: throw PulumiNullFieldException("frequency"),
    )
}
