@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bcmdata.kotlin.inputs

import com.pulumi.aws.bcmdata.inputs.ExportTimeoutsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property create A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
 * @property update A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
 */
public data class ExportTimeoutsArgs(
    public val create: Output<String>? = null,
    public val update: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.bcmdata.inputs.ExportTimeoutsArgs> {
    override fun toJava(): com.pulumi.aws.bcmdata.inputs.ExportTimeoutsArgs =
        com.pulumi.aws.bcmdata.inputs.ExportTimeoutsArgs.builder()
            .create(create?.applyValue({ args0 -> args0 }))
            .update(update?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExportTimeoutsArgs].
 */
@PulumiTagMarker
public class ExportTimeoutsArgsBuilder internal constructor() {
    private var create: Output<String>? = null

    private var update: Output<String>? = null

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
     */
    @JvmName("geefreyynkepemla")
    public suspend fun create(`value`: Output<String>) {
        this.create = value
    }

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
     */
    @JvmName("xtwgyyeugmwdkxby")
    public suspend fun update(`value`: Output<String>) {
        this.update = value
    }

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
     */
    @JvmName("ujsqufauinnyvxdt")
    public suspend fun create(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.create = mapped
    }

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
     */
    @JvmName("eijglfxofnvihmgy")
    public suspend fun update(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.update = mapped
    }

    internal fun build(): ExportTimeoutsArgs = ExportTimeoutsArgs(
        create = create,
        update = update,
    )
}
