@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bcmdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dataQueries Data query for this specific data export. See the `data_query` argument reference below.
 * @property description Description for this specific data export.
 * @property destinationConfigurations Destination configuration for this specific data export. See the `destination_configurations` argument reference below.
 * @property exportArn Amazon Resource Name (ARN) for this export.
 * @property name Name of this specific data export.
 * @property refreshCadences Cadence for Amazon Web Services to update the export in your S3 bucket. See the `refresh_cadence` argument reference below.
 */
public data class ExportExport(
    public val dataQueries: List<ExportExportDataQuery>? = null,
    public val description: String? = null,
    public val destinationConfigurations: List<ExportExportDestinationConfiguration>? = null,
    public val exportArn: String? = null,
    public val name: String,
    public val refreshCadences: List<ExportExportRefreshCadence>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bcmdata.outputs.ExportExport): ExportExport =
            ExportExport(
                dataQueries = javaType.dataQueries().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.bcmdata.kotlin.outputs.ExportExportDataQuery.Companion.toKotlin(args0)
                    })
                }),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                destinationConfigurations = javaType.destinationConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.bcmdata.kotlin.outputs.ExportExportDestinationConfiguration.Companion.toKotlin(args0)
                    })
                }),
                exportArn = javaType.exportArn().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                refreshCadences = javaType.refreshCadences().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.bcmdata.kotlin.outputs.ExportExportRefreshCadence.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
