@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bcmdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property queryStatement Query statement.
 * @property tableConfigurations Table configuration.
 */
public data class ExportExportDataQuery(
    public val queryStatement: String,
    public val tableConfigurations: Map<String, Map<String, String>>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bcmdata.outputs.ExportExportDataQuery): ExportExportDataQuery = ExportExportDataQuery(
            queryStatement = javaType.queryStatement(),
            tableConfigurations = javaType.tableConfigurations().map({ args0 ->
                args0.key.to(args0.value.map({ args0 -> args0.key.to(args0.value) }).toMap())
            }).toMap(),
        )
    }
}
