@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bcmdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property s3Bucket Name of the Amazon S3 bucket used as the destination of a data export file.
 * @property s3OutputConfigurations Output configuration for the data export. See the `s3_output_configurations` argument reference below.
 * @property s3Prefix S3 path prefix you want prepended to the name of your data export.
 * @property s3Region S3 bucket region.
 */
public data class ExportExportDestinationConfigurationS3Destination(
    public val s3Bucket: String,
    public val s3OutputConfigurations: List<ExportExportDestinationConfigurationS3DestinationS3OutputConfiguration>? = null,
    public val s3Prefix: String,
    public val s3Region: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bcmdata.outputs.ExportExportDestinationConfigurationS3Destination): ExportExportDestinationConfigurationS3Destination =
            ExportExportDestinationConfigurationS3Destination(
                s3Bucket = javaType.s3Bucket(),
                s3OutputConfigurations = javaType.s3OutputConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.bcmdata.kotlin.outputs.ExportExportDestinationConfigurationS3DestinationS3OutputConfiguration.Companion.toKotlin(args0)
                    })
                }),
                s3Prefix = javaType.s3Prefix(),
                s3Region = javaType.s3Region(),
            )
    }
}
