@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bcmdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property compression Compression type for the data export. Valid values `GZIP`, `PARQUET`.
 * @property format File format for the data export. Valid values `TEXT_OR_CSV` or `PARQUET`.
 * @property outputType Output type for the data export. Valid value `CUSTOM`.
 * @property overwrite The rule to follow when generating a version of the data export file. You have the choice to overwrite the previous version or to be delivered in addition to the previous versions. Overwriting exports can save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data over time. Valid values `CREATE_NEW_REPORT` or `OVERWRITE_REPORT`.
 */
public data class ExportExportDestinationConfigurationS3DestinationS3OutputConfiguration(
    public val compression: String,
    public val format: String,
    public val outputType: String,
    public val overwrite: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bcmdata.outputs.ExportExportDestinationConfigurationS3DestinationS3OutputConfiguration): ExportExportDestinationConfigurationS3DestinationS3OutputConfiguration =
            ExportExportDestinationConfigurationS3DestinationS3OutputConfiguration(
                compression = javaType.compression(),
                format = javaType.format(),
                outputType = javaType.outputType(),
                overwrite = javaType.overwrite(),
            )
    }
}
