@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.aws.bedrock.kotlin.outputs.AgentAgentPromptOverrideConfiguration
import com.pulumi.aws.bedrock.kotlin.outputs.AgentAgentTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.bedrock.kotlin.outputs.AgentAgentPromptOverrideConfiguration.Companion.toKotlin as agentAgentPromptOverrideConfigurationToKotlin
import com.pulumi.aws.bedrock.kotlin.outputs.AgentAgentTimeouts.Companion.toKotlin as agentAgentTimeoutsToKotlin

/**
 * Builder for [AgentAgent].
 */
@PulumiTagMarker
public class AgentAgentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AgentAgentArgs = AgentAgentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AgentAgentArgsBuilder.() -> Unit) {
        val builder = AgentAgentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AgentAgent {
        val builtJavaResource = com.pulumi.aws.bedrock.AgentAgent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AgentAgent(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Agents for Amazon Bedrock Agent.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const currentGetPartition = aws.getPartition({});
 * const currentGetRegion = aws.getRegion({});
 * const exampleAgentTrust = Promise.all([current, currentGetPartition, currentGetRegion, current])&#46;then(([current, currentGetPartition, currentGetRegion, current1]) => aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             identifiers: ["bedrock&#46;amazonaws&#46;com"],
 *             type: "Service",
 *         }],
 *         conditions: [
 *             {
 *                 test: "StringEquals",
 *                 values: [current&#46;accountId],
 *                 variable: "aws:SourceAccount",
 *             },
 *             {
 *                 test: "ArnLike",
 *                 values: [`arn:${currentGetPartition&#46;partition}:bedrock:${currentGetRegion&#46;name}:${current1&#46;accountId}:agent/*`],
 *                 variable: "AWS:SourceArn",
 *             },
 *         ],
 *     }],
 * }));
 * const exampleAgentPermissions = Promise.all([currentGetPartition, currentGetRegion])&#46;then(([currentGetPartition, currentGetRegion]) => aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["bedrock:InvokeModel"],
 *         resources: [`arn:${currentGetPartition&#46;partition}:bedrock:${currentGetRegion&#46;name}::foundation-model/anthropic&#46;claude-v2`],
 *     }],
 * }));
 * const example = new aws.iam.Role("example", {
 *     assumeRolePolicy: exampleAgentTrust.then(exampleAgentTrust => exampleAgentTrust.json),
 *     namePrefix: "AmazonBedrockExecutionRoleForAgents_",
 * });
 * const exampleRolePolicy = new aws.iam.RolePolicy("example", {
 *     policy: exampleAgentPermissions.then(exampleAgentPermissions => exampleAgentPermissions.json),
 *     role: example.id,
 * });
 * const exampleAgentAgent = new aws.bedrock.AgentAgent("example", {
 *     agentName: "my-agent-name",
 *     agentResourceRoleArn: example.arn,
 *     idleSessionTtlInSeconds: 500,
 *     foundationModel: "anthropic.claude-v2",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * current_get_partition = aws.get_partition()
 * current_get_region = aws.get_region()
 * example_agent_trust = aws.iam.get_policy_document(statements=[{
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "identifiers": ["bedrock&#46;amazonaws&#46;com"],
 *         "type": "Service",
 *     }],
 *     "conditions": [
 *         {
 *             "test": "StringEquals",
 *             "values": [current&#46;account_id],
 *             "variable": "aws:SourceAccount",
 *         },
 *         {
 *             "test": "ArnLike",
 *             "values": [f"arn:{current_get_partition&#46;partition}:bedrock:{current_get_region&#46;name}:{current&#46;account_id}:agent/*"],
 *             "variable": "AWS:SourceArn",
 *         },
 *     ],
 * }])
 * example_agent_permissions = aws.iam.get_policy_document(statements=[{
 *     "actions": ["bedrock:InvokeModel"],
 *     "resources": [f"arn:{current_get_partition&#46;partition}:bedrock:{current_get_region&#46;name}::foundation-model/anthropic&#46;claude-v2"],
 * }])
 * example = aws.iam.Role("example",
 *     assume_role_policy=example_agent_trust.json,
 *     name_prefix="AmazonBedrockExecutionRoleForAgents_")
 * example_role_policy = aws.iam.RolePolicy("example",
 *     policy=example_agent_permissions.json,
 *     role=example.id)
 * example_agent_agent = aws.bedrock.AgentAgent("example",
 *     agent_name="my-agent-name",
 *     agent_resource_role_arn=example.arn,
 *     idle_session_ttl_in_seconds=500,
 *     foundation_model="anthropic.claude-v2")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var currentGetPartition = Aws.GetPartition.Invoke();
 *     var currentGetRegion = Aws.GetRegion.Invoke();
 *     var exampleAgentTrust = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Identifiers = new[]
 *                         {
 *                             "bedrock.amazonaws.com",
 *                         },
 *                         Type = "Service",
 *                     },
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "StringEquals",
 *                         Values = new[]
 *                         {
 *                             current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *                         },
 *                         Variable = "aws:SourceAccount",
 *                     },
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "ArnLike",
 *                         Values = new[]
 *                         {
 *                             $"arn:{currentGetPartition.Apply(getPartitionResult => getPartitionResult.Partition)}:bedrock:{currentGetRegion.Apply(getRegionResult => getRegionResult.Name)}:{current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:agent/*",
 *                         },
 *                         Variable = "AWS:SourceArn",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var exampleAgentPermissions = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "bedrock:InvokeModel",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     $"arn:{currentGetPartition.Apply(getPartitionResult => getPartitionResult.Partition)}:bedrock:{currentGetRegion.Apply(getRegionResult => getRegionResult.Name)}::foundation-model/anthropic.claude-v2",
 *                 },
 *             },
 *         },
 *     });
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         AssumeRolePolicy = exampleAgentTrust.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         NamePrefix = "AmazonBedrockExecutionRoleForAgents_",
 *     });
 *     var exampleRolePolicy = new Aws.Iam.RolePolicy("example", new()
 *     {
 *         Policy = exampleAgentPermissions.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         Role = example.Id,
 *     });
 *     var exampleAgentAgent = new Aws.Bedrock.AgentAgent("example", new()
 *     {
 *         AgentName = "my-agent-name",
 *         AgentResourceRoleArn = example.Arn,
 *         IdleSessionTtlInSeconds = 500,
 *         FoundationModel = "anthropic.claude-v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * current, err := aws.GetCallerIdentity(ctx, nil, nil);
 * if err != nil {
 * return err
 * }
 * currentGetPartition, err := aws.GetPartition(ctx, nil, nil);
 * if err != nil {
 * return err
 * }
 * currentGetRegion, err := aws.GetRegion(ctx, nil, nil);
 * if err != nil {
 * return err
 * }
 * exampleAgentTrust, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Actions: []string{
 * "sts:AssumeRole",
 * },
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Identifiers: []string{
 * "bedrock.amazonaws.com",
 * },
 * Type: "Service",
 * },
 * },
 * Conditions: []iam.GetPolicyDocumentStatementCondition{
 * {
 * Test: "StringEquals",
 * Values: interface{}{
 * current.AccountId,
 * },
 * Variable: "aws:SourceAccount",
 * },
 * {
 * Test: "ArnLike",
 * Values: []string{
 * fmt.Sprintf("arn:%v:bedrock:%v:%v:agent/*", currentGetPartition.Partition, currentGetRegion.Name, current.AccountId),
 * },
 * Variable: "AWS:SourceArn",
 * },
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * exampleAgentPermissions, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Actions: []string{
 * "bedrock:InvokeModel",
 * },
 * Resources: []string{
 * fmt.Sprintf("arn:%v:bedrock:%v::foundation-model/anthropic.claude-v2", currentGetPartition.Partition, currentGetRegion.Name),
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * example, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * AssumeRolePolicy: pulumi.String(exampleAgentTrust.Json),
 * NamePrefix: pulumi.String("AmazonBedrockExecutionRoleForAgents_"),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = iam.NewRolePolicy(ctx, "example", &iam.RolePolicyArgs{
 * Policy: pulumi.String(exampleAgentPermissions.Json),
 * Role: example.ID(),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = bedrock.NewAgentAgent(ctx, "example", &bedrock.AgentAgentArgs{
 * AgentName: pulumi.String("my-agent-name"),
 * AgentResourceRoleArn: example.Arn,
 * IdleSessionTtlInSeconds: pulumi.Int(500),
 * FoundationModel: pulumi.String("anthropic.claude-v2"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.bedrock.AgentAgent;
 * import com.pulumi.aws.bedrock.AgentAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var currentGetPartition = AwsFunctions.getPartition();
 *         final var currentGetRegion = AwsFunctions.getRegion();
 *         final var exampleAgentTrust = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("bedrock.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .conditions(
 *                     GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .values(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                         .variable("aws:SourceAccount")
 *                         .build(),
 *                     GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("ArnLike")
 *                         .values(String.format("arn:%s:bedrock:%s:%s:agent/*", currentGetPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentGetRegion.applyValue(getRegionResult -> getRegionResult.name()),current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         .variable("AWS:SourceArn")
 *                         .build())
 *                 .build())
 *             .build());
 *         final var exampleAgentPermissions = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("bedrock:InvokeModel")
 *                 .resources(String.format("arn:%s:bedrock:%s::foundation-model/anthropic.claude-v2", currentGetPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentGetRegion.applyValue(getRegionResult -> getRegionResult.name())))
 *                 .build())
 *             .build());
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(exampleAgentTrust.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .namePrefix("AmazonBedrockExecutionRoleForAgents_")
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .policy(exampleAgentPermissions.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .role(example.id())
 *             .build());
 *         var exampleAgentAgent = new AgentAgent("exampleAgentAgent", AgentAgentArgs.builder()
 *             .agentName("my-agent-name")
 *             .agentResourceRoleArn(example.arn())
 *             .idleSessionTtlInSeconds(500)
 *             .foundationModel("anthropic.claude-v2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       assumeRolePolicy: ${exampleAgentTrust.json}
 *       namePrefix: AmazonBedrockExecutionRoleForAgents_
 *   exampleRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: example
 *     properties:
 *       policy: ${exampleAgentPermissions.json}
 *       role: ${example.id}
 *   exampleAgentAgent:
 *     type: aws:bedrock:AgentAgent
 *     name: example
 *     properties:
 *       agentName: my-agent-name
 *       agentResourceRoleArn: ${example.arn}
 *       idleSessionTtlInSeconds: 500
 *       foundationModel: anthropic.claude-v2
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   currentGetPartition:
 *     fn::invoke:
 *       Function: aws:getPartition
 *       Arguments: {}
 *   currentGetRegion:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 *   exampleAgentTrust:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - identifiers:
 *                   - bedrock.amazonaws.com
 *                 type: Service
 *             conditions:
 *               - test: StringEquals
 *                 values:
 *                   - ${current.accountId}
 *                 variable: aws:SourceAccount
 *               - test: ArnLike
 *                 values:
 *                   - arn:${currentGetPartition.partition}:bedrock:${currentGetRegion.name}:${current.accountId}:agent/*
 *                 variable: AWS:SourceArn
 *   exampleAgentPermissions:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - bedrock:InvokeModel
 *             resources:
 *               - arn:${currentGetPartition.partition}:bedrock:${currentGetRegion.name}::foundation-model/anthropic.claude-v2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Agents for Amazon Bedrock Agent using the agent ID. For example:
 * ```sh
 * $ pulumi import aws:bedrock/agentAgent:AgentAgent example GGRRAED6JP
 * ```
 * */*/*/*/*/*/
 */
public class AgentAgent internal constructor(
    override val javaResource: com.pulumi.aws.bedrock.AgentAgent,
) : KotlinCustomResource(javaResource, AgentAgentMapper) {
    /**
     * ARN of the agent.
     */
    public val agentArn: Output<String>
        get() = javaResource.agentArn().applyValue({ args0 -> args0 })

    /**
     * Unique identifier of the agent.
     */
    public val agentId: Output<String>
        get() = javaResource.agentId().applyValue({ args0 -> args0 })

    /**
     * Name of the agent.
     */
    public val agentName: Output<String>
        get() = javaResource.agentName().applyValue({ args0 -> args0 })

    /**
     * ARN of the IAM role with permissions to invoke API operations on the agent.
     */
    public val agentResourceRoleArn: Output<String>
        get() = javaResource.agentResourceRoleArn().applyValue({ args0 -> args0 })

    /**
     * Version of the agent.
     */
    public val agentVersion: Output<String>
        get() = javaResource.agentVersion().applyValue({ args0 -> args0 })

    /**
     * ARN of the AWS KMS key that encrypts the agent.
     */
    public val customerEncryptionKeyArn: Output<String>?
        get() = javaResource.customerEncryptionKeyArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the agent.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Foundation model used for orchestration by the agent.
     * The following arguments are optional:
     */
    public val foundationModel: Output<String>
        get() = javaResource.foundationModel().applyValue({ args0 -> args0 })

    /**
     * Number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent. A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
     */
    public val idleSessionTtlInSeconds: Output<Int>
        get() = javaResource.idleSessionTtlInSeconds().applyValue({ args0 -> args0 })

    /**
     * Instructions that tell the agent what it should do and how it should interact with users.
     */
    public val instruction: Output<String>
        get() = javaResource.instruction().applyValue({ args0 -> args0 })

    /**
     * Whether to prepare the agent after creation or modification. Defaults to `true`.
     */
    public val prepareAgent: Output<Boolean>
        get() = javaResource.prepareAgent().applyValue({ args0 -> args0 })

    /**
     * Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
     */
    public val promptOverrideConfigurations: Output<List<AgentAgentPromptOverrideConfiguration>>
        get() = javaResource.promptOverrideConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> agentAgentPromptOverrideConfigurationToKotlin(args0) })
            })
        })

    /**
     * Whether the in-use check is skipped when deleting the agent.
     */
    public val skipResourceInUseCheck: Output<Boolean>
        get() = javaResource.skipResourceInUseCheck().applyValue({ args0 -> args0 })

    /**
     * Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<AgentAgentTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    agentAgentTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object AgentAgentMapper : ResourceMapper<AgentAgent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.bedrock.AgentAgent::class == javaResource::class

    override fun map(javaResource: Resource): AgentAgent = AgentAgent(
        javaResource as
            com.pulumi.aws.bedrock.AgentAgent,
    )
}

/**
 * @see [AgentAgent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AgentAgent].
 */
public suspend fun agentAgent(name: String, block: suspend AgentAgentResourceBuilder.() -> Unit): AgentAgent {
    val builder = AgentAgentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AgentAgent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun agentAgent(name: String): AgentAgent {
    val builder = AgentAgentResourceBuilder()
    builder.name(name)
    return builder.build()
}
