@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.aws.bedrock.kotlin.outputs.AgentAgentAliasRoutingConfiguration
import com.pulumi.aws.bedrock.kotlin.outputs.AgentAgentAliasTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.bedrock.kotlin.outputs.AgentAgentAliasRoutingConfiguration.Companion.toKotlin as agentAgentAliasRoutingConfigurationToKotlin
import com.pulumi.aws.bedrock.kotlin.outputs.AgentAgentAliasTimeouts.Companion.toKotlin as agentAgentAliasTimeoutsToKotlin

/**
 * Builder for [AgentAgentAlias].
 */
@PulumiTagMarker
public class AgentAgentAliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AgentAgentAliasArgs = AgentAgentAliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AgentAgentAliasArgsBuilder.() -> Unit) {
        val builder = AgentAgentAliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AgentAgentAlias {
        val builtJavaResource = com.pulumi.aws.bedrock.AgentAgentAlias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AgentAgentAlias(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Agents for Amazon Bedrock Agent Alias.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       assumeRolePolicy: ${exampleAgentTrust.json}
 *       namePrefix: AmazonBedrockExecutionRoleForAgents_
 *   exampleRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: example
 *     properties:
 *       policy: ${exampleAgentPermissions.json}
 *       role: ${example.id}
 *   exampleAgentAgent:
 *     type: aws:bedrock:AgentAgent
 *     name: example
 *     properties:
 *       agentName: my-agent-name
 *       agentResourceRoleArn: ${example.arn}
 *       idleTtl: 500
 *       foundationModel: anthropic.claude-v2
 *   exampleAgentAgentAlias:
 *     type: aws:bedrock:AgentAgentAlias
 *     name: example
 *     properties:
 *       agentAliasName: my-agent-alias
 *       agentId: ${exampleAgentAgent.agentId}
 *       description: Test Alias
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   currentGetPartition:
 *     fn::invoke:
 *       Function: aws:getPartition
 *       Arguments: {}
 *   currentGetRegion:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 *   exampleAgentTrust:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - identifiers:
 *                   - bedrock.amazonaws.com
 *                 type: Service
 *             conditions:
 *               - test: StringEquals
 *                 values:
 *                   - ${current.accountId}
 *                 variable: aws:SourceAccount
 *               - test: ArnLike
 *                 values:
 *                   - arn:${currentGetPartition.partition}:bedrock:${currentGetRegion.name}:${current.accountId}:agent/*
 *                 variable: AWS:SourceArn
 *   exampleAgentPermissions:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - bedrock:InvokeModel
 *             resources:
 *               - arn:${currentGetPartition.partition}:bedrock:${currentGetRegion.name}::foundation-model/anthropic.claude-v2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Agents for Amazon Bedrock Agent Alias using the alias ID and the agent ID separated by `,`. For example:
 * ```sh
 * $ pulumi import aws:bedrock/agentAgentAlias:AgentAgentAlias example 66IVY0GUTF,GGRRAED6JP
 * ```
 * */
 */
public class AgentAgentAlias internal constructor(
    override val javaResource: com.pulumi.aws.bedrock.AgentAgentAlias,
) : KotlinCustomResource(javaResource, AgentAgentAliasMapper) {
    /**
     * ARN of the alias.
     */
    public val agentAliasArn: Output<String>
        get() = javaResource.agentAliasArn().applyValue({ args0 -> args0 })

    /**
     * Unique identifier of the alias.
     */
    public val agentAliasId: Output<String>
        get() = javaResource.agentAliasId().applyValue({ args0 -> args0 })

    /**
     * Name of the alias.
     */
    public val agentAliasName: Output<String>
        get() = javaResource.agentAliasName().applyValue({ args0 -> args0 })

    /**
     * Identifier of the agent to create an alias for.
     * The following arguments are optional:
     */
    public val agentId: Output<String>
        get() = javaResource.agentId().applyValue({ args0 -> args0 })

    /**
     * Description of the alias.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Details about the routing configuration of the alias. See `routing_configuration` Block for details.
     */
    public val routingConfigurations: Output<List<AgentAgentAliasRoutingConfiguration>>
        get() = javaResource.routingConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> agentAgentAliasRoutingConfigurationToKotlin(args0) })
            })
        })

    /**
     * Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<AgentAgentAliasTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    agentAgentAliasTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object AgentAgentAliasMapper : ResourceMapper<AgentAgentAlias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.bedrock.AgentAgentAlias::class == javaResource::class

    override fun map(javaResource: Resource): AgentAgentAlias = AgentAgentAlias(
        javaResource as
            com.pulumi.aws.bedrock.AgentAgentAlias,
    )
}

/**
 * @see [AgentAgentAlias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AgentAgentAlias].
 */
public suspend fun agentAgentAlias(
    name: String,
    block: suspend AgentAgentAliasResourceBuilder.() -> Unit,
): AgentAgentAlias {
    val builder = AgentAgentAliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AgentAgentAlias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun agentAgentAlias(name: String): AgentAgentAlias {
    val builder = AgentAgentAliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
