@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.aws.bedrock.AgentAgentAliasArgs.builder
import com.pulumi.aws.bedrock.kotlin.inputs.AgentAgentAliasRoutingConfigurationArgs
import com.pulumi.aws.bedrock.kotlin.inputs.AgentAgentAliasRoutingConfigurationArgsBuilder
import com.pulumi.aws.bedrock.kotlin.inputs.AgentAgentAliasTimeoutsArgs
import com.pulumi.aws.bedrock.kotlin.inputs.AgentAgentAliasTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Agents for Amazon Bedrock Agent Alias.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       assumeRolePolicy: ${exampleAgentTrust.json}
 *       namePrefix: AmazonBedrockExecutionRoleForAgents_
 *   exampleRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: example
 *     properties:
 *       policy: ${exampleAgentPermissions.json}
 *       role: ${example.id}
 *   exampleAgentAgent:
 *     type: aws:bedrock:AgentAgent
 *     name: example
 *     properties:
 *       agentName: my-agent-name
 *       agentResourceRoleArn: ${example.arn}
 *       idleTtl: 500
 *       foundationModel: anthropic.claude-v2
 *   exampleAgentAgentAlias:
 *     type: aws:bedrock:AgentAgentAlias
 *     name: example
 *     properties:
 *       agentAliasName: my-agent-alias
 *       agentId: ${exampleAgentAgent.agentId}
 *       description: Test Alias
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   currentGetPartition:
 *     fn::invoke:
 *       Function: aws:getPartition
 *       Arguments: {}
 *   currentGetRegion:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 *   exampleAgentTrust:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - identifiers:
 *                   - bedrock.amazonaws.com
 *                 type: Service
 *             conditions:
 *               - test: StringEquals
 *                 values:
 *                   - ${current.accountId}
 *                 variable: aws:SourceAccount
 *               - test: ArnLike
 *                 values:
 *                   - arn:${currentGetPartition.partition}:bedrock:${currentGetRegion.name}:${current.accountId}:agent/*
 *                 variable: AWS:SourceArn
 *   exampleAgentPermissions:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - bedrock:InvokeModel
 *             resources:
 *               - arn:${currentGetPartition.partition}:bedrock:${currentGetRegion.name}::foundation-model/anthropic.claude-v2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Agents for Amazon Bedrock Agent Alias using the alias ID and the agent ID separated by `,`. For example:
 * ```sh
 * $ pulumi import aws:bedrock/agentAgentAlias:AgentAgentAlias example 66IVY0GUTF,GGRRAED6JP
 * ```
 * @property agentAliasName Name of the alias.
 * @property agentId Identifier of the agent to create an alias for.
 * The following arguments are optional:
 * @property description Description of the alias.
 * @property routingConfigurations Details about the routing configuration of the alias. See `routing_configuration` Block for details.
 * @property tags Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 * */
 */
public data class AgentAgentAliasArgs(
    public val agentAliasName: Output<String>? = null,
    public val agentId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val routingConfigurations: Output<List<AgentAgentAliasRoutingConfigurationArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<AgentAgentAliasTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrock.AgentAgentAliasArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.AgentAgentAliasArgs =
        com.pulumi.aws.bedrock.AgentAgentAliasArgs.builder()
            .agentAliasName(agentAliasName?.applyValue({ args0 -> args0 }))
            .agentId(agentId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .routingConfigurations(
                routingConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AgentAgentAliasArgs].
 */
@PulumiTagMarker
public class AgentAgentAliasArgsBuilder internal constructor() {
    private var agentAliasName: Output<String>? = null

    private var agentId: Output<String>? = null

    private var description: Output<String>? = null

    private var routingConfigurations: Output<List<AgentAgentAliasRoutingConfigurationArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<AgentAgentAliasTimeoutsArgs>? = null

    /**
     * @param value Name of the alias.
     */
    @JvmName("umunnatirfwroonp")
    public suspend fun agentAliasName(`value`: Output<String>) {
        this.agentAliasName = value
    }

    /**
     * @param value Identifier of the agent to create an alias for.
     * The following arguments are optional:
     */
    @JvmName("kqfcamfqedvodsjv")
    public suspend fun agentId(`value`: Output<String>) {
        this.agentId = value
    }

    /**
     * @param value Description of the alias.
     */
    @JvmName("ulbiffyhaouqnxhy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Details about the routing configuration of the alias. See `routing_configuration` Block for details.
     */
    @JvmName("jsacbyrsmgpxgcgm")
    public suspend fun routingConfigurations(`value`: Output<List<AgentAgentAliasRoutingConfigurationArgs>>) {
        this.routingConfigurations = value
    }

    @JvmName("dkhcpfiyqeitcfle")
    public suspend fun routingConfigurations(vararg values: Output<AgentAgentAliasRoutingConfigurationArgs>) {
        this.routingConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Details about the routing configuration of the alias. See `routing_configuration` Block for details.
     */
    @JvmName("alyarrmyvpeejadm")
    public suspend fun routingConfigurations(values: List<Output<AgentAgentAliasRoutingConfigurationArgs>>) {
        this.routingConfigurations = Output.all(values)
    }

    /**
     * @param value Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xxoniuufmjyriejp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("mxhltomhyjxsdkwm")
    public suspend fun timeouts(`value`: Output<AgentAgentAliasTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Name of the alias.
     */
    @JvmName("nsywpayaibghtfvt")
    public suspend fun agentAliasName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentAliasName = mapped
    }

    /**
     * @param value Identifier of the agent to create an alias for.
     * The following arguments are optional:
     */
    @JvmName("yhclqsjipeymxnfo")
    public suspend fun agentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentId = mapped
    }

    /**
     * @param value Description of the alias.
     */
    @JvmName("eufexwfsmpxegyri")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Details about the routing configuration of the alias. See `routing_configuration` Block for details.
     */
    @JvmName("ivnloybvlvipjpiv")
    public suspend fun routingConfigurations(`value`: List<AgentAgentAliasRoutingConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingConfigurations = mapped
    }

    /**
     * @param argument Details about the routing configuration of the alias. See `routing_configuration` Block for details.
     */
    @JvmName("fbhxmdatvikwrcor")
    public suspend fun routingConfigurations(argument: List<suspend AgentAgentAliasRoutingConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AgentAgentAliasRoutingConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.routingConfigurations = mapped
    }

    /**
     * @param argument Details about the routing configuration of the alias. See `routing_configuration` Block for details.
     */
    @JvmName("gjbqeatrvlfdymnb")
    public suspend fun routingConfigurations(vararg argument: suspend AgentAgentAliasRoutingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AgentAgentAliasRoutingConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.routingConfigurations = mapped
    }

    /**
     * @param argument Details about the routing configuration of the alias. See `routing_configuration` Block for details.
     */
    @JvmName("xfrpxlebvkhctkoi")
    public suspend fun routingConfigurations(argument: suspend AgentAgentAliasRoutingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AgentAgentAliasRoutingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.routingConfigurations = mapped
    }

    /**
     * @param values Details about the routing configuration of the alias. See `routing_configuration` Block for details.
     */
    @JvmName("viayphrewpypkjde")
    public suspend fun routingConfigurations(vararg values: AgentAgentAliasRoutingConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingConfigurations = mapped
    }

    /**
     * @param value Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xsilwbguyipdyafu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pryessyhfirkibso")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("amojcqjpmpwuxhpk")
    public suspend fun timeouts(`value`: AgentAgentAliasTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("avrvrkpqwjwfufbp")
    public suspend fun timeouts(argument: suspend AgentAgentAliasTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = AgentAgentAliasTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): AgentAgentAliasArgs = AgentAgentAliasArgs(
        agentAliasName = agentAliasName,
        agentId = agentId,
        description = description,
        routingConfigurations = routingConfigurations,
        tags = tags,
        timeouts = timeouts,
    )
}
