@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.aws.bedrock.AgentAgentArgs.builder
import com.pulumi.aws.bedrock.kotlin.inputs.AgentAgentPromptOverrideConfigurationArgs
import com.pulumi.aws.bedrock.kotlin.inputs.AgentAgentPromptOverrideConfigurationArgsBuilder
import com.pulumi.aws.bedrock.kotlin.inputs.AgentAgentTimeoutsArgs
import com.pulumi.aws.bedrock.kotlin.inputs.AgentAgentTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Agents for Amazon Bedrock Agent.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const currentGetPartition = aws.getPartition({});
 * const currentGetRegion = aws.getRegion({});
 * const exampleAgentTrust = Promise.all([current, currentGetPartition, currentGetRegion, current])&#46;then(([current, currentGetPartition, currentGetRegion, current1]) => aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             identifiers: ["bedrock&#46;amazonaws&#46;com"],
 *             type: "Service",
 *         }],
 *         conditions: [
 *             {
 *                 test: "StringEquals",
 *                 values: [current&#46;accountId],
 *                 variable: "aws:SourceAccount",
 *             },
 *             {
 *                 test: "ArnLike",
 *                 values: [`arn:${currentGetPartition&#46;partition}:bedrock:${currentGetRegion&#46;name}:${current1&#46;accountId}:agent/*`],
 *                 variable: "AWS:SourceArn",
 *             },
 *         ],
 *     }],
 * }));
 * const exampleAgentPermissions = Promise.all([currentGetPartition, currentGetRegion])&#46;then(([currentGetPartition, currentGetRegion]) => aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["bedrock:InvokeModel"],
 *         resources: [`arn:${currentGetPartition&#46;partition}:bedrock:${currentGetRegion&#46;name}::foundation-model/anthropic&#46;claude-v2`],
 *     }],
 * }));
 * const example = new aws.iam.Role("example", {
 *     assumeRolePolicy: exampleAgentTrust.then(exampleAgentTrust => exampleAgentTrust.json),
 *     namePrefix: "AmazonBedrockExecutionRoleForAgents_",
 * });
 * const exampleRolePolicy = new aws.iam.RolePolicy("example", {
 *     policy: exampleAgentPermissions.then(exampleAgentPermissions => exampleAgentPermissions.json),
 *     role: example.id,
 * });
 * const exampleAgentAgent = new aws.bedrock.AgentAgent("example", {
 *     agentName: "my-agent-name",
 *     agentResourceRoleArn: example.arn,
 *     idleSessionTtlInSeconds: 500,
 *     foundationModel: "anthropic.claude-v2",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * current_get_partition = aws.get_partition()
 * current_get_region = aws.get_region()
 * example_agent_trust = aws.iam.get_policy_document(statements=[{
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "identifiers": ["bedrock&#46;amazonaws&#46;com"],
 *         "type": "Service",
 *     }],
 *     "conditions": [
 *         {
 *             "test": "StringEquals",
 *             "values": [current&#46;account_id],
 *             "variable": "aws:SourceAccount",
 *         },
 *         {
 *             "test": "ArnLike",
 *             "values": [f"arn:{current_get_partition&#46;partition}:bedrock:{current_get_region&#46;name}:{current&#46;account_id}:agent/*"],
 *             "variable": "AWS:SourceArn",
 *         },
 *     ],
 * }])
 * example_agent_permissions = aws.iam.get_policy_document(statements=[{
 *     "actions": ["bedrock:InvokeModel"],
 *     "resources": [f"arn:{current_get_partition&#46;partition}:bedrock:{current_get_region&#46;name}::foundation-model/anthropic&#46;claude-v2"],
 * }])
 * example = aws.iam.Role("example",
 *     assume_role_policy=example_agent_trust.json,
 *     name_prefix="AmazonBedrockExecutionRoleForAgents_")
 * example_role_policy = aws.iam.RolePolicy("example",
 *     policy=example_agent_permissions.json,
 *     role=example.id)
 * example_agent_agent = aws.bedrock.AgentAgent("example",
 *     agent_name="my-agent-name",
 *     agent_resource_role_arn=example.arn,
 *     idle_session_ttl_in_seconds=500,
 *     foundation_model="anthropic.claude-v2")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var currentGetPartition = Aws.GetPartition.Invoke();
 *     var currentGetRegion = Aws.GetRegion.Invoke();
 *     var exampleAgentTrust = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Identifiers = new[]
 *                         {
 *                             "bedrock.amazonaws.com",
 *                         },
 *                         Type = "Service",
 *                     },
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "StringEquals",
 *                         Values = new[]
 *                         {
 *                             current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
 *                         },
 *                         Variable = "aws:SourceAccount",
 *                     },
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "ArnLike",
 *                         Values = new[]
 *                         {
 *                             $"arn:{currentGetPartition.Apply(getPartitionResult => getPartitionResult.Partition)}:bedrock:{currentGetRegion.Apply(getRegionResult => getRegionResult.Name)}:{current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:agent/*",
 *                         },
 *                         Variable = "AWS:SourceArn",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var exampleAgentPermissions = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "bedrock:InvokeModel",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     $"arn:{currentGetPartition.Apply(getPartitionResult => getPartitionResult.Partition)}:bedrock:{currentGetRegion.Apply(getRegionResult => getRegionResult.Name)}::foundation-model/anthropic.claude-v2",
 *                 },
 *             },
 *         },
 *     });
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         AssumeRolePolicy = exampleAgentTrust.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         NamePrefix = "AmazonBedrockExecutionRoleForAgents_",
 *     });
 *     var exampleRolePolicy = new Aws.Iam.RolePolicy("example", new()
 *     {
 *         Policy = exampleAgentPermissions.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         Role = example.Id,
 *     });
 *     var exampleAgentAgent = new Aws.Bedrock.AgentAgent("example", new()
 *     {
 *         AgentName = "my-agent-name",
 *         AgentResourceRoleArn = example.Arn,
 *         IdleSessionTtlInSeconds = 500,
 *         FoundationModel = "anthropic.claude-v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * current, err := aws.GetCallerIdentity(ctx, nil, nil);
 * if err != nil {
 * return err
 * }
 * currentGetPartition, err := aws.GetPartition(ctx, nil, nil);
 * if err != nil {
 * return err
 * }
 * currentGetRegion, err := aws.GetRegion(ctx, nil, nil);
 * if err != nil {
 * return err
 * }
 * exampleAgentTrust, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Actions: []string{
 * "sts:AssumeRole",
 * },
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Identifiers: []string{
 * "bedrock.amazonaws.com",
 * },
 * Type: "Service",
 * },
 * },
 * Conditions: []iam.GetPolicyDocumentStatementCondition{
 * {
 * Test: "StringEquals",
 * Values: interface{}{
 * current.AccountId,
 * },
 * Variable: "aws:SourceAccount",
 * },
 * {
 * Test: "ArnLike",
 * Values: []string{
 * fmt.Sprintf("arn:%v:bedrock:%v:%v:agent/*", currentGetPartition.Partition, currentGetRegion.Name, current.AccountId),
 * },
 * Variable: "AWS:SourceArn",
 * },
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * exampleAgentPermissions, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Actions: []string{
 * "bedrock:InvokeModel",
 * },
 * Resources: []string{
 * fmt.Sprintf("arn:%v:bedrock:%v::foundation-model/anthropic.claude-v2", currentGetPartition.Partition, currentGetRegion.Name),
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * example, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * AssumeRolePolicy: pulumi.String(exampleAgentTrust.Json),
 * NamePrefix: pulumi.String("AmazonBedrockExecutionRoleForAgents_"),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = iam.NewRolePolicy(ctx, "example", &iam.RolePolicyArgs{
 * Policy: pulumi.String(exampleAgentPermissions.Json),
 * Role: example.ID(),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = bedrock.NewAgentAgent(ctx, "example", &bedrock.AgentAgentArgs{
 * AgentName: pulumi.String("my-agent-name"),
 * AgentResourceRoleArn: example.Arn,
 * IdleSessionTtlInSeconds: pulumi.Int(500),
 * FoundationModel: pulumi.String("anthropic.claude-v2"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.bedrock.AgentAgent;
 * import com.pulumi.aws.bedrock.AgentAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var currentGetPartition = AwsFunctions.getPartition();
 *         final var currentGetRegion = AwsFunctions.getRegion();
 *         final var exampleAgentTrust = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("bedrock.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .conditions(
 *                     GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .values(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                         .variable("aws:SourceAccount")
 *                         .build(),
 *                     GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("ArnLike")
 *                         .values(String.format("arn:%s:bedrock:%s:%s:agent/*", currentGetPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentGetRegion.applyValue(getRegionResult -> getRegionResult.name()),current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         .variable("AWS:SourceArn")
 *                         .build())
 *                 .build())
 *             .build());
 *         final var exampleAgentPermissions = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("bedrock:InvokeModel")
 *                 .resources(String.format("arn:%s:bedrock:%s::foundation-model/anthropic.claude-v2", currentGetPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentGetRegion.applyValue(getRegionResult -> getRegionResult.name())))
 *                 .build())
 *             .build());
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(exampleAgentTrust.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .namePrefix("AmazonBedrockExecutionRoleForAgents_")
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .policy(exampleAgentPermissions.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .role(example.id())
 *             .build());
 *         var exampleAgentAgent = new AgentAgent("exampleAgentAgent", AgentAgentArgs.builder()
 *             .agentName("my-agent-name")
 *             .agentResourceRoleArn(example.arn())
 *             .idleSessionTtlInSeconds(500)
 *             .foundationModel("anthropic.claude-v2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       assumeRolePolicy: ${exampleAgentTrust.json}
 *       namePrefix: AmazonBedrockExecutionRoleForAgents_
 *   exampleRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: example
 *     properties:
 *       policy: ${exampleAgentPermissions.json}
 *       role: ${example.id}
 *   exampleAgentAgent:
 *     type: aws:bedrock:AgentAgent
 *     name: example
 *     properties:
 *       agentName: my-agent-name
 *       agentResourceRoleArn: ${example.arn}
 *       idleSessionTtlInSeconds: 500
 *       foundationModel: anthropic.claude-v2
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   currentGetPartition:
 *     fn::invoke:
 *       Function: aws:getPartition
 *       Arguments: {}
 *   currentGetRegion:
 *     fn::invoke:
 *       Function: aws:getRegion
 *       Arguments: {}
 *   exampleAgentTrust:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - identifiers:
 *                   - bedrock.amazonaws.com
 *                 type: Service
 *             conditions:
 *               - test: StringEquals
 *                 values:
 *                   - ${current.accountId}
 *                 variable: aws:SourceAccount
 *               - test: ArnLike
 *                 values:
 *                   - arn:${currentGetPartition.partition}:bedrock:${currentGetRegion.name}:${current.accountId}:agent/*
 *                 variable: AWS:SourceArn
 *   exampleAgentPermissions:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - bedrock:InvokeModel
 *             resources:
 *               - arn:${currentGetPartition.partition}:bedrock:${currentGetRegion.name}::foundation-model/anthropic.claude-v2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Agents for Amazon Bedrock Agent using the agent ID. For example:
 * ```sh
 * $ pulumi import aws:bedrock/agentAgent:AgentAgent example GGRRAED6JP
 * ```
 * @property agentName Name of the agent.
 * @property agentResourceRoleArn ARN of the IAM role with permissions to invoke API operations on the agent.
 * @property customerEncryptionKeyArn ARN of the AWS KMS key that encrypts the agent.
 * @property description Description of the agent.
 * @property foundationModel Foundation model used for orchestration by the agent.
 * The following arguments are optional:
 * @property idleSessionTtlInSeconds Number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent. A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
 * @property instruction Instructions that tell the agent what it should do and how it should interact with users.
 * @property prepareAgent Whether to prepare the agent after creation or modification. Defaults to `true`.
 * @property promptOverrideConfigurations Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
 * @property skipResourceInUseCheck Whether the in-use check is skipped when deleting the agent.
 * @property tags Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 * */*/*/*/*/*/
 */
public data class AgentAgentArgs(
    public val agentName: Output<String>? = null,
    public val agentResourceRoleArn: Output<String>? = null,
    public val customerEncryptionKeyArn: Output<String>? = null,
    public val description: Output<String>? = null,
    public val foundationModel: Output<String>? = null,
    public val idleSessionTtlInSeconds: Output<Int>? = null,
    public val instruction: Output<String>? = null,
    public val prepareAgent: Output<Boolean>? = null,
    public val promptOverrideConfigurations: Output<List<AgentAgentPromptOverrideConfigurationArgs>>? =
        null,
    public val skipResourceInUseCheck: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<AgentAgentTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrock.AgentAgentArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.AgentAgentArgs =
        com.pulumi.aws.bedrock.AgentAgentArgs.builder()
            .agentName(agentName?.applyValue({ args0 -> args0 }))
            .agentResourceRoleArn(agentResourceRoleArn?.applyValue({ args0 -> args0 }))
            .customerEncryptionKeyArn(customerEncryptionKeyArn?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .foundationModel(foundationModel?.applyValue({ args0 -> args0 }))
            .idleSessionTtlInSeconds(idleSessionTtlInSeconds?.applyValue({ args0 -> args0 }))
            .instruction(instruction?.applyValue({ args0 -> args0 }))
            .prepareAgent(prepareAgent?.applyValue({ args0 -> args0 }))
            .promptOverrideConfigurations(
                promptOverrideConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .skipResourceInUseCheck(skipResourceInUseCheck?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AgentAgentArgs].
 */
@PulumiTagMarker
public class AgentAgentArgsBuilder internal constructor() {
    private var agentName: Output<String>? = null

    private var agentResourceRoleArn: Output<String>? = null

    private var customerEncryptionKeyArn: Output<String>? = null

    private var description: Output<String>? = null

    private var foundationModel: Output<String>? = null

    private var idleSessionTtlInSeconds: Output<Int>? = null

    private var instruction: Output<String>? = null

    private var prepareAgent: Output<Boolean>? = null

    private var promptOverrideConfigurations: Output<List<AgentAgentPromptOverrideConfigurationArgs>>? =
        null

    private var skipResourceInUseCheck: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<AgentAgentTimeoutsArgs>? = null

    /**
     * @param value Name of the agent.
     */
    @JvmName("ixiafoexkxiiitgo")
    public suspend fun agentName(`value`: Output<String>) {
        this.agentName = value
    }

    /**
     * @param value ARN of the IAM role with permissions to invoke API operations on the agent.
     */
    @JvmName("mjxsacqtyspgntkf")
    public suspend fun agentResourceRoleArn(`value`: Output<String>) {
        this.agentResourceRoleArn = value
    }

    /**
     * @param value ARN of the AWS KMS key that encrypts the agent.
     */
    @JvmName("qqhyudqpupgvtjfo")
    public suspend fun customerEncryptionKeyArn(`value`: Output<String>) {
        this.customerEncryptionKeyArn = value
    }

    /**
     * @param value Description of the agent.
     */
    @JvmName("beebwnovtwxpvnrq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Foundation model used for orchestration by the agent.
     * The following arguments are optional:
     */
    @JvmName("qltsbtrllhpvubho")
    public suspend fun foundationModel(`value`: Output<String>) {
        this.foundationModel = value
    }

    /**
     * @param value Number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent. A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
     */
    @JvmName("ofjyycxrofhomepd")
    public suspend fun idleSessionTtlInSeconds(`value`: Output<Int>) {
        this.idleSessionTtlInSeconds = value
    }

    /**
     * @param value Instructions that tell the agent what it should do and how it should interact with users.
     */
    @JvmName("gsshpkebnxnwtkec")
    public suspend fun instruction(`value`: Output<String>) {
        this.instruction = value
    }

    /**
     * @param value Whether to prepare the agent after creation or modification. Defaults to `true`.
     */
    @JvmName("ininhwfsmifaeduu")
    public suspend fun prepareAgent(`value`: Output<Boolean>) {
        this.prepareAgent = value
    }

    /**
     * @param value Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
     */
    @JvmName("qicvvpdyejvcraot")
    public suspend fun promptOverrideConfigurations(`value`: Output<List<AgentAgentPromptOverrideConfigurationArgs>>) {
        this.promptOverrideConfigurations = value
    }

    @JvmName("ucqjejwxqyihqnxt")
    public suspend fun promptOverrideConfigurations(vararg values: Output<AgentAgentPromptOverrideConfigurationArgs>) {
        this.promptOverrideConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
     */
    @JvmName("nhqfmviwfjkqjqbf")
    public suspend fun promptOverrideConfigurations(values: List<Output<AgentAgentPromptOverrideConfigurationArgs>>) {
        this.promptOverrideConfigurations = Output.all(values)
    }

    /**
     * @param value Whether the in-use check is skipped when deleting the agent.
     */
    @JvmName("wwqtstckovplviel")
    public suspend fun skipResourceInUseCheck(`value`: Output<Boolean>) {
        this.skipResourceInUseCheck = value
    }

    /**
     * @param value Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("getgqrelstbflryn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("skjiyeeottagrpsr")
    public suspend fun timeouts(`value`: Output<AgentAgentTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Name of the agent.
     */
    @JvmName("khxvpbhlnhpnbxak")
    public suspend fun agentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentName = mapped
    }

    /**
     * @param value ARN of the IAM role with permissions to invoke API operations on the agent.
     */
    @JvmName("erlgcmqnurcitjnj")
    public suspend fun agentResourceRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentResourceRoleArn = mapped
    }

    /**
     * @param value ARN of the AWS KMS key that encrypts the agent.
     */
    @JvmName("ibhwqoybedtrbksk")
    public suspend fun customerEncryptionKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerEncryptionKeyArn = mapped
    }

    /**
     * @param value Description of the agent.
     */
    @JvmName("pdsyddbbtseqbvdc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Foundation model used for orchestration by the agent.
     * The following arguments are optional:
     */
    @JvmName("yedcfutimsdtvdgv")
    public suspend fun foundationModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.foundationModel = mapped
    }

    /**
     * @param value Number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent. A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
     */
    @JvmName("jksnjxeuamyrwfnl")
    public suspend fun idleSessionTtlInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleSessionTtlInSeconds = mapped
    }

    /**
     * @param value Instructions that tell the agent what it should do and how it should interact with users.
     */
    @JvmName("dbekserwkjwqqbtn")
    public suspend fun instruction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instruction = mapped
    }

    /**
     * @param value Whether to prepare the agent after creation or modification. Defaults to `true`.
     */
    @JvmName("tpxkhbprnchufhgp")
    public suspend fun prepareAgent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prepareAgent = mapped
    }

    /**
     * @param value Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
     */
    @JvmName("hminwkifqvocgweb")
    public suspend fun promptOverrideConfigurations(`value`: List<AgentAgentPromptOverrideConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promptOverrideConfigurations = mapped
    }

    /**
     * @param argument Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
     */
    @JvmName("xmivbjqxleltqbea")
    public suspend fun promptOverrideConfigurations(argument: List<suspend AgentAgentPromptOverrideConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AgentAgentPromptOverrideConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.promptOverrideConfigurations = mapped
    }

    /**
     * @param argument Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
     */
    @JvmName("gnmewaqyanhhmfyu")
    public suspend fun promptOverrideConfigurations(vararg argument: suspend AgentAgentPromptOverrideConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AgentAgentPromptOverrideConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.promptOverrideConfigurations = mapped
    }

    /**
     * @param argument Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
     */
    @JvmName("mciiuyxhedbfueqo")
    public suspend fun promptOverrideConfigurations(argument: suspend AgentAgentPromptOverrideConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AgentAgentPromptOverrideConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.promptOverrideConfigurations = mapped
    }

    /**
     * @param values Configurations to override prompt templates in different parts of an agent sequence. For more information, see [Advanced prompts](https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html). See `prompt_override_configuration` Block for details.
     */
    @JvmName("ruedyhaynccfkhud")
    public suspend fun promptOverrideConfigurations(vararg values: AgentAgentPromptOverrideConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.promptOverrideConfigurations = mapped
    }

    /**
     * @param value Whether the in-use check is skipped when deleting the agent.
     */
    @JvmName("ckhfpmgdwhjgjrwi")
    public suspend fun skipResourceInUseCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipResourceInUseCheck = mapped
    }

    /**
     * @param value Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hfmasfarfnkkljhw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vgjsjwwktjstorfu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("anbupypfnsyrvvta")
    public suspend fun timeouts(`value`: AgentAgentTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("oywmldayylowhpik")
    public suspend fun timeouts(argument: suspend AgentAgentTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = AgentAgentTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): AgentAgentArgs = AgentAgentArgs(
        agentName = agentName,
        agentResourceRoleArn = agentResourceRoleArn,
        customerEncryptionKeyArn = customerEncryptionKeyArn,
        description = description,
        foundationModel = foundationModel,
        idleSessionTtlInSeconds = idleSessionTtlInSeconds,
        instruction = instruction,
        prepareAgent = prepareAgent,
        promptOverrideConfigurations = promptOverrideConfigurations,
        skipResourceInUseCheck = skipResourceInUseCheck,
        tags = tags,
        timeouts = timeouts,
    )
}
