@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AgentAgentKnowledgeBaseAssociation].
 */
@PulumiTagMarker
public class AgentAgentKnowledgeBaseAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AgentAgentKnowledgeBaseAssociationArgs = AgentAgentKnowledgeBaseAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AgentAgentKnowledgeBaseAssociationArgsBuilder.() -> Unit) {
        val builder = AgentAgentKnowledgeBaseAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AgentAgentKnowledgeBaseAssociation {
        val builtJavaResource =
            com.pulumi.aws.bedrock.AgentAgentKnowledgeBaseAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AgentAgentKnowledgeBaseAssociation(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Agents for Amazon Bedrock Agent Knowledge Base Association.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.bedrock.AgentAgentKnowledgeBaseAssociation("example", {
 *     agentId: "GGRRAED6JP",
 *     description: "Example Knowledge base",
 *     knowledgeBaseId: "EMDPPAYPZI",
 *     knowledgeBaseState: "ENABLED",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.bedrock.AgentAgentKnowledgeBaseAssociation("example",
 *     agent_id="GGRRAED6JP",
 *     description="Example Knowledge base",
 *     knowledge_base_id="EMDPPAYPZI",
 *     knowledge_base_state="ENABLED")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Bedrock.AgentAgentKnowledgeBaseAssociation("example", new()
 *     {
 *         AgentId = "GGRRAED6JP",
 *         Description = "Example Knowledge base",
 *         KnowledgeBaseId = "EMDPPAYPZI",
 *         KnowledgeBaseState = "ENABLED",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := bedrock.NewAgentAgentKnowledgeBaseAssociation(ctx, "example", &bedrock.AgentAgentKnowledgeBaseAssociationArgs{
 * 			AgentId:            pulumi.String("GGRRAED6JP"),
 * 			Description:        pulumi.String("Example Knowledge base"),
 * 			KnowledgeBaseId:    pulumi.String("EMDPPAYPZI"),
 * 			KnowledgeBaseState: pulumi.String("ENABLED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.bedrock.AgentAgentKnowledgeBaseAssociation;
 * import com.pulumi.aws.bedrock.AgentAgentKnowledgeBaseAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AgentAgentKnowledgeBaseAssociation("example", AgentAgentKnowledgeBaseAssociationArgs.builder()
 *             .agentId("GGRRAED6JP")
 *             .description("Example Knowledge base")
 *             .knowledgeBaseId("EMDPPAYPZI")
 *             .knowledgeBaseState("ENABLED")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:bedrock:AgentAgentKnowledgeBaseAssociation
 *     properties:
 *       agentId: GGRRAED6JP
 *       description: Example Knowledge base
 *       knowledgeBaseId: EMDPPAYPZI
 *       knowledgeBaseState: ENABLED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Agents for Amazon Bedrock Agent Knowledge Base Association using the agent ID, the agent version, and the knowledge base ID separated by `,`. For example:
 * ```sh
 * $ pulumi import aws:bedrock/agentAgentKnowledgeBaseAssociation:AgentAgentKnowledgeBaseAssociation example GGRRAED6JP,DRAFT,EMDPPAYPZI
 * ```
 */
public class AgentAgentKnowledgeBaseAssociation internal constructor(
    override val javaResource: com.pulumi.aws.bedrock.AgentAgentKnowledgeBaseAssociation,
) : KotlinCustomResource(javaResource, AgentAgentKnowledgeBaseAssociationMapper) {
    /**
     * Unique identifier of the agent with which you want to associate the knowledge base.
     */
    public val agentId: Output<String>
        get() = javaResource.agentId().applyValue({ args0 -> args0 })

    /**
     * Version of the agent with which you want to associate the knowledge base. Valid values: `DRAFT`.
     */
    public val agentVersion: Output<String>
        get() = javaResource.agentVersion().applyValue({ args0 -> args0 })

    /**
     * Description of what the agent should use the knowledge base for.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Unique identifier of the knowledge base to associate with the agent.
     */
    public val knowledgeBaseId: Output<String>
        get() = javaResource.knowledgeBaseId().applyValue({ args0 -> args0 })

    /**
     * Whether to use the knowledge base when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request. Valid values: `ENABLED`, `DISABLED`.
     * The following arguments are optional:
     */
    public val knowledgeBaseState: Output<String>
        get() = javaResource.knowledgeBaseState().applyValue({ args0 -> args0 })
}

public object AgentAgentKnowledgeBaseAssociationMapper :
    ResourceMapper<AgentAgentKnowledgeBaseAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.bedrock.AgentAgentKnowledgeBaseAssociation::class == javaResource::class

    override fun map(javaResource: Resource): AgentAgentKnowledgeBaseAssociation =
        AgentAgentKnowledgeBaseAssociation(
            javaResource as
                com.pulumi.aws.bedrock.AgentAgentKnowledgeBaseAssociation,
        )
}

/**
 * @see [AgentAgentKnowledgeBaseAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AgentAgentKnowledgeBaseAssociation].
 */
public suspend fun agentAgentKnowledgeBaseAssociation(
    name: String,
    block: suspend AgentAgentKnowledgeBaseAssociationResourceBuilder.() -> Unit,
): AgentAgentKnowledgeBaseAssociation {
    val builder = AgentAgentKnowledgeBaseAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AgentAgentKnowledgeBaseAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun agentAgentKnowledgeBaseAssociation(name: String): AgentAgentKnowledgeBaseAssociation {
    val builder = AgentAgentKnowledgeBaseAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
