@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.aws.bedrock.AgentAgentKnowledgeBaseAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Agents for Amazon Bedrock Agent Knowledge Base Association.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.bedrock.AgentAgentKnowledgeBaseAssociation("example", {
 *     agentId: "GGRRAED6JP",
 *     description: "Example Knowledge base",
 *     knowledgeBaseId: "EMDPPAYPZI",
 *     knowledgeBaseState: "ENABLED",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.bedrock.AgentAgentKnowledgeBaseAssociation("example",
 *     agent_id="GGRRAED6JP",
 *     description="Example Knowledge base",
 *     knowledge_base_id="EMDPPAYPZI",
 *     knowledge_base_state="ENABLED")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Bedrock.AgentAgentKnowledgeBaseAssociation("example", new()
 *     {
 *         AgentId = "GGRRAED6JP",
 *         Description = "Example Knowledge base",
 *         KnowledgeBaseId = "EMDPPAYPZI",
 *         KnowledgeBaseState = "ENABLED",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := bedrock.NewAgentAgentKnowledgeBaseAssociation(ctx, "example", &bedrock.AgentAgentKnowledgeBaseAssociationArgs{
 * 			AgentId:            pulumi.String("GGRRAED6JP"),
 * 			Description:        pulumi.String("Example Knowledge base"),
 * 			KnowledgeBaseId:    pulumi.String("EMDPPAYPZI"),
 * 			KnowledgeBaseState: pulumi.String("ENABLED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.bedrock.AgentAgentKnowledgeBaseAssociation;
 * import com.pulumi.aws.bedrock.AgentAgentKnowledgeBaseAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AgentAgentKnowledgeBaseAssociation("example", AgentAgentKnowledgeBaseAssociationArgs.builder()
 *             .agentId("GGRRAED6JP")
 *             .description("Example Knowledge base")
 *             .knowledgeBaseId("EMDPPAYPZI")
 *             .knowledgeBaseState("ENABLED")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:bedrock:AgentAgentKnowledgeBaseAssociation
 *     properties:
 *       agentId: GGRRAED6JP
 *       description: Example Knowledge base
 *       knowledgeBaseId: EMDPPAYPZI
 *       knowledgeBaseState: ENABLED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Agents for Amazon Bedrock Agent Knowledge Base Association using the agent ID, the agent version, and the knowledge base ID separated by `,`. For example:
 * ```sh
 * $ pulumi import aws:bedrock/agentAgentKnowledgeBaseAssociation:AgentAgentKnowledgeBaseAssociation example GGRRAED6JP,DRAFT,EMDPPAYPZI
 * ```
 * @property agentId Unique identifier of the agent with which you want to associate the knowledge base.
 * @property agentVersion Version of the agent with which you want to associate the knowledge base. Valid values: `DRAFT`.
 * @property description Description of what the agent should use the knowledge base for.
 * @property knowledgeBaseId Unique identifier of the knowledge base to associate with the agent.
 * @property knowledgeBaseState Whether to use the knowledge base when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request. Valid values: `ENABLED`, `DISABLED`.
 * The following arguments are optional:
 */
public data class AgentAgentKnowledgeBaseAssociationArgs(
    public val agentId: Output<String>? = null,
    public val agentVersion: Output<String>? = null,
    public val description: Output<String>? = null,
    public val knowledgeBaseId: Output<String>? = null,
    public val knowledgeBaseState: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrock.AgentAgentKnowledgeBaseAssociationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.AgentAgentKnowledgeBaseAssociationArgs =
        com.pulumi.aws.bedrock.AgentAgentKnowledgeBaseAssociationArgs.builder()
            .agentId(agentId?.applyValue({ args0 -> args0 }))
            .agentVersion(agentVersion?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .knowledgeBaseId(knowledgeBaseId?.applyValue({ args0 -> args0 }))
            .knowledgeBaseState(knowledgeBaseState?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentAgentKnowledgeBaseAssociationArgs].
 */
@PulumiTagMarker
public class AgentAgentKnowledgeBaseAssociationArgsBuilder internal constructor() {
    private var agentId: Output<String>? = null

    private var agentVersion: Output<String>? = null

    private var description: Output<String>? = null

    private var knowledgeBaseId: Output<String>? = null

    private var knowledgeBaseState: Output<String>? = null

    /**
     * @param value Unique identifier of the agent with which you want to associate the knowledge base.
     */
    @JvmName("kyktpkqgpbbwrndn")
    public suspend fun agentId(`value`: Output<String>) {
        this.agentId = value
    }

    /**
     * @param value Version of the agent with which you want to associate the knowledge base. Valid values: `DRAFT`.
     */
    @JvmName("aydkbvalojiphmbw")
    public suspend fun agentVersion(`value`: Output<String>) {
        this.agentVersion = value
    }

    /**
     * @param value Description of what the agent should use the knowledge base for.
     */
    @JvmName("qsyuuabigeihgceq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Unique identifier of the knowledge base to associate with the agent.
     */
    @JvmName("rhvhvbfhnmaiakow")
    public suspend fun knowledgeBaseId(`value`: Output<String>) {
        this.knowledgeBaseId = value
    }

    /**
     * @param value Whether to use the knowledge base when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request. Valid values: `ENABLED`, `DISABLED`.
     * The following arguments are optional:
     */
    @JvmName("tpfuwcuurrnueifo")
    public suspend fun knowledgeBaseState(`value`: Output<String>) {
        this.knowledgeBaseState = value
    }

    /**
     * @param value Unique identifier of the agent with which you want to associate the knowledge base.
     */
    @JvmName("cugkdliptqmsmrvv")
    public suspend fun agentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentId = mapped
    }

    /**
     * @param value Version of the agent with which you want to associate the knowledge base. Valid values: `DRAFT`.
     */
    @JvmName("dhsndqsfjindgeao")
    public suspend fun agentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentVersion = mapped
    }

    /**
     * @param value Description of what the agent should use the knowledge base for.
     */
    @JvmName("bljahboaxynxpecy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Unique identifier of the knowledge base to associate with the agent.
     */
    @JvmName("yfyeantdhntdgujh")
    public suspend fun knowledgeBaseId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.knowledgeBaseId = mapped
    }

    /**
     * @param value Whether to use the knowledge base when sending an [InvokeAgent](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html) request. Valid values: `ENABLED`, `DISABLED`.
     * The following arguments are optional:
     */
    @JvmName("dkvpkgqejamrfmwg")
    public suspend fun knowledgeBaseState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.knowledgeBaseState = mapped
    }

    internal fun build(): AgentAgentKnowledgeBaseAssociationArgs =
        AgentAgentKnowledgeBaseAssociationArgs(
            agentId = agentId,
            agentVersion = agentVersion,
            description = description,
            knowledgeBaseId = knowledgeBaseId,
            knowledgeBaseState = knowledgeBaseState,
        )
}
