@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.aws.bedrock.kotlin.outputs.AgentDataSourceDataSourceConfiguration
import com.pulumi.aws.bedrock.kotlin.outputs.AgentDataSourceServerSideEncryptionConfiguration
import com.pulumi.aws.bedrock.kotlin.outputs.AgentDataSourceTimeouts
import com.pulumi.aws.bedrock.kotlin.outputs.AgentDataSourceVectorIngestionConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.bedrock.kotlin.outputs.AgentDataSourceDataSourceConfiguration.Companion.toKotlin as agentDataSourceDataSourceConfigurationToKotlin
import com.pulumi.aws.bedrock.kotlin.outputs.AgentDataSourceServerSideEncryptionConfiguration.Companion.toKotlin as agentDataSourceServerSideEncryptionConfigurationToKotlin
import com.pulumi.aws.bedrock.kotlin.outputs.AgentDataSourceTimeouts.Companion.toKotlin as agentDataSourceTimeoutsToKotlin
import com.pulumi.aws.bedrock.kotlin.outputs.AgentDataSourceVectorIngestionConfiguration.Companion.toKotlin as agentDataSourceVectorIngestionConfigurationToKotlin

/**
 * Builder for [AgentDataSource].
 */
@PulumiTagMarker
public class AgentDataSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AgentDataSourceArgs = AgentDataSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AgentDataSourceArgsBuilder.() -> Unit) {
        val builder = AgentDataSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AgentDataSource {
        val builtJavaResource = com.pulumi.aws.bedrock.AgentDataSource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AgentDataSource(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Agents for Amazon Bedrock Data Source.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.bedrock.AgentDataSource("example", {
 *     knowledgeBaseId: "EMDPPAYPZI",
 *     name: "example",
 *     dataSourceConfiguration: {
 *         type: "S3",
 *         s3Configuration: {
 *             bucketArn: "arn:aws:s3:::example-bucket",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.bedrock.AgentDataSource("example",
 *     knowledge_base_id="EMDPPAYPZI",
 *     name="example",
 *     data_source_configuration={
 *         "type": "S3",
 *         "s3_configuration": {
 *             "bucket_arn": "arn:aws:s3:::example-bucket",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Bedrock.AgentDataSource("example", new()
 *     {
 *         KnowledgeBaseId = "EMDPPAYPZI",
 *         Name = "example",
 *         DataSourceConfiguration = new Aws.Bedrock.Inputs.AgentDataSourceDataSourceConfigurationArgs
 *         {
 *             Type = "S3",
 *             S3Configuration = new Aws.Bedrock.Inputs.AgentDataSourceDataSourceConfigurationS3ConfigurationArgs
 *             {
 *                 BucketArn = "arn:aws:s3:::example-bucket",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := bedrock.NewAgentDataSource(ctx, "example", &bedrock.AgentDataSourceArgs{
 * 			KnowledgeBaseId: pulumi.String("EMDPPAYPZI"),
 * 			Name:            pulumi.String("example"),
 * 			DataSourceConfiguration: &bedrock.AgentDataSourceDataSourceConfigurationArgs{
 * 				Type: pulumi.String("S3"),
 * 				S3Configuration: &bedrock.AgentDataSourceDataSourceConfigurationS3ConfigurationArgs{
 * 					BucketArn: pulumi.String("arn:aws:s3:::example-bucket"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.bedrock.AgentDataSource;
 * import com.pulumi.aws.bedrock.AgentDataSourceArgs;
 * import com.pulumi.aws.bedrock.inputs.AgentDataSourceDataSourceConfigurationArgs;
 * import com.pulumi.aws.bedrock.inputs.AgentDataSourceDataSourceConfigurationS3ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AgentDataSource("example", AgentDataSourceArgs.builder()
 *             .knowledgeBaseId("EMDPPAYPZI")
 *             .name("example")
 *             .dataSourceConfiguration(AgentDataSourceDataSourceConfigurationArgs.builder()
 *                 .type("S3")
 *                 .s3Configuration(AgentDataSourceDataSourceConfigurationS3ConfigurationArgs.builder()
 *                     .bucketArn("arn:aws:s3:::example-bucket")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:bedrock:AgentDataSource
 *     properties:
 *       knowledgeBaseId: EMDPPAYPZI
 *       name: example
 *       dataSourceConfiguration:
 *         type: S3
 *         s3Configuration:
 *           bucketArn: arn:aws:s3:::example-bucket
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Agents for Amazon Bedrock Data Source using the data source ID and the knowledge base ID. For example:
 * ```sh
 * $ pulumi import aws:bedrock/agentDataSource:AgentDataSource example GWCMFMQF6T,EMDPPAYPZI
 * ```
 */
public class AgentDataSource internal constructor(
    override val javaResource: com.pulumi.aws.bedrock.AgentDataSource,
) : KotlinCustomResource(javaResource, AgentDataSourceMapper) {
    /**
     * Data deletion policy for a data source. Valid values: `RETAIN`, `DELETE`.
     */
    public val dataDeletionPolicy: Output<String>
        get() = javaResource.dataDeletionPolicy().applyValue({ args0 -> args0 })

    /**
     * Details about how the data source is stored. See `data_source_configuration` block for details.
     */
    public val dataSourceConfiguration: Output<AgentDataSourceDataSourceConfiguration>?
        get() = javaResource.dataSourceConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> agentDataSourceDataSourceConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Unique identifier of the data source.
     */
    public val dataSourceId: Output<String>
        get() = javaResource.dataSourceId().applyValue({ args0 -> args0 })

    /**
     * Description of the data source.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique identifier of the knowledge base to which the data source belongs.
     */
    public val knowledgeBaseId: Output<String>
        get() = javaResource.knowledgeBaseId().applyValue({ args0 -> args0 })

    /**
     * Name of the data source.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Details about the configuration of the server-side encryption. See `server_side_encryption_configuration` block for details.
     */
    public val serverSideEncryptionConfiguration:
        Output<AgentDataSourceServerSideEncryptionConfiguration>?
        get() = javaResource.serverSideEncryptionConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    agentDataSourceServerSideEncryptionConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    public val timeouts: Output<AgentDataSourceTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    agentDataSourceTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Details about the configuration of the server-side encryption. See `vector_ingestion_configuration` block for details.
     */
    public val vectorIngestionConfiguration: Output<AgentDataSourceVectorIngestionConfiguration>?
        get() = javaResource.vectorIngestionConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    agentDataSourceVectorIngestionConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object AgentDataSourceMapper : ResourceMapper<AgentDataSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.bedrock.AgentDataSource::class == javaResource::class

    override fun map(javaResource: Resource): AgentDataSource = AgentDataSource(
        javaResource as
            com.pulumi.aws.bedrock.AgentDataSource,
    )
}

/**
 * @see [AgentDataSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AgentDataSource].
 */
public suspend fun agentDataSource(
    name: String,
    block: suspend AgentDataSourceResourceBuilder.() -> Unit,
): AgentDataSource {
    val builder = AgentDataSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AgentDataSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun agentDataSource(name: String): AgentDataSource {
    val builder = AgentDataSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
