@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.aws.bedrock.AgentDataSourceArgs.builder
import com.pulumi.aws.bedrock.kotlin.inputs.AgentDataSourceDataSourceConfigurationArgs
import com.pulumi.aws.bedrock.kotlin.inputs.AgentDataSourceDataSourceConfigurationArgsBuilder
import com.pulumi.aws.bedrock.kotlin.inputs.AgentDataSourceServerSideEncryptionConfigurationArgs
import com.pulumi.aws.bedrock.kotlin.inputs.AgentDataSourceServerSideEncryptionConfigurationArgsBuilder
import com.pulumi.aws.bedrock.kotlin.inputs.AgentDataSourceTimeoutsArgs
import com.pulumi.aws.bedrock.kotlin.inputs.AgentDataSourceTimeoutsArgsBuilder
import com.pulumi.aws.bedrock.kotlin.inputs.AgentDataSourceVectorIngestionConfigurationArgs
import com.pulumi.aws.bedrock.kotlin.inputs.AgentDataSourceVectorIngestionConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Agents for Amazon Bedrock Data Source.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.bedrock.AgentDataSource("example", {
 *     knowledgeBaseId: "EMDPPAYPZI",
 *     name: "example",
 *     dataSourceConfiguration: {
 *         type: "S3",
 *         s3Configuration: {
 *             bucketArn: "arn:aws:s3:::example-bucket",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.bedrock.AgentDataSource("example",
 *     knowledge_base_id="EMDPPAYPZI",
 *     name="example",
 *     data_source_configuration={
 *         "type": "S3",
 *         "s3_configuration": {
 *             "bucket_arn": "arn:aws:s3:::example-bucket",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Bedrock.AgentDataSource("example", new()
 *     {
 *         KnowledgeBaseId = "EMDPPAYPZI",
 *         Name = "example",
 *         DataSourceConfiguration = new Aws.Bedrock.Inputs.AgentDataSourceDataSourceConfigurationArgs
 *         {
 *             Type = "S3",
 *             S3Configuration = new Aws.Bedrock.Inputs.AgentDataSourceDataSourceConfigurationS3ConfigurationArgs
 *             {
 *                 BucketArn = "arn:aws:s3:::example-bucket",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := bedrock.NewAgentDataSource(ctx, "example", &bedrock.AgentDataSourceArgs{
 * 			KnowledgeBaseId: pulumi.String("EMDPPAYPZI"),
 * 			Name:            pulumi.String("example"),
 * 			DataSourceConfiguration: &bedrock.AgentDataSourceDataSourceConfigurationArgs{
 * 				Type: pulumi.String("S3"),
 * 				S3Configuration: &bedrock.AgentDataSourceDataSourceConfigurationS3ConfigurationArgs{
 * 					BucketArn: pulumi.String("arn:aws:s3:::example-bucket"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.bedrock.AgentDataSource;
 * import com.pulumi.aws.bedrock.AgentDataSourceArgs;
 * import com.pulumi.aws.bedrock.inputs.AgentDataSourceDataSourceConfigurationArgs;
 * import com.pulumi.aws.bedrock.inputs.AgentDataSourceDataSourceConfigurationS3ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AgentDataSource("example", AgentDataSourceArgs.builder()
 *             .knowledgeBaseId("EMDPPAYPZI")
 *             .name("example")
 *             .dataSourceConfiguration(AgentDataSourceDataSourceConfigurationArgs.builder()
 *                 .type("S3")
 *                 .s3Configuration(AgentDataSourceDataSourceConfigurationS3ConfigurationArgs.builder()
 *                     .bucketArn("arn:aws:s3:::example-bucket")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:bedrock:AgentDataSource
 *     properties:
 *       knowledgeBaseId: EMDPPAYPZI
 *       name: example
 *       dataSourceConfiguration:
 *         type: S3
 *         s3Configuration:
 *           bucketArn: arn:aws:s3:::example-bucket
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Agents for Amazon Bedrock Data Source using the data source ID and the knowledge base ID. For example:
 * ```sh
 * $ pulumi import aws:bedrock/agentDataSource:AgentDataSource example GWCMFMQF6T,EMDPPAYPZI
 * ```
 * @property dataDeletionPolicy Data deletion policy for a data source. Valid values: `RETAIN`, `DELETE`.
 * @property dataSourceConfiguration Details about how the data source is stored. See `data_source_configuration` block for details.
 * @property description Description of the data source.
 * @property knowledgeBaseId Unique identifier of the knowledge base to which the data source belongs.
 * @property name Name of the data source.
 * The following arguments are optional:
 * @property serverSideEncryptionConfiguration Details about the configuration of the server-side encryption. See `server_side_encryption_configuration` block for details.
 * @property timeouts
 * @property vectorIngestionConfiguration Details about the configuration of the server-side encryption. See `vector_ingestion_configuration` block for details.
 */
public data class AgentDataSourceArgs(
    public val dataDeletionPolicy: Output<String>? = null,
    public val dataSourceConfiguration: Output<AgentDataSourceDataSourceConfigurationArgs>? = null,
    public val description: Output<String>? = null,
    public val knowledgeBaseId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val serverSideEncryptionConfiguration: Output<AgentDataSourceServerSideEncryptionConfigurationArgs>? = null,
    public val timeouts: Output<AgentDataSourceTimeoutsArgs>? = null,
    public val vectorIngestionConfiguration: Output<AgentDataSourceVectorIngestionConfigurationArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.bedrock.AgentDataSourceArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.AgentDataSourceArgs =
        com.pulumi.aws.bedrock.AgentDataSourceArgs.builder()
            .dataDeletionPolicy(dataDeletionPolicy?.applyValue({ args0 -> args0 }))
            .dataSourceConfiguration(
                dataSourceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .knowledgeBaseId(knowledgeBaseId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .serverSideEncryptionConfiguration(
                serverSideEncryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vectorIngestionConfiguration(
                vectorIngestionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [AgentDataSourceArgs].
 */
@PulumiTagMarker
public class AgentDataSourceArgsBuilder internal constructor() {
    private var dataDeletionPolicy: Output<String>? = null

    private var dataSourceConfiguration: Output<AgentDataSourceDataSourceConfigurationArgs>? = null

    private var description: Output<String>? = null

    private var knowledgeBaseId: Output<String>? = null

    private var name: Output<String>? = null

    private var serverSideEncryptionConfiguration:
        Output<AgentDataSourceServerSideEncryptionConfigurationArgs>? = null

    private var timeouts: Output<AgentDataSourceTimeoutsArgs>? = null

    private var vectorIngestionConfiguration: Output<AgentDataSourceVectorIngestionConfigurationArgs>? =
        null

    /**
     * @param value Data deletion policy for a data source. Valid values: `RETAIN`, `DELETE`.
     */
    @JvmName("jtibmkhwsyjpuxel")
    public suspend fun dataDeletionPolicy(`value`: Output<String>) {
        this.dataDeletionPolicy = value
    }

    /**
     * @param value Details about how the data source is stored. See `data_source_configuration` block for details.
     */
    @JvmName("bsyhtfplgsxuffwh")
    public suspend fun dataSourceConfiguration(`value`: Output<AgentDataSourceDataSourceConfigurationArgs>) {
        this.dataSourceConfiguration = value
    }

    /**
     * @param value Description of the data source.
     */
    @JvmName("rauidnwlerclrfgf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Unique identifier of the knowledge base to which the data source belongs.
     */
    @JvmName("phmbcqxowtusachy")
    public suspend fun knowledgeBaseId(`value`: Output<String>) {
        this.knowledgeBaseId = value
    }

    /**
     * @param value Name of the data source.
     * The following arguments are optional:
     */
    @JvmName("uxlaqevqciewbrga")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Details about the configuration of the server-side encryption. See `server_side_encryption_configuration` block for details.
     */
    @JvmName("ssnsvoxasgxsdcgi")
    public suspend fun serverSideEncryptionConfiguration(`value`: Output<AgentDataSourceServerSideEncryptionConfigurationArgs>) {
        this.serverSideEncryptionConfiguration = value
    }

    /**
     * @param value
     */
    @JvmName("mrrafwgjrdjtbvrb")
    public suspend fun timeouts(`value`: Output<AgentDataSourceTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Details about the configuration of the server-side encryption. See `vector_ingestion_configuration` block for details.
     */
    @JvmName("jafuajupxhrkfxwd")
    public suspend fun vectorIngestionConfiguration(`value`: Output<AgentDataSourceVectorIngestionConfigurationArgs>) {
        this.vectorIngestionConfiguration = value
    }

    /**
     * @param value Data deletion policy for a data source. Valid values: `RETAIN`, `DELETE`.
     */
    @JvmName("bhpqtqmtceqajdrl")
    public suspend fun dataDeletionPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDeletionPolicy = mapped
    }

    /**
     * @param value Details about how the data source is stored. See `data_source_configuration` block for details.
     */
    @JvmName("icpcdqjkiijeiflr")
    public suspend fun dataSourceConfiguration(`value`: AgentDataSourceDataSourceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceConfiguration = mapped
    }

    /**
     * @param argument Details about how the data source is stored. See `data_source_configuration` block for details.
     */
    @JvmName("bdmqatjmtlaabwdx")
    public suspend fun dataSourceConfiguration(argument: suspend AgentDataSourceDataSourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AgentDataSourceDataSourceConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataSourceConfiguration = mapped
    }

    /**
     * @param value Description of the data source.
     */
    @JvmName("qbtyllcoieqxuwos")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Unique identifier of the knowledge base to which the data source belongs.
     */
    @JvmName("tdoeinswlpylalma")
    public suspend fun knowledgeBaseId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.knowledgeBaseId = mapped
    }

    /**
     * @param value Name of the data source.
     * The following arguments are optional:
     */
    @JvmName("iaantxoidygralph")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Details about the configuration of the server-side encryption. See `server_side_encryption_configuration` block for details.
     */
    @JvmName("tbqmslpnnqddifhx")
    public suspend fun serverSideEncryptionConfiguration(`value`: AgentDataSourceServerSideEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryptionConfiguration = mapped
    }

    /**
     * @param argument Details about the configuration of the server-side encryption. See `server_side_encryption_configuration` block for details.
     */
    @JvmName("qhpkdmkiwyfajwpq")
    public suspend fun serverSideEncryptionConfiguration(argument: suspend AgentDataSourceServerSideEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AgentDataSourceServerSideEncryptionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serverSideEncryptionConfiguration = mapped
    }

    /**
     * @param value
     */
    @JvmName("lgqedeaulvcpqipc")
    public suspend fun timeouts(`value`: AgentDataSourceTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bpegaqyubtnmexpv")
    public suspend fun timeouts(argument: suspend AgentDataSourceTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = AgentDataSourceTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value Details about the configuration of the server-side encryption. See `vector_ingestion_configuration` block for details.
     */
    @JvmName("okatnmhqssrhnyma")
    public suspend fun vectorIngestionConfiguration(`value`: AgentDataSourceVectorIngestionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vectorIngestionConfiguration = mapped
    }

    /**
     * @param argument Details about the configuration of the server-side encryption. See `vector_ingestion_configuration` block for details.
     */
    @JvmName("hawayeokwafmfcln")
    public suspend fun vectorIngestionConfiguration(argument: suspend AgentDataSourceVectorIngestionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AgentDataSourceVectorIngestionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vectorIngestionConfiguration = mapped
    }

    internal fun build(): AgentDataSourceArgs = AgentDataSourceArgs(
        dataDeletionPolicy = dataDeletionPolicy,
        dataSourceConfiguration = dataSourceConfiguration,
        description = description,
        knowledgeBaseId = knowledgeBaseId,
        name = name,
        serverSideEncryptionConfiguration = serverSideEncryptionConfiguration,
        timeouts = timeouts,
        vectorIngestionConfiguration = vectorIngestionConfiguration,
    )
}
