@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseKnowledgeBaseConfiguration
import com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseStorageConfiguration
import com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseKnowledgeBaseConfiguration.Companion.toKotlin as agentKnowledgeBaseKnowledgeBaseConfigurationToKotlin
import com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseStorageConfiguration.Companion.toKotlin as agentKnowledgeBaseStorageConfigurationToKotlin
import com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseTimeouts.Companion.toKotlin as agentKnowledgeBaseTimeoutsToKotlin

/**
 * Builder for [AgentKnowledgeBase].
 */
@PulumiTagMarker
public class AgentKnowledgeBaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AgentKnowledgeBaseArgs = AgentKnowledgeBaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AgentKnowledgeBaseArgsBuilder.() -> Unit) {
        val builder = AgentKnowledgeBaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AgentKnowledgeBase {
        val builtJavaResource = com.pulumi.aws.bedrock.AgentKnowledgeBase(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AgentKnowledgeBase(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Agents for Amazon Bedrock Knowledge Base.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.bedrock.AgentKnowledgeBase("example", {
 *     name: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     knowledgeBaseConfiguration: {
 *         vectorKnowledgeBaseConfiguration: {
 *             embeddingModelArn: "arn:aws:bedrock:us-west-2::foundation-model/amazon.titan-embed-text-v1",
 *         },
 *         type: "VECTOR",
 *     },
 *     storageConfiguration: {
 *         type: "OPENSEARCH_SERVERLESS",
 *         opensearchServerlessConfiguration: {
 *             collectionArn: "arn:aws:aoss:us-west-2:123456789012:collection/142bezjddq707i5stcrf",
 *             vectorIndexName: "bedrock-knowledge-base-default-index",
 *             fieldMapping: {
 *                 vectorField: "bedrock-knowledge-base-default-vector",
 *                 textField: "AMAZON_BEDROCK_TEXT_CHUNK",
 *                 metadataField: "AMAZON_BEDROCK_METADATA",
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.bedrock.AgentKnowledgeBase("example",
 *     name="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     knowledge_base_configuration={
 *         "vector_knowledge_base_configuration": {
 *             "embedding_model_arn": "arn:aws:bedrock:us-west-2::foundation-model/amazon.titan-embed-text-v1",
 *         },
 *         "type": "VECTOR",
 *     },
 *     storage_configuration={
 *         "type": "OPENSEARCH_SERVERLESS",
 *         "opensearch_serverless_configuration": {
 *             "collection_arn": "arn:aws:aoss:us-west-2:123456789012:collection/142bezjddq707i5stcrf",
 *             "vector_index_name": "bedrock-knowledge-base-default-index",
 *             "field_mapping": {
 *                 "vector_field": "bedrock-knowledge-base-default-vector",
 *                 "text_field": "AMAZON_BEDROCK_TEXT_CHUNK",
 *                 "metadata_field": "AMAZON_BEDROCK_METADATA",
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Bedrock.AgentKnowledgeBase("example", new()
 *     {
 *         Name = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         KnowledgeBaseConfiguration = new Aws.Bedrock.Inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationArgs
 *         {
 *             VectorKnowledgeBaseConfiguration = new Aws.Bedrock.Inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs
 *             {
 *                 EmbeddingModelArn = "arn:aws:bedrock:us-west-2::foundation-model/amazon.titan-embed-text-v1",
 *             },
 *             Type = "VECTOR",
 *         },
 *         StorageConfiguration = new Aws.Bedrock.Inputs.AgentKnowledgeBaseStorageConfigurationArgs
 *         {
 *             Type = "OPENSEARCH_SERVERLESS",
 *             OpensearchServerlessConfiguration = new Aws.Bedrock.Inputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs
 *             {
 *                 CollectionArn = "arn:aws:aoss:us-west-2:123456789012:collection/142bezjddq707i5stcrf",
 *                 VectorIndexName = "bedrock-knowledge-base-default-index",
 *                 FieldMapping = new Aws.Bedrock.Inputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMappingArgs
 *                 {
 *                     VectorField = "bedrock-knowledge-base-default-vector",
 *                     TextField = "AMAZON_BEDROCK_TEXT_CHUNK",
 *                     MetadataField = "AMAZON_BEDROCK_METADATA",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := bedrock.NewAgentKnowledgeBase(ctx, "example", &bedrock.AgentKnowledgeBaseArgs{
 * 			Name:    pulumi.String("example"),
 * 			RoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			KnowledgeBaseConfiguration: &bedrock.AgentKnowledgeBaseKnowledgeBaseConfigurationArgs{
 * 				VectorKnowledgeBaseConfiguration: &bedrock.AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs{
 * 					EmbeddingModelArn: pulumi.String("arn:aws:bedrock:us-west-2::foundation-model/amazon.titan-embed-text-v1"),
 * 				},
 * 				Type: pulumi.String("VECTOR"),
 * 			},
 * 			StorageConfiguration: &bedrock.AgentKnowledgeBaseStorageConfigurationArgs{
 * 				Type: pulumi.String("OPENSEARCH_SERVERLESS"),
 * 				OpensearchServerlessConfiguration: &bedrock.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs{
 * 					CollectionArn:   pulumi.String("arn:aws:aoss:us-west-2:123456789012:collection/142bezjddq707i5stcrf"),
 * 					VectorIndexName: pulumi.String("bedrock-knowledge-base-default-index"),
 * 					FieldMapping: &bedrock.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMappingArgs{
 * 						VectorField:   pulumi.String("bedrock-knowledge-base-default-vector"),
 * 						TextField:     pulumi.String("AMAZON_BEDROCK_TEXT_CHUNK"),
 * 						MetadataField: pulumi.String("AMAZON_BEDROCK_METADATA"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.bedrock.AgentKnowledgeBase;
 * import com.pulumi.aws.bedrock.AgentKnowledgeBaseArgs;
 * import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationArgs;
 * import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs;
 * import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationArgs;
 * import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs;
 * import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AgentKnowledgeBase("example", AgentKnowledgeBaseArgs.builder()
 *             .name("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .knowledgeBaseConfiguration(AgentKnowledgeBaseKnowledgeBaseConfigurationArgs.builder()
 *                 .vectorKnowledgeBaseConfiguration(AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs.builder()
 *                     .embeddingModelArn("arn:aws:bedrock:us-west-2::foundation-model/amazon.titan-embed-text-v1")
 *                     .build())
 *                 .type("VECTOR")
 *                 .build())
 *             .storageConfiguration(AgentKnowledgeBaseStorageConfigurationArgs.builder()
 *                 .type("OPENSEARCH_SERVERLESS")
 *                 .opensearchServerlessConfiguration(AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs.builder()
 *                     .collectionArn("arn:aws:aoss:us-west-2:123456789012:collection/142bezjddq707i5stcrf")
 *                     .vectorIndexName("bedrock-knowledge-base-default-index")
 *                     .fieldMapping(AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMappingArgs.builder()
 *                         .vectorField("bedrock-knowledge-base-default-vector")
 *                         .textField("AMAZON_BEDROCK_TEXT_CHUNK")
 *                         .metadataField("AMAZON_BEDROCK_METADATA")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:bedrock:AgentKnowledgeBase
 *     properties:
 *       name: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       knowledgeBaseConfiguration:
 *         vectorKnowledgeBaseConfiguration:
 *           embeddingModelArn: arn:aws:bedrock:us-west-2::foundation-model/amazon.titan-embed-text-v1
 *         type: VECTOR
 *       storageConfiguration:
 *         type: OPENSEARCH_SERVERLESS
 *         opensearchServerlessConfiguration:
 *           collectionArn: arn:aws:aoss:us-west-2:123456789012:collection/142bezjddq707i5stcrf
 *           vectorIndexName: bedrock-knowledge-base-default-index
 *           fieldMapping:
 *             vectorField: bedrock-knowledge-base-default-vector
 *             textField: AMAZON_BEDROCK_TEXT_CHUNK
 *             metadataField: AMAZON_BEDROCK_METADATA
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Agents for Amazon Bedrock Knowledge Base using the knowledge base ID. For example:
 * ```sh
 * $ pulumi import aws:bedrock/agentKnowledgeBase:AgentKnowledgeBase example EMDPPAYPZI
 * ```
 */
public class AgentKnowledgeBase internal constructor(
    override val javaResource: com.pulumi.aws.bedrock.AgentKnowledgeBase,
) : KotlinCustomResource(javaResource, AgentKnowledgeBaseMapper) {
    /**
     * ARN of the knowledge base.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Time at which the knowledge base was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Description of the knowledge base.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val failureReasons: Output<List<String>>
        get() = javaResource.failureReasons().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Details about the embeddings configuration of the knowledge base. See `knowledge_base_configuration` block for details.
     */
    public val knowledgeBaseConfiguration: Output<AgentKnowledgeBaseKnowledgeBaseConfiguration>?
        get() = javaResource.knowledgeBaseConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    agentKnowledgeBaseKnowledgeBaseConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Name of the knowledge base.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ARN of the IAM role with permissions to invoke API operations on the knowledge base.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Details about the storage configuration of the knowledge base. See `storage_configuration` block for details.
     * The following arguments are optional:
     */
    public val storageConfiguration: Output<AgentKnowledgeBaseStorageConfiguration>?
        get() = javaResource.storageConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> agentKnowledgeBaseStorageConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<AgentKnowledgeBaseTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    agentKnowledgeBaseTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Time at which the knowledge base was last updated.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object AgentKnowledgeBaseMapper : ResourceMapper<AgentKnowledgeBase> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.bedrock.AgentKnowledgeBase::class == javaResource::class

    override fun map(javaResource: Resource): AgentKnowledgeBase = AgentKnowledgeBase(
        javaResource as
            com.pulumi.aws.bedrock.AgentKnowledgeBase,
    )
}

/**
 * @see [AgentKnowledgeBase].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AgentKnowledgeBase].
 */
public suspend fun agentKnowledgeBase(
    name: String,
    block: suspend AgentKnowledgeBaseResourceBuilder.() -> Unit,
): AgentKnowledgeBase {
    val builder = AgentKnowledgeBaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AgentKnowledgeBase].
 * @param name The _unique_ name of the resulting resource.
 */
public fun agentKnowledgeBase(name: String): AgentKnowledgeBase {
    val builder = AgentKnowledgeBaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
