@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.aws.bedrock.AgentKnowledgeBaseArgs.builder
import com.pulumi.aws.bedrock.kotlin.inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationArgs
import com.pulumi.aws.bedrock.kotlin.inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationArgsBuilder
import com.pulumi.aws.bedrock.kotlin.inputs.AgentKnowledgeBaseStorageConfigurationArgs
import com.pulumi.aws.bedrock.kotlin.inputs.AgentKnowledgeBaseStorageConfigurationArgsBuilder
import com.pulumi.aws.bedrock.kotlin.inputs.AgentKnowledgeBaseTimeoutsArgs
import com.pulumi.aws.bedrock.kotlin.inputs.AgentKnowledgeBaseTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Agents for Amazon Bedrock Knowledge Base.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.bedrock.AgentKnowledgeBase("example", {
 *     name: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     knowledgeBaseConfiguration: {
 *         vectorKnowledgeBaseConfiguration: {
 *             embeddingModelArn: "arn:aws:bedrock:us-west-2::foundation-model/amazon.titan-embed-text-v1",
 *         },
 *         type: "VECTOR",
 *     },
 *     storageConfiguration: {
 *         type: "OPENSEARCH_SERVERLESS",
 *         opensearchServerlessConfiguration: {
 *             collectionArn: "arn:aws:aoss:us-west-2:123456789012:collection/142bezjddq707i5stcrf",
 *             vectorIndexName: "bedrock-knowledge-base-default-index",
 *             fieldMapping: {
 *                 vectorField: "bedrock-knowledge-base-default-vector",
 *                 textField: "AMAZON_BEDROCK_TEXT_CHUNK",
 *                 metadataField: "AMAZON_BEDROCK_METADATA",
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.bedrock.AgentKnowledgeBase("example",
 *     name="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     knowledge_base_configuration={
 *         "vector_knowledge_base_configuration": {
 *             "embedding_model_arn": "arn:aws:bedrock:us-west-2::foundation-model/amazon.titan-embed-text-v1",
 *         },
 *         "type": "VECTOR",
 *     },
 *     storage_configuration={
 *         "type": "OPENSEARCH_SERVERLESS",
 *         "opensearch_serverless_configuration": {
 *             "collection_arn": "arn:aws:aoss:us-west-2:123456789012:collection/142bezjddq707i5stcrf",
 *             "vector_index_name": "bedrock-knowledge-base-default-index",
 *             "field_mapping": {
 *                 "vector_field": "bedrock-knowledge-base-default-vector",
 *                 "text_field": "AMAZON_BEDROCK_TEXT_CHUNK",
 *                 "metadata_field": "AMAZON_BEDROCK_METADATA",
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Bedrock.AgentKnowledgeBase("example", new()
 *     {
 *         Name = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         KnowledgeBaseConfiguration = new Aws.Bedrock.Inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationArgs
 *         {
 *             VectorKnowledgeBaseConfiguration = new Aws.Bedrock.Inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs
 *             {
 *                 EmbeddingModelArn = "arn:aws:bedrock:us-west-2::foundation-model/amazon.titan-embed-text-v1",
 *             },
 *             Type = "VECTOR",
 *         },
 *         StorageConfiguration = new Aws.Bedrock.Inputs.AgentKnowledgeBaseStorageConfigurationArgs
 *         {
 *             Type = "OPENSEARCH_SERVERLESS",
 *             OpensearchServerlessConfiguration = new Aws.Bedrock.Inputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs
 *             {
 *                 CollectionArn = "arn:aws:aoss:us-west-2:123456789012:collection/142bezjddq707i5stcrf",
 *                 VectorIndexName = "bedrock-knowledge-base-default-index",
 *                 FieldMapping = new Aws.Bedrock.Inputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMappingArgs
 *                 {
 *                     VectorField = "bedrock-knowledge-base-default-vector",
 *                     TextField = "AMAZON_BEDROCK_TEXT_CHUNK",
 *                     MetadataField = "AMAZON_BEDROCK_METADATA",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := bedrock.NewAgentKnowledgeBase(ctx, "example", &bedrock.AgentKnowledgeBaseArgs{
 * 			Name:    pulumi.String("example"),
 * 			RoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			KnowledgeBaseConfiguration: &bedrock.AgentKnowledgeBaseKnowledgeBaseConfigurationArgs{
 * 				VectorKnowledgeBaseConfiguration: &bedrock.AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs{
 * 					EmbeddingModelArn: pulumi.String("arn:aws:bedrock:us-west-2::foundation-model/amazon.titan-embed-text-v1"),
 * 				},
 * 				Type: pulumi.String("VECTOR"),
 * 			},
 * 			StorageConfiguration: &bedrock.AgentKnowledgeBaseStorageConfigurationArgs{
 * 				Type: pulumi.String("OPENSEARCH_SERVERLESS"),
 * 				OpensearchServerlessConfiguration: &bedrock.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs{
 * 					CollectionArn:   pulumi.String("arn:aws:aoss:us-west-2:123456789012:collection/142bezjddq707i5stcrf"),
 * 					VectorIndexName: pulumi.String("bedrock-knowledge-base-default-index"),
 * 					FieldMapping: &bedrock.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMappingArgs{
 * 						VectorField:   pulumi.String("bedrock-knowledge-base-default-vector"),
 * 						TextField:     pulumi.String("AMAZON_BEDROCK_TEXT_CHUNK"),
 * 						MetadataField: pulumi.String("AMAZON_BEDROCK_METADATA"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.bedrock.AgentKnowledgeBase;
 * import com.pulumi.aws.bedrock.AgentKnowledgeBaseArgs;
 * import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationArgs;
 * import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs;
 * import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationArgs;
 * import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs;
 * import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AgentKnowledgeBase("example", AgentKnowledgeBaseArgs.builder()
 *             .name("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .knowledgeBaseConfiguration(AgentKnowledgeBaseKnowledgeBaseConfigurationArgs.builder()
 *                 .vectorKnowledgeBaseConfiguration(AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs.builder()
 *                     .embeddingModelArn("arn:aws:bedrock:us-west-2::foundation-model/amazon.titan-embed-text-v1")
 *                     .build())
 *                 .type("VECTOR")
 *                 .build())
 *             .storageConfiguration(AgentKnowledgeBaseStorageConfigurationArgs.builder()
 *                 .type("OPENSEARCH_SERVERLESS")
 *                 .opensearchServerlessConfiguration(AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs.builder()
 *                     .collectionArn("arn:aws:aoss:us-west-2:123456789012:collection/142bezjddq707i5stcrf")
 *                     .vectorIndexName("bedrock-knowledge-base-default-index")
 *                     .fieldMapping(AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMappingArgs.builder()
 *                         .vectorField("bedrock-knowledge-base-default-vector")
 *                         .textField("AMAZON_BEDROCK_TEXT_CHUNK")
 *                         .metadataField("AMAZON_BEDROCK_METADATA")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:bedrock:AgentKnowledgeBase
 *     properties:
 *       name: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       knowledgeBaseConfiguration:
 *         vectorKnowledgeBaseConfiguration:
 *           embeddingModelArn: arn:aws:bedrock:us-west-2::foundation-model/amazon.titan-embed-text-v1
 *         type: VECTOR
 *       storageConfiguration:
 *         type: OPENSEARCH_SERVERLESS
 *         opensearchServerlessConfiguration:
 *           collectionArn: arn:aws:aoss:us-west-2:123456789012:collection/142bezjddq707i5stcrf
 *           vectorIndexName: bedrock-knowledge-base-default-index
 *           fieldMapping:
 *             vectorField: bedrock-knowledge-base-default-vector
 *             textField: AMAZON_BEDROCK_TEXT_CHUNK
 *             metadataField: AMAZON_BEDROCK_METADATA
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Agents for Amazon Bedrock Knowledge Base using the knowledge base ID. For example:
 * ```sh
 * $ pulumi import aws:bedrock/agentKnowledgeBase:AgentKnowledgeBase example EMDPPAYPZI
 * ```
 * @property description Description of the knowledge base.
 * @property knowledgeBaseConfiguration Details about the embeddings configuration of the knowledge base. See `knowledge_base_configuration` block for details.
 * @property name Name of the knowledge base.
 * @property roleArn ARN of the IAM role with permissions to invoke API operations on the knowledge base.
 * @property storageConfiguration Details about the storage configuration of the knowledge base. See `storage_configuration` block for details.
 * The following arguments are optional:
 * @property tags Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class AgentKnowledgeBaseArgs(
    public val description: Output<String>? = null,
    public val knowledgeBaseConfiguration: Output<AgentKnowledgeBaseKnowledgeBaseConfigurationArgs>? =
        null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val storageConfiguration: Output<AgentKnowledgeBaseStorageConfigurationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<AgentKnowledgeBaseTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrock.AgentKnowledgeBaseArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.AgentKnowledgeBaseArgs =
        com.pulumi.aws.bedrock.AgentKnowledgeBaseArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .knowledgeBaseConfiguration(
                knowledgeBaseConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .storageConfiguration(
                storageConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AgentKnowledgeBaseArgs].
 */
@PulumiTagMarker
public class AgentKnowledgeBaseArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var knowledgeBaseConfiguration: Output<AgentKnowledgeBaseKnowledgeBaseConfigurationArgs>? =
        null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var storageConfiguration: Output<AgentKnowledgeBaseStorageConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<AgentKnowledgeBaseTimeoutsArgs>? = null

    /**
     * @param value Description of the knowledge base.
     */
    @JvmName("kruulllwmepfnyyv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Details about the embeddings configuration of the knowledge base. See `knowledge_base_configuration` block for details.
     */
    @JvmName("nsuybqqrmnrkjeyr")
    public suspend fun knowledgeBaseConfiguration(`value`: Output<AgentKnowledgeBaseKnowledgeBaseConfigurationArgs>) {
        this.knowledgeBaseConfiguration = value
    }

    /**
     * @param value Name of the knowledge base.
     */
    @JvmName("diyekiepnlivpiuq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ARN of the IAM role with permissions to invoke API operations on the knowledge base.
     */
    @JvmName("eqdoswxlpoxkgabc")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Details about the storage configuration of the knowledge base. See `storage_configuration` block for details.
     * The following arguments are optional:
     */
    @JvmName("cwowuyteglikgaxx")
    public suspend fun storageConfiguration(`value`: Output<AgentKnowledgeBaseStorageConfigurationArgs>) {
        this.storageConfiguration = value
    }

    /**
     * @param value Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fxhqufnrwwctpajm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("inhdpbygqiaawdth")
    public suspend fun timeouts(`value`: Output<AgentKnowledgeBaseTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Description of the knowledge base.
     */
    @JvmName("hunykannaddqgnae")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Details about the embeddings configuration of the knowledge base. See `knowledge_base_configuration` block for details.
     */
    @JvmName("wgtojsyuokqwqhwq")
    public suspend fun knowledgeBaseConfiguration(`value`: AgentKnowledgeBaseKnowledgeBaseConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.knowledgeBaseConfiguration = mapped
    }

    /**
     * @param argument Details about the embeddings configuration of the knowledge base. See `knowledge_base_configuration` block for details.
     */
    @JvmName("bydiuvhvsqrmuhty")
    public suspend fun knowledgeBaseConfiguration(argument: suspend AgentKnowledgeBaseKnowledgeBaseConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AgentKnowledgeBaseKnowledgeBaseConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.knowledgeBaseConfiguration = mapped
    }

    /**
     * @param value Name of the knowledge base.
     */
    @JvmName("vpkpkjxskenpbxbs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ARN of the IAM role with permissions to invoke API operations on the knowledge base.
     */
    @JvmName("cvykvgtuonbavuos")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Details about the storage configuration of the knowledge base. See `storage_configuration` block for details.
     * The following arguments are optional:
     */
    @JvmName("bmmabtpwdutbiqta")
    public suspend fun storageConfiguration(`value`: AgentKnowledgeBaseStorageConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageConfiguration = mapped
    }

    /**
     * @param argument Details about the storage configuration of the knowledge base. See `storage_configuration` block for details.
     * The following arguments are optional:
     */
    @JvmName("imkrqfuvibctmibg")
    public suspend fun storageConfiguration(argument: suspend AgentKnowledgeBaseStorageConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AgentKnowledgeBaseStorageConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.storageConfiguration = mapped
    }

    /**
     * @param value Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kpjlnpdbhslytkao")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("honkeqscpvrrugbb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("vovtgasdifdrdbsi")
    public suspend fun timeouts(`value`: AgentKnowledgeBaseTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("aonysjowikcjhake")
    public suspend fun timeouts(argument: suspend AgentKnowledgeBaseTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = AgentKnowledgeBaseTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): AgentKnowledgeBaseArgs = AgentKnowledgeBaseArgs(
        description = description,
        knowledgeBaseConfiguration = knowledgeBaseConfiguration,
        name = name,
        roleArn = roleArn,
        storageConfiguration = storageConfiguration,
        tags = tags,
        timeouts = timeouts,
    )
}
