@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.aws.bedrock.BedrockFunctions.getCustomModelPlain
import com.pulumi.aws.bedrock.BedrockFunctions.getCustomModelsPlain
import com.pulumi.aws.bedrock.kotlin.inputs.GetCustomModelPlainArgs
import com.pulumi.aws.bedrock.kotlin.inputs.GetCustomModelPlainArgsBuilder
import com.pulumi.aws.bedrock.kotlin.outputs.GetCustomModelResult
import com.pulumi.aws.bedrock.kotlin.outputs.GetCustomModelsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.bedrock.kotlin.outputs.GetCustomModelResult.Companion.toKotlin as getCustomModelResultToKotlin
import com.pulumi.aws.bedrock.kotlin.outputs.GetCustomModelsResult.Companion.toKotlin as getCustomModelsResultToKotlin

public object BedrockFunctions {
    /**
     * Returns properties of a specific Amazon Bedrock custom model.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.bedrock.getCustomModel({
     *     modelId: "arn:aws:bedrock:us-west-2:123456789012:custom-model/amazon.titan-text-express-v1:0:8k/ly16hhi765j4 ",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.bedrock.get_custom_model(model_id="arn:aws:bedrock:us-west-2:123456789012:custom-model/amazon.titan-text-express-v1:0:8k/ly16hhi765j4 ")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Bedrock.GetCustomModel.Invoke(new()
     *     {
     *         ModelId = "arn:aws:bedrock:us-west-2:123456789012:custom-model/amazon.titan-text-express-v1:0:8k/ly16hhi765j4 ",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := bedrock.LookupCustomModel(ctx, &bedrock.LookupCustomModelArgs{
     * 			ModelId: "arn:aws:bedrock:us-west-2:123456789012:custom-model/amazon.titan-text-express-v1:0:8k/ly16hhi765j4 ",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.bedrock.BedrockFunctions;
     * import com.pulumi.aws.bedrock.inputs.GetCustomModelArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = BedrockFunctions.getCustomModel(GetCustomModelArgs.builder()
     *             .modelId("arn:aws:bedrock:us-west-2:123456789012:custom-model/amazon.titan-text-express-v1:0:8k/ly16hhi765j4 ")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:bedrock:getCustomModel
     *       Arguments:
     *         modelId: 'arn:aws:bedrock:us-west-2:123456789012:custom-model/amazon.titan-text-express-v1:0:8k/ly16hhi765j4 '
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCustomModel.
     * @return A collection of values returned by getCustomModel.
     */
    public suspend fun getCustomModel(argument: GetCustomModelPlainArgs): GetCustomModelResult =
        getCustomModelResultToKotlin(getCustomModelPlain(argument.toJava()).await())

    /**
     * @see [getCustomModel].
     * @param modelId Name or ARN of the custom model.
     * @return A collection of values returned by getCustomModel.
     */
    public suspend fun getCustomModel(modelId: String): GetCustomModelResult {
        val argument = GetCustomModelPlainArgs(
            modelId = modelId,
        )
        return getCustomModelResultToKotlin(getCustomModelPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomModel].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;bedrock&#46;kotlin&#46;inputs&#46;GetCustomModelPlainArgs].
     * @return A collection of values returned by getCustomModel.
     */
    public suspend fun getCustomModel(argument: suspend GetCustomModelPlainArgsBuilder.() -> Unit): GetCustomModelResult {
        val builder = GetCustomModelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomModelResultToKotlin(getCustomModelPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a list of Amazon Bedrock custom models.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.bedrock.getCustomModels({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.bedrock.get_custom_models()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Bedrock.GetCustomModels.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := bedrock.GetCustomModels(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.bedrock.BedrockFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = BedrockFunctions.getCustomModels();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:bedrock:getCustomModels
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument Returns a list of Amazon Bedrock custom models.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.bedrock.getCustomModels({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.bedrock.get_custom_models()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Bedrock.GetCustomModels.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := bedrock.GetCustomModels(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.bedrock.BedrockFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = BedrockFunctions.getCustomModels();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:bedrock:getCustomModels
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getCustomModels.
     */
    public suspend fun getCustomModels(): GetCustomModelsResult =
        getCustomModelsResultToKotlin(getCustomModelsPlain().await())
}
