@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.aws.bedrock.kotlin.outputs.CustomModelOutputDataConfig
import com.pulumi.aws.bedrock.kotlin.outputs.CustomModelTimeouts
import com.pulumi.aws.bedrock.kotlin.outputs.CustomModelTrainingDataConfig
import com.pulumi.aws.bedrock.kotlin.outputs.CustomModelTrainingMetric
import com.pulumi.aws.bedrock.kotlin.outputs.CustomModelValidationDataConfig
import com.pulumi.aws.bedrock.kotlin.outputs.CustomModelValidationMetric
import com.pulumi.aws.bedrock.kotlin.outputs.CustomModelVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.bedrock.kotlin.outputs.CustomModelOutputDataConfig.Companion.toKotlin as customModelOutputDataConfigToKotlin
import com.pulumi.aws.bedrock.kotlin.outputs.CustomModelTimeouts.Companion.toKotlin as customModelTimeoutsToKotlin
import com.pulumi.aws.bedrock.kotlin.outputs.CustomModelTrainingDataConfig.Companion.toKotlin as customModelTrainingDataConfigToKotlin
import com.pulumi.aws.bedrock.kotlin.outputs.CustomModelTrainingMetric.Companion.toKotlin as customModelTrainingMetricToKotlin
import com.pulumi.aws.bedrock.kotlin.outputs.CustomModelValidationDataConfig.Companion.toKotlin as customModelValidationDataConfigToKotlin
import com.pulumi.aws.bedrock.kotlin.outputs.CustomModelValidationMetric.Companion.toKotlin as customModelValidationMetricToKotlin
import com.pulumi.aws.bedrock.kotlin.outputs.CustomModelVpcConfig.Companion.toKotlin as customModelVpcConfigToKotlin

/**
 * Builder for [CustomModel].
 */
@PulumiTagMarker
public class CustomModelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomModelArgs = CustomModelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomModelArgsBuilder.() -> Unit) {
        val builder = CustomModelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomModel {
        val builtJavaResource = com.pulumi.aws.bedrock.CustomModel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomModel(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.bedrockfoundation.getModel({
 *     modelId: "amazon.titan-text-express-v1",
 * });
 * const exampleCustomModel = new aws.bedrock.CustomModel("example", {
 *     customModelName: "example-model",
 *     jobName: "example-job-1",
 *     baseModelIdentifier: example.then(example => example.modelArn),
 *     roleArn: exampleAwsIamRole.arn,
 *     hyperparameters: {
 *         epochCount: "1",
 *         batchSize: "1",
 *         learningRate: "0.005",
 *         learningRateWarmupSteps: "0",
 *     },
 *     outputDataConfig: {
 *         s3Uri: `s3://${output.id}/data/`,
 *     },
 *     trainingDataConfig: {
 *         s3Uri: `s3://${training.id}/data/train.jsonl`,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.bedrockfoundation.get_model(model_id="amazon.titan-text-express-v1")
 * example_custom_model = aws.bedrock.CustomModel("example",
 *     custom_model_name="example-model",
 *     job_name="example-job-1",
 *     base_model_identifier=example.model_arn,
 *     role_arn=example_aws_iam_role["arn"],
 *     hyperparameters={
 *         "epochCount": "1",
 *         "batchSize": "1",
 *         "learningRate": "0.005",
 *         "learningRateWarmupSteps": "0",
 *     },
 *     output_data_config={
 *         "s3_uri": f"s3://{output['id']}/data/",
 *     },
 *     training_data_config={
 *         "s3_uri": f"s3://{training['id']}/data/train.jsonl",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.BedrockFoundation.GetModel.Invoke(new()
 *     {
 *         ModelId = "amazon.titan-text-express-v1",
 *     });
 *     var exampleCustomModel = new Aws.Bedrock.CustomModel("example", new()
 *     {
 *         CustomModelName = "example-model",
 *         JobName = "example-job-1",
 *         BaseModelIdentifier = example.Apply(getModelResult => getModelResult.ModelArn),
 *         RoleArn = exampleAwsIamRole.Arn,
 *         Hyperparameters =
 *         {
 *             { "epochCount", "1" },
 *             { "batchSize", "1" },
 *             { "learningRate", "0.005" },
 *             { "learningRateWarmupSteps", "0" },
 *         },
 *         OutputDataConfig = new Aws.Bedrock.Inputs.CustomModelOutputDataConfigArgs
 *         {
 *             S3Uri = $"s3://{output.Id}/data/",
 *         },
 *         TrainingDataConfig = new Aws.Bedrock.Inputs.CustomModelTrainingDataConfigArgs
 *         {
 *             S3Uri = $"s3://{training.Id}/data/train.jsonl",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrockfoundation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := bedrockfoundation.GetModel(ctx, &bedrockfoundation.GetModelArgs{
 * 			ModelId: "amazon.titan-text-express-v1",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = bedrock.NewCustomModel(ctx, "example", &bedrock.CustomModelArgs{
 * 			CustomModelName:     pulumi.String("example-model"),
 * 			JobName:             pulumi.String("example-job-1"),
 * 			BaseModelIdentifier: pulumi.String(example.ModelArn),
 * 			RoleArn:             pulumi.Any(exampleAwsIamRole.Arn),
 * 			Hyperparameters: pulumi.StringMap{
 * 				"epochCount":              pulumi.String("1"),
 * 				"batchSize":               pulumi.String("1"),
 * 				"learningRate":            pulumi.String("0.005"),
 * 				"learningRateWarmupSteps": pulumi.String("0"),
 * 			},
 * 			OutputDataConfig: &bedrock.CustomModelOutputDataConfigArgs{
 * 				S3Uri: pulumi.Sprintf("s3://%v/data/", output.Id),
 * 			},
 * 			TrainingDataConfig: &bedrock.CustomModelTrainingDataConfigArgs{
 * 				S3Uri: pulumi.Sprintf("s3://%v/data/train.jsonl", training.Id),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.bedrockfoundation.BedrockfoundationFunctions;
 * import com.pulumi.aws.bedrockfoundation.inputs.GetModelArgs;
 * import com.pulumi.aws.bedrock.CustomModel;
 * import com.pulumi.aws.bedrock.CustomModelArgs;
 * import com.pulumi.aws.bedrock.inputs.CustomModelOutputDataConfigArgs;
 * import com.pulumi.aws.bedrock.inputs.CustomModelTrainingDataConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = BedrockfoundationFunctions.getModel(GetModelArgs.builder()
 *             .modelId("amazon.titan-text-express-v1")
 *             .build());
 *         var exampleCustomModel = new CustomModel("exampleCustomModel", CustomModelArgs.builder()
 *             .customModelName("example-model")
 *             .jobName("example-job-1")
 *             .baseModelIdentifier(example.applyValue(getModelResult -> getModelResult.modelArn()))
 *             .roleArn(exampleAwsIamRole.arn())
 *             .hyperparameters(Map.ofEntries(
 *                 Map.entry("epochCount", "1"),
 *                 Map.entry("batchSize", "1"),
 *                 Map.entry("learningRate", "0.005"),
 *                 Map.entry("learningRateWarmupSteps", "0")
 *             ))
 *             .outputDataConfig(CustomModelOutputDataConfigArgs.builder()
 *                 .s3Uri(String.format("s3://%s/data/", output.id()))
 *                 .build())
 *             .trainingDataConfig(CustomModelTrainingDataConfigArgs.builder()
 *                 .s3Uri(String.format("s3://%s/data/train.jsonl", training.id()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleCustomModel:
 *     type: aws:bedrock:CustomModel
 *     name: example
 *     properties:
 *       customModelName: example-model
 *       jobName: example-job-1
 *       baseModelIdentifier: ${example.modelArn}
 *       roleArn: ${exampleAwsIamRole.arn}
 *       hyperparameters:
 *         epochCount: '1'
 *         batchSize: '1'
 *         learningRate: '0.005'
 *         learningRateWarmupSteps: '0'
 *       outputDataConfig:
 *         s3Uri: s3://${output.id}/data/
 *       trainingDataConfig:
 *         s3Uri: s3://${training.id}/data/train.jsonl
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:bedrockfoundation:getModel
 *       Arguments:
 *         modelId: amazon.titan-text-express-v1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Bedrock custom model using the `job_arn`. For example:
 * ```sh
 * $ pulumi import aws:bedrock/customModel:CustomModel example arn:aws:bedrock:us-west-2:123456789012:model-customization-job/amazon.titan-text-express-v1:0:8k/1y5n57gh5y2e
 * ```
 */
public class CustomModel internal constructor(
    override val javaResource: com.pulumi.aws.bedrock.CustomModel,
) : KotlinCustomResource(javaResource, CustomModelMapper) {
    /**
     * The Amazon Resource Name (ARN) of the base model.
     */
    public val baseModelIdentifier: Output<String>
        get() = javaResource.baseModelIdentifier().applyValue({ args0 -> args0 })

    /**
     * The ARN of the output model.
     */
    public val customModelArn: Output<String>
        get() = javaResource.customModelArn().applyValue({ args0 -> args0 })

    /**
     * The custom model is encrypted at rest using this key. Specify the key ARN.
     */
    public val customModelKmsKeyId: Output<String>?
        get() = javaResource.customModelKmsKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name for the custom model.
     */
    public val customModelName: Output<String>
        get() = javaResource.customModelName().applyValue({ args0 -> args0 })

    /**
     * The customization type. Valid values: `FINE_TUNING`, `CONTINUED_PRE_TRAINING`.
     */
    public val customizationType: Output<String>
        get() = javaResource.customizationType().applyValue({ args0 -> args0 })

    /**
     * [Parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html) related to tuning the model.
     */
    public val hyperparameters: Output<Map<String, String>>
        get() = javaResource.hyperparameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ARN of the customization job.
     */
    public val jobArn: Output<String>
        get() = javaResource.jobArn().applyValue({ args0 -> args0 })

    /**
     * A name for the customization job.
     */
    public val jobName: Output<String>
        get() = javaResource.jobName().applyValue({ args0 -> args0 })

    /**
     * The status of the customization job. A successful job transitions from `InProgress` to `Completed` when the output model is ready to use.
     */
    public val jobStatus: Output<String>
        get() = javaResource.jobStatus().applyValue({ args0 -> args0 })

    /**
     * S3 location for the output data.
     */
    public val outputDataConfig: Output<CustomModelOutputDataConfig>?
        get() = javaResource.outputDataConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> customModelOutputDataConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of an IAM role that Bedrock can assume to perform tasks on your behalf.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the customization job and custom model. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<CustomModelTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    customModelTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Information about the training dataset.
     */
    public val trainingDataConfig: Output<CustomModelTrainingDataConfig>?
        get() = javaResource.trainingDataConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> customModelTrainingDataConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Metrics associated with the customization job.
     */
    public val trainingMetrics: Output<List<CustomModelTrainingMetric>>
        get() = javaResource.trainingMetrics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> customModelTrainingMetricToKotlin(args0) })
            })
        })

    /**
     * Information about the validation dataset.
     */
    public val validationDataConfig: Output<CustomModelValidationDataConfig>?
        get() = javaResource.validationDataConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> customModelValidationDataConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The loss metric for each validator that you provided.
     */
    public val validationMetrics: Output<List<CustomModelValidationMetric>>
        get() = javaResource.validationMetrics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> customModelValidationMetricToKotlin(args0) })
            })
        })

    /**
     * Configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for this job.
     */
    public val vpcConfig: Output<CustomModelVpcConfig>?
        get() = javaResource.vpcConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    customModelVpcConfigToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object CustomModelMapper : ResourceMapper<CustomModel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.bedrock.CustomModel::class == javaResource::class

    override fun map(javaResource: Resource): CustomModel = CustomModel(
        javaResource as
            com.pulumi.aws.bedrock.CustomModel,
    )
}

/**
 * @see [CustomModel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomModel].
 */
public suspend fun customModel(name: String, block: suspend CustomModelResourceBuilder.() -> Unit): CustomModel {
    val builder = CustomModelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomModel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customModel(name: String): CustomModel {
    val builder = CustomModelResourceBuilder()
    builder.name(name)
    return builder.build()
}
