@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.aws.bedrock.CustomModelArgs.builder
import com.pulumi.aws.bedrock.kotlin.inputs.CustomModelOutputDataConfigArgs
import com.pulumi.aws.bedrock.kotlin.inputs.CustomModelOutputDataConfigArgsBuilder
import com.pulumi.aws.bedrock.kotlin.inputs.CustomModelTimeoutsArgs
import com.pulumi.aws.bedrock.kotlin.inputs.CustomModelTimeoutsArgsBuilder
import com.pulumi.aws.bedrock.kotlin.inputs.CustomModelTrainingDataConfigArgs
import com.pulumi.aws.bedrock.kotlin.inputs.CustomModelTrainingDataConfigArgsBuilder
import com.pulumi.aws.bedrock.kotlin.inputs.CustomModelValidationDataConfigArgs
import com.pulumi.aws.bedrock.kotlin.inputs.CustomModelValidationDataConfigArgsBuilder
import com.pulumi.aws.bedrock.kotlin.inputs.CustomModelVpcConfigArgs
import com.pulumi.aws.bedrock.kotlin.inputs.CustomModelVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.bedrockfoundation.getModel({
 *     modelId: "amazon.titan-text-express-v1",
 * });
 * const exampleCustomModel = new aws.bedrock.CustomModel("example", {
 *     customModelName: "example-model",
 *     jobName: "example-job-1",
 *     baseModelIdentifier: example.then(example => example.modelArn),
 *     roleArn: exampleAwsIamRole.arn,
 *     hyperparameters: {
 *         epochCount: "1",
 *         batchSize: "1",
 *         learningRate: "0.005",
 *         learningRateWarmupSteps: "0",
 *     },
 *     outputDataConfig: {
 *         s3Uri: `s3://${output.id}/data/`,
 *     },
 *     trainingDataConfig: {
 *         s3Uri: `s3://${training.id}/data/train.jsonl`,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.bedrockfoundation.get_model(model_id="amazon.titan-text-express-v1")
 * example_custom_model = aws.bedrock.CustomModel("example",
 *     custom_model_name="example-model",
 *     job_name="example-job-1",
 *     base_model_identifier=example.model_arn,
 *     role_arn=example_aws_iam_role["arn"],
 *     hyperparameters={
 *         "epochCount": "1",
 *         "batchSize": "1",
 *         "learningRate": "0.005",
 *         "learningRateWarmupSteps": "0",
 *     },
 *     output_data_config={
 *         "s3_uri": f"s3://{output['id']}/data/",
 *     },
 *     training_data_config={
 *         "s3_uri": f"s3://{training['id']}/data/train.jsonl",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.BedrockFoundation.GetModel.Invoke(new()
 *     {
 *         ModelId = "amazon.titan-text-express-v1",
 *     });
 *     var exampleCustomModel = new Aws.Bedrock.CustomModel("example", new()
 *     {
 *         CustomModelName = "example-model",
 *         JobName = "example-job-1",
 *         BaseModelIdentifier = example.Apply(getModelResult => getModelResult.ModelArn),
 *         RoleArn = exampleAwsIamRole.Arn,
 *         Hyperparameters =
 *         {
 *             { "epochCount", "1" },
 *             { "batchSize", "1" },
 *             { "learningRate", "0.005" },
 *             { "learningRateWarmupSteps", "0" },
 *         },
 *         OutputDataConfig = new Aws.Bedrock.Inputs.CustomModelOutputDataConfigArgs
 *         {
 *             S3Uri = $"s3://{output.Id}/data/",
 *         },
 *         TrainingDataConfig = new Aws.Bedrock.Inputs.CustomModelTrainingDataConfigArgs
 *         {
 *             S3Uri = $"s3://{training.Id}/data/train.jsonl",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrockfoundation"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := bedrockfoundation.GetModel(ctx, &bedrockfoundation.GetModelArgs{
 * 			ModelId: "amazon.titan-text-express-v1",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = bedrock.NewCustomModel(ctx, "example", &bedrock.CustomModelArgs{
 * 			CustomModelName:     pulumi.String("example-model"),
 * 			JobName:             pulumi.String("example-job-1"),
 * 			BaseModelIdentifier: pulumi.String(example.ModelArn),
 * 			RoleArn:             pulumi.Any(exampleAwsIamRole.Arn),
 * 			Hyperparameters: pulumi.StringMap{
 * 				"epochCount":              pulumi.String("1"),
 * 				"batchSize":               pulumi.String("1"),
 * 				"learningRate":            pulumi.String("0.005"),
 * 				"learningRateWarmupSteps": pulumi.String("0"),
 * 			},
 * 			OutputDataConfig: &bedrock.CustomModelOutputDataConfigArgs{
 * 				S3Uri: pulumi.Sprintf("s3://%v/data/", output.Id),
 * 			},
 * 			TrainingDataConfig: &bedrock.CustomModelTrainingDataConfigArgs{
 * 				S3Uri: pulumi.Sprintf("s3://%v/data/train.jsonl", training.Id),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.bedrockfoundation.BedrockfoundationFunctions;
 * import com.pulumi.aws.bedrockfoundation.inputs.GetModelArgs;
 * import com.pulumi.aws.bedrock.CustomModel;
 * import com.pulumi.aws.bedrock.CustomModelArgs;
 * import com.pulumi.aws.bedrock.inputs.CustomModelOutputDataConfigArgs;
 * import com.pulumi.aws.bedrock.inputs.CustomModelTrainingDataConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = BedrockfoundationFunctions.getModel(GetModelArgs.builder()
 *             .modelId("amazon.titan-text-express-v1")
 *             .build());
 *         var exampleCustomModel = new CustomModel("exampleCustomModel", CustomModelArgs.builder()
 *             .customModelName("example-model")
 *             .jobName("example-job-1")
 *             .baseModelIdentifier(example.applyValue(getModelResult -> getModelResult.modelArn()))
 *             .roleArn(exampleAwsIamRole.arn())
 *             .hyperparameters(Map.ofEntries(
 *                 Map.entry("epochCount", "1"),
 *                 Map.entry("batchSize", "1"),
 *                 Map.entry("learningRate", "0.005"),
 *                 Map.entry("learningRateWarmupSteps", "0")
 *             ))
 *             .outputDataConfig(CustomModelOutputDataConfigArgs.builder()
 *                 .s3Uri(String.format("s3://%s/data/", output.id()))
 *                 .build())
 *             .trainingDataConfig(CustomModelTrainingDataConfigArgs.builder()
 *                 .s3Uri(String.format("s3://%s/data/train.jsonl", training.id()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleCustomModel:
 *     type: aws:bedrock:CustomModel
 *     name: example
 *     properties:
 *       customModelName: example-model
 *       jobName: example-job-1
 *       baseModelIdentifier: ${example.modelArn}
 *       roleArn: ${exampleAwsIamRole.arn}
 *       hyperparameters:
 *         epochCount: '1'
 *         batchSize: '1'
 *         learningRate: '0.005'
 *         learningRateWarmupSteps: '0'
 *       outputDataConfig:
 *         s3Uri: s3://${output.id}/data/
 *       trainingDataConfig:
 *         s3Uri: s3://${training.id}/data/train.jsonl
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:bedrockfoundation:getModel
 *       Arguments:
 *         modelId: amazon.titan-text-express-v1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Bedrock custom model using the `job_arn`. For example:
 * ```sh
 * $ pulumi import aws:bedrock/customModel:CustomModel example arn:aws:bedrock:us-west-2:123456789012:model-customization-job/amazon.titan-text-express-v1:0:8k/1y5n57gh5y2e
 * ```
 * @property baseModelIdentifier The Amazon Resource Name (ARN) of the base model.
 * @property customModelKmsKeyId The custom model is encrypted at rest using this key. Specify the key ARN.
 * @property customModelName Name for the custom model.
 * @property customizationType The customization type. Valid values: `FINE_TUNING`, `CONTINUED_PRE_TRAINING`.
 * @property hyperparameters [Parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html) related to tuning the model.
 * @property jobName A name for the customization job.
 * @property outputDataConfig S3 location for the output data.
 * @property roleArn The Amazon Resource Name (ARN) of an IAM role that Bedrock can assume to perform tasks on your behalf.
 * @property tags A map of tags to assign to the customization job and custom model. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 * @property trainingDataConfig Information about the training dataset.
 * @property validationDataConfig Information about the validation dataset.
 * @property vpcConfig Configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for this job.
 */
public data class CustomModelArgs(
    public val baseModelIdentifier: Output<String>? = null,
    public val customModelKmsKeyId: Output<String>? = null,
    public val customModelName: Output<String>? = null,
    public val customizationType: Output<String>? = null,
    public val hyperparameters: Output<Map<String, String>>? = null,
    public val jobName: Output<String>? = null,
    public val outputDataConfig: Output<CustomModelOutputDataConfigArgs>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<CustomModelTimeoutsArgs>? = null,
    public val trainingDataConfig: Output<CustomModelTrainingDataConfigArgs>? = null,
    public val validationDataConfig: Output<CustomModelValidationDataConfigArgs>? = null,
    public val vpcConfig: Output<CustomModelVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrock.CustomModelArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.CustomModelArgs =
        com.pulumi.aws.bedrock.CustomModelArgs.builder()
            .baseModelIdentifier(baseModelIdentifier?.applyValue({ args0 -> args0 }))
            .customModelKmsKeyId(customModelKmsKeyId?.applyValue({ args0 -> args0 }))
            .customModelName(customModelName?.applyValue({ args0 -> args0 }))
            .customizationType(customizationType?.applyValue({ args0 -> args0 }))
            .hyperparameters(
                hyperparameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .outputDataConfig(outputDataConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trainingDataConfig(
                trainingDataConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .validationDataConfig(
                validationDataConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CustomModelArgs].
 */
@PulumiTagMarker
public class CustomModelArgsBuilder internal constructor() {
    private var baseModelIdentifier: Output<String>? = null

    private var customModelKmsKeyId: Output<String>? = null

    private var customModelName: Output<String>? = null

    private var customizationType: Output<String>? = null

    private var hyperparameters: Output<Map<String, String>>? = null

    private var jobName: Output<String>? = null

    private var outputDataConfig: Output<CustomModelOutputDataConfigArgs>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<CustomModelTimeoutsArgs>? = null

    private var trainingDataConfig: Output<CustomModelTrainingDataConfigArgs>? = null

    private var validationDataConfig: Output<CustomModelValidationDataConfigArgs>? = null

    private var vpcConfig: Output<CustomModelVpcConfigArgs>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the base model.
     */
    @JvmName("nungeopekcgocaev")
    public suspend fun baseModelIdentifier(`value`: Output<String>) {
        this.baseModelIdentifier = value
    }

    /**
     * @param value The custom model is encrypted at rest using this key. Specify the key ARN.
     */
    @JvmName("crvmyijpajbnqwpq")
    public suspend fun customModelKmsKeyId(`value`: Output<String>) {
        this.customModelKmsKeyId = value
    }

    /**
     * @param value Name for the custom model.
     */
    @JvmName("yggogxiidityhded")
    public suspend fun customModelName(`value`: Output<String>) {
        this.customModelName = value
    }

    /**
     * @param value The customization type. Valid values: `FINE_TUNING`, `CONTINUED_PRE_TRAINING`.
     */
    @JvmName("srskrmxvydhsgrsx")
    public suspend fun customizationType(`value`: Output<String>) {
        this.customizationType = value
    }

    /**
     * @param value [Parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html) related to tuning the model.
     */
    @JvmName("xkncmtjjqmblkwuh")
    public suspend fun hyperparameters(`value`: Output<Map<String, String>>) {
        this.hyperparameters = value
    }

    /**
     * @param value A name for the customization job.
     */
    @JvmName("uwcxsrmgtlaipisq")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value S3 location for the output data.
     */
    @JvmName("pcvwdsndsrstfbtv")
    public suspend fun outputDataConfig(`value`: Output<CustomModelOutputDataConfigArgs>) {
        this.outputDataConfig = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of an IAM role that Bedrock can assume to perform tasks on your behalf.
     */
    @JvmName("eklaofpdjxdmbueo")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A map of tags to assign to the customization job and custom model. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xtmmpgeexwrhmlwy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("nmotgkhpuitfrwer")
    public suspend fun timeouts(`value`: Output<CustomModelTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Information about the training dataset.
     */
    @JvmName("uqygvpdwebbydowl")
    public suspend fun trainingDataConfig(`value`: Output<CustomModelTrainingDataConfigArgs>) {
        this.trainingDataConfig = value
    }

    /**
     * @param value Information about the validation dataset.
     */
    @JvmName("ljrhphbdnpqrapcv")
    public suspend fun validationDataConfig(`value`: Output<CustomModelValidationDataConfigArgs>) {
        this.validationDataConfig = value
    }

    /**
     * @param value Configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for this job.
     */
    @JvmName("kmvujfuigyxpinoh")
    public suspend fun vpcConfig(`value`: Output<CustomModelVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the base model.
     */
    @JvmName("wuhpfkpuwpgmanjb")
    public suspend fun baseModelIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseModelIdentifier = mapped
    }

    /**
     * @param value The custom model is encrypted at rest using this key. Specify the key ARN.
     */
    @JvmName("fpmrduglrtvrusbs")
    public suspend fun customModelKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customModelKmsKeyId = mapped
    }

    /**
     * @param value Name for the custom model.
     */
    @JvmName("eknholontwtygojd")
    public suspend fun customModelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customModelName = mapped
    }

    /**
     * @param value The customization type. Valid values: `FINE_TUNING`, `CONTINUED_PRE_TRAINING`.
     */
    @JvmName("wayirvfnfukjdxmc")
    public suspend fun customizationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customizationType = mapped
    }

    /**
     * @param value [Parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html) related to tuning the model.
     */
    @JvmName("cooyvaapwvtnjooh")
    public suspend fun hyperparameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hyperparameters = mapped
    }

    /**
     * @param values [Parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html) related to tuning the model.
     */
    @JvmName("dqowpsgxacsrgley")
    public fun hyperparameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperparameters = mapped
    }

    /**
     * @param value A name for the customization job.
     */
    @JvmName("bcefbrhjxfpsjclf")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value S3 location for the output data.
     */
    @JvmName("noepauucvhyoedcb")
    public suspend fun outputDataConfig(`value`: CustomModelOutputDataConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputDataConfig = mapped
    }

    /**
     * @param argument S3 location for the output data.
     */
    @JvmName("lrexdndfbornfjse")
    public suspend fun outputDataConfig(argument: suspend CustomModelOutputDataConfigArgsBuilder.() -> Unit) {
        val toBeMapped = CustomModelOutputDataConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.outputDataConfig = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of an IAM role that Bedrock can assume to perform tasks on your behalf.
     */
    @JvmName("cqeetchkvhkjywxa")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A map of tags to assign to the customization job and custom model. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cnegbmaydcksonkt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the customization job and custom model. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dgapbhybwbbbppgu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("dfjlbtspstujlhvc")
    public suspend fun timeouts(`value`: CustomModelTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("efhnvlvlasfvjwhu")
    public suspend fun timeouts(argument: suspend CustomModelTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = CustomModelTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value Information about the training dataset.
     */
    @JvmName("puptttxydhferwuv")
    public suspend fun trainingDataConfig(`value`: CustomModelTrainingDataConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trainingDataConfig = mapped
    }

    /**
     * @param argument Information about the training dataset.
     */
    @JvmName("revkuerakfgvsbis")
    public suspend fun trainingDataConfig(argument: suspend CustomModelTrainingDataConfigArgsBuilder.() -> Unit) {
        val toBeMapped = CustomModelTrainingDataConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.trainingDataConfig = mapped
    }

    /**
     * @param value Information about the validation dataset.
     */
    @JvmName("twqgvkxdxjuxnnwa")
    public suspend fun validationDataConfig(`value`: CustomModelValidationDataConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationDataConfig = mapped
    }

    /**
     * @param argument Information about the validation dataset.
     */
    @JvmName("tclyrolajcmvlufj")
    public suspend fun validationDataConfig(argument: suspend CustomModelValidationDataConfigArgsBuilder.() -> Unit) {
        val toBeMapped = CustomModelValidationDataConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationDataConfig = mapped
    }

    /**
     * @param value Configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for this job.
     */
    @JvmName("xafhytjfnmkpjxqk")
    public suspend fun vpcConfig(`value`: CustomModelVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument Configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for this job.
     */
    @JvmName("dyoxschhcuudxpik")
    public suspend fun vpcConfig(argument: suspend CustomModelVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = CustomModelVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): CustomModelArgs = CustomModelArgs(
        baseModelIdentifier = baseModelIdentifier,
        customModelKmsKeyId = customModelKmsKeyId,
        customModelName = customModelName,
        customizationType = customizationType,
        hyperparameters = hyperparameters,
        jobName = jobName,
        outputDataConfig = outputDataConfig,
        roleArn = roleArn,
        tags = tags,
        timeouts = timeouts,
        trainingDataConfig = trainingDataConfig,
        validationDataConfig = validationDataConfig,
        vpcConfig = vpcConfig,
    )
}
