@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.aws.bedrock.kotlin.outputs.ProvisionedModelThroughputTimeouts
import com.pulumi.aws.bedrock.kotlin.outputs.ProvisionedModelThroughputTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ProvisionedModelThroughput].
 */
@PulumiTagMarker
public class ProvisionedModelThroughputResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProvisionedModelThroughputArgs = ProvisionedModelThroughputArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProvisionedModelThroughputArgsBuilder.() -> Unit) {
        val builder = ProvisionedModelThroughputArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProvisionedModelThroughput {
        val builtJavaResource =
            com.pulumi.aws.bedrock.ProvisionedModelThroughput(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProvisionedModelThroughput(builtJavaResource)
    }
}

/**
 * Manages [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) for an Amazon Bedrock model.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.bedrock.ProvisionedModelThroughput("example", {
 *     provisionedModelName: "example-model",
 *     modelArn: "arn:aws:bedrock:us-east-1::foundation-model/anthropic.claude-v2",
 *     commitmentDuration: "SixMonths",
 *     modelUnits: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.bedrock.ProvisionedModelThroughput("example",
 *     provisioned_model_name="example-model",
 *     model_arn="arn:aws:bedrock:us-east-1::foundation-model/anthropic.claude-v2",
 *     commitment_duration="SixMonths",
 *     model_units=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Bedrock.ProvisionedModelThroughput("example", new()
 *     {
 *         ProvisionedModelName = "example-model",
 *         ModelArn = "arn:aws:bedrock:us-east-1::foundation-model/anthropic.claude-v2",
 *         CommitmentDuration = "SixMonths",
 *         ModelUnits = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := bedrock.NewProvisionedModelThroughput(ctx, "example", &bedrock.ProvisionedModelThroughputArgs{
 * 			ProvisionedModelName: pulumi.String("example-model"),
 * 			ModelArn:             pulumi.String("arn:aws:bedrock:us-east-1::foundation-model/anthropic.claude-v2"),
 * 			CommitmentDuration:   pulumi.String("SixMonths"),
 * 			ModelUnits:           pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.bedrock.ProvisionedModelThroughput;
 * import com.pulumi.aws.bedrock.ProvisionedModelThroughputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProvisionedModelThroughput("example", ProvisionedModelThroughputArgs.builder()
 *             .provisionedModelName("example-model")
 *             .modelArn("arn:aws:bedrock:us-east-1::foundation-model/anthropic.claude-v2")
 *             .commitmentDuration("SixMonths")
 *             .modelUnits(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:bedrock:ProvisionedModelThroughput
 *     properties:
 *       provisionedModelName: example-model
 *       modelArn: arn:aws:bedrock:us-east-1::foundation-model/anthropic.claude-v2
 *       commitmentDuration: SixMonths
 *       modelUnits: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Provisioned Throughput using the `provisioned_model_arn`. For example:
 * ```sh
 * $ pulumi import aws:bedrock/provisionedModelThroughput:ProvisionedModelThroughput example arn:aws:bedrock:us-west-2:123456789012:provisioned-model/1y5n57gh5y2e
 * ```
 */
public class ProvisionedModelThroughput internal constructor(
    override val javaResource: com.pulumi.aws.bedrock.ProvisionedModelThroughput,
) : KotlinCustomResource(javaResource, ProvisionedModelThroughputMapper) {
    /**
     * Commitment duration requested for the Provisioned Throughput. For custom models, you can purchase on-demand Provisioned Throughput by omitting this argument. Valid values: `OneMonth`, `SixMonths`.
     */
    public val commitmentDuration: Output<String>?
        get() = javaResource.commitmentDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the model to associate with this Provisioned Throughput.
     */
    public val modelArn: Output<String>
        get() = javaResource.modelArn().applyValue({ args0 -> args0 })

    /**
     * Number of model units to allocate. A model unit delivers a specific throughput level for the specified model.
     */
    public val modelUnits: Output<Int>
        get() = javaResource.modelUnits().applyValue({ args0 -> args0 })

    /**
     * The ARN of the Provisioned Throughput.
     */
    public val provisionedModelArn: Output<String>
        get() = javaResource.provisionedModelArn().applyValue({ args0 -> args0 })

    /**
     * Unique name for this Provisioned Throughput.
     */
    public val provisionedModelName: Output<String>
        get() = javaResource.provisionedModelName().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<ProvisionedModelThroughputTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ProvisionedModelThroughputMapper : ResourceMapper<ProvisionedModelThroughput> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.bedrock.ProvisionedModelThroughput::class == javaResource::class

    override fun map(javaResource: Resource): ProvisionedModelThroughput =
        ProvisionedModelThroughput(javaResource as com.pulumi.aws.bedrock.ProvisionedModelThroughput)
}

/**
 * @see [ProvisionedModelThroughput].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProvisionedModelThroughput].
 */
public suspend fun provisionedModelThroughput(
    name: String,
    block: suspend ProvisionedModelThroughputResourceBuilder.() -> Unit,
): ProvisionedModelThroughput {
    val builder = ProvisionedModelThroughputResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProvisionedModelThroughput].
 * @param name The _unique_ name of the resulting resource.
 */
public fun provisionedModelThroughput(name: String): ProvisionedModelThroughput {
    val builder = ProvisionedModelThroughputResourceBuilder()
    builder.name(name)
    return builder.build()
}
