@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin

import com.pulumi.aws.bedrock.ProvisionedModelThroughputArgs.builder
import com.pulumi.aws.bedrock.kotlin.inputs.ProvisionedModelThroughputTimeoutsArgs
import com.pulumi.aws.bedrock.kotlin.inputs.ProvisionedModelThroughputTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) for an Amazon Bedrock model.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.bedrock.ProvisionedModelThroughput("example", {
 *     provisionedModelName: "example-model",
 *     modelArn: "arn:aws:bedrock:us-east-1::foundation-model/anthropic.claude-v2",
 *     commitmentDuration: "SixMonths",
 *     modelUnits: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.bedrock.ProvisionedModelThroughput("example",
 *     provisioned_model_name="example-model",
 *     model_arn="arn:aws:bedrock:us-east-1::foundation-model/anthropic.claude-v2",
 *     commitment_duration="SixMonths",
 *     model_units=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Bedrock.ProvisionedModelThroughput("example", new()
 *     {
 *         ProvisionedModelName = "example-model",
 *         ModelArn = "arn:aws:bedrock:us-east-1::foundation-model/anthropic.claude-v2",
 *         CommitmentDuration = "SixMonths",
 *         ModelUnits = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrock"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := bedrock.NewProvisionedModelThroughput(ctx, "example", &bedrock.ProvisionedModelThroughputArgs{
 * 			ProvisionedModelName: pulumi.String("example-model"),
 * 			ModelArn:             pulumi.String("arn:aws:bedrock:us-east-1::foundation-model/anthropic.claude-v2"),
 * 			CommitmentDuration:   pulumi.String("SixMonths"),
 * 			ModelUnits:           pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.bedrock.ProvisionedModelThroughput;
 * import com.pulumi.aws.bedrock.ProvisionedModelThroughputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProvisionedModelThroughput("example", ProvisionedModelThroughputArgs.builder()
 *             .provisionedModelName("example-model")
 *             .modelArn("arn:aws:bedrock:us-east-1::foundation-model/anthropic.claude-v2")
 *             .commitmentDuration("SixMonths")
 *             .modelUnits(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:bedrock:ProvisionedModelThroughput
 *     properties:
 *       provisionedModelName: example-model
 *       modelArn: arn:aws:bedrock:us-east-1::foundation-model/anthropic.claude-v2
 *       commitmentDuration: SixMonths
 *       modelUnits: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Provisioned Throughput using the `provisioned_model_arn`. For example:
 * ```sh
 * $ pulumi import aws:bedrock/provisionedModelThroughput:ProvisionedModelThroughput example arn:aws:bedrock:us-west-2:123456789012:provisioned-model/1y5n57gh5y2e
 * ```
 * @property commitmentDuration Commitment duration requested for the Provisioned Throughput. For custom models, you can purchase on-demand Provisioned Throughput by omitting this argument. Valid values: `OneMonth`, `SixMonths`.
 * @property modelArn ARN of the model to associate with this Provisioned Throughput.
 * @property modelUnits Number of model units to allocate. A model unit delivers a specific throughput level for the specified model.
 * @property provisionedModelName Unique name for this Provisioned Throughput.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class ProvisionedModelThroughputArgs(
    public val commitmentDuration: Output<String>? = null,
    public val modelArn: Output<String>? = null,
    public val modelUnits: Output<Int>? = null,
    public val provisionedModelName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<ProvisionedModelThroughputTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrock.ProvisionedModelThroughputArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.ProvisionedModelThroughputArgs =
        com.pulumi.aws.bedrock.ProvisionedModelThroughputArgs.builder()
            .commitmentDuration(commitmentDuration?.applyValue({ args0 -> args0 }))
            .modelArn(modelArn?.applyValue({ args0 -> args0 }))
            .modelUnits(modelUnits?.applyValue({ args0 -> args0 }))
            .provisionedModelName(provisionedModelName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ProvisionedModelThroughputArgs].
 */
@PulumiTagMarker
public class ProvisionedModelThroughputArgsBuilder internal constructor() {
    private var commitmentDuration: Output<String>? = null

    private var modelArn: Output<String>? = null

    private var modelUnits: Output<Int>? = null

    private var provisionedModelName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<ProvisionedModelThroughputTimeoutsArgs>? = null

    /**
     * @param value Commitment duration requested for the Provisioned Throughput. For custom models, you can purchase on-demand Provisioned Throughput by omitting this argument. Valid values: `OneMonth`, `SixMonths`.
     */
    @JvmName("scyivlggjcyxcqwr")
    public suspend fun commitmentDuration(`value`: Output<String>) {
        this.commitmentDuration = value
    }

    /**
     * @param value ARN of the model to associate with this Provisioned Throughput.
     */
    @JvmName("rdcvupfobikfhbmf")
    public suspend fun modelArn(`value`: Output<String>) {
        this.modelArn = value
    }

    /**
     * @param value Number of model units to allocate. A model unit delivers a specific throughput level for the specified model.
     */
    @JvmName("ayxabcfxemyetdsw")
    public suspend fun modelUnits(`value`: Output<Int>) {
        this.modelUnits = value
    }

    /**
     * @param value Unique name for this Provisioned Throughput.
     */
    @JvmName("qeuvlkkuofswgatt")
    public suspend fun provisionedModelName(`value`: Output<String>) {
        this.provisionedModelName = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vhyihhxcfvdyjbgs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("ifaxabeiiynohmwn")
    public suspend fun timeouts(`value`: Output<ProvisionedModelThroughputTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Commitment duration requested for the Provisioned Throughput. For custom models, you can purchase on-demand Provisioned Throughput by omitting this argument. Valid values: `OneMonth`, `SixMonths`.
     */
    @JvmName("clvlbamhnvjrbqha")
    public suspend fun commitmentDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitmentDuration = mapped
    }

    /**
     * @param value ARN of the model to associate with this Provisioned Throughput.
     */
    @JvmName("sqchfrpfideyuxqc")
    public suspend fun modelArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelArn = mapped
    }

    /**
     * @param value Number of model units to allocate. A model unit delivers a specific throughput level for the specified model.
     */
    @JvmName("fecuacifqasijbld")
    public suspend fun modelUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelUnits = mapped
    }

    /**
     * @param value Unique name for this Provisioned Throughput.
     */
    @JvmName("udkgnubremxbbjra")
    public suspend fun provisionedModelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedModelName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uqpttdiyjjxexefi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rvpufydgmwwfohxq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("jtvmucpyplnhqatj")
    public suspend fun timeouts(`value`: ProvisionedModelThroughputTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xuymwhybhmydmjxp")
    public suspend fun timeouts(argument: suspend ProvisionedModelThroughputTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ProvisionedModelThroughputTimeoutsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): ProvisionedModelThroughputArgs = ProvisionedModelThroughputArgs(
        commitmentDuration = commitmentDuration,
        modelArn = modelArn,
        modelUnits = modelUnits,
        provisionedModelName = provisionedModelName,
        tags = tags,
        timeouts = timeouts,
    )
}
