@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupActionGroupExecutorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customControl Custom control method for handling the information elicited from the user. Valid values: `RETURN_CONTROL`.
 * To skip using a Lambda function and instead return the predicted action group, in addition to the parameters and information required for it, in the `InvokeAgent` response, specify `RETURN_CONTROL`.
 * Only one of `custom_control` or `lambda` can be specified.
 * @property lambda ARN of the Lambda function containing the business logic that is carried out upon invoking the action.
 * Only one of `lambda` or `custom_control` can be specified.
 */
public data class AgentAgentActionGroupActionGroupExecutorArgs(
    public val customControl: Output<String>? = null,
    public val lambda: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupActionGroupExecutorArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupActionGroupExecutorArgs = com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupActionGroupExecutorArgs.builder()
        .customControl(customControl?.applyValue({ args0 -> args0 }))
        .lambda(lambda?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentAgentActionGroupActionGroupExecutorArgs].
 */
@PulumiTagMarker
public class AgentAgentActionGroupActionGroupExecutorArgsBuilder internal constructor() {
    private var customControl: Output<String>? = null

    private var lambda: Output<String>? = null

    /**
     * @param value Custom control method for handling the information elicited from the user. Valid values: `RETURN_CONTROL`.
     * To skip using a Lambda function and instead return the predicted action group, in addition to the parameters and information required for it, in the `InvokeAgent` response, specify `RETURN_CONTROL`.
     * Only one of `custom_control` or `lambda` can be specified.
     */
    @JvmName("rmievnotatgbjfrb")
    public suspend fun customControl(`value`: Output<String>) {
        this.customControl = value
    }

    /**
     * @param value ARN of the Lambda function containing the business logic that is carried out upon invoking the action.
     * Only one of `lambda` or `custom_control` can be specified.
     */
    @JvmName("tjqtsfipbygiqiyd")
    public suspend fun lambda(`value`: Output<String>) {
        this.lambda = value
    }

    /**
     * @param value Custom control method for handling the information elicited from the user. Valid values: `RETURN_CONTROL`.
     * To skip using a Lambda function and instead return the predicted action group, in addition to the parameters and information required for it, in the `InvokeAgent` response, specify `RETURN_CONTROL`.
     * Only one of `custom_control` or `lambda` can be specified.
     */
    @JvmName("wupngggqwmjjfack")
    public suspend fun customControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customControl = mapped
    }

    /**
     * @param value ARN of the Lambda function containing the business logic that is carried out upon invoking the action.
     * Only one of `lambda` or `custom_control` can be specified.
     */
    @JvmName("toninmodewudrmnr")
    public suspend fun lambda(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambda = mapped
    }

    internal fun build(): AgentAgentActionGroupActionGroupExecutorArgs =
        AgentAgentActionGroupActionGroupExecutorArgs(
            customControl = customControl,
            lambda = lambda,
        )
}
