@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupApiSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property payload JSON or YAML-formatted payload defining the OpenAPI schema for the action group.
 * Only one of `payload` or `s3` can be specified.
 * @property s3 Details about the S3 object containing the OpenAPI schema for the action group. See `s3` Block for details.
 * Only one of `s3` or `payload` can be specified.
 */
public data class AgentAgentActionGroupApiSchemaArgs(
    public val payload: Output<String>? = null,
    public val s3: Output<AgentAgentActionGroupApiSchemaS3Args>? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupApiSchemaArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupApiSchemaArgs =
        com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupApiSchemaArgs.builder()
            .payload(payload?.applyValue({ args0 -> args0 }))
            .s3(s3?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AgentAgentActionGroupApiSchemaArgs].
 */
@PulumiTagMarker
public class AgentAgentActionGroupApiSchemaArgsBuilder internal constructor() {
    private var payload: Output<String>? = null

    private var s3: Output<AgentAgentActionGroupApiSchemaS3Args>? = null

    /**
     * @param value JSON or YAML-formatted payload defining the OpenAPI schema for the action group.
     * Only one of `payload` or `s3` can be specified.
     */
    @JvmName("pkttbplawqfkarmv")
    public suspend fun payload(`value`: Output<String>) {
        this.payload = value
    }

    /**
     * @param value Details about the S3 object containing the OpenAPI schema for the action group. See `s3` Block for details.
     * Only one of `s3` or `payload` can be specified.
     */
    @JvmName("juhjjowmbtorumut")
    public suspend fun s3(`value`: Output<AgentAgentActionGroupApiSchemaS3Args>) {
        this.s3 = value
    }

    /**
     * @param value JSON or YAML-formatted payload defining the OpenAPI schema for the action group.
     * Only one of `payload` or `s3` can be specified.
     */
    @JvmName("ypgeimhhcteixhaj")
    public suspend fun payload(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payload = mapped
    }

    /**
     * @param value Details about the S3 object containing the OpenAPI schema for the action group. See `s3` Block for details.
     * Only one of `s3` or `payload` can be specified.
     */
    @JvmName("eppvgrkcfhqhepyy")
    public suspend fun s3(`value`: AgentAgentActionGroupApiSchemaS3Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument Details about the S3 object containing the OpenAPI schema for the action group. See `s3` Block for details.
     * Only one of `s3` or `payload` can be specified.
     */
    @JvmName("hqckaaochmtxckvi")
    public suspend fun s3(argument: suspend AgentAgentActionGroupApiSchemaS3ArgsBuilder.() -> Unit) {
        val toBeMapped = AgentAgentActionGroupApiSchemaS3ArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    internal fun build(): AgentAgentActionGroupApiSchemaArgs = AgentAgentActionGroupApiSchemaArgs(
        payload = payload,
        s3 = s3,
    )
}
