@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupApiSchemaS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3BucketName Name of the S3 bucket.
 * @property s3ObjectKey S3 object key containing the resource.
 */
public data class AgentAgentActionGroupApiSchemaS3Args(
    public val s3BucketName: Output<String>? = null,
    public val s3ObjectKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupApiSchemaS3Args> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupApiSchemaS3Args =
        com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupApiSchemaS3Args.builder()
            .s3BucketName(s3BucketName?.applyValue({ args0 -> args0 }))
            .s3ObjectKey(s3ObjectKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentAgentActionGroupApiSchemaS3Args].
 */
@PulumiTagMarker
public class AgentAgentActionGroupApiSchemaS3ArgsBuilder internal constructor() {
    private var s3BucketName: Output<String>? = null

    private var s3ObjectKey: Output<String>? = null

    /**
     * @param value Name of the S3 bucket.
     */
    @JvmName("ivqrhiwbxjnwfvng")
    public suspend fun s3BucketName(`value`: Output<String>) {
        this.s3BucketName = value
    }

    /**
     * @param value S3 object key containing the resource.
     */
    @JvmName("sxlymrbuvvbiukix")
    public suspend fun s3ObjectKey(`value`: Output<String>) {
        this.s3ObjectKey = value
    }

    /**
     * @param value Name of the S3 bucket.
     */
    @JvmName("hahcajejiudyevgh")
    public suspend fun s3BucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BucketName = mapped
    }

    /**
     * @param value S3 object key containing the resource.
     */
    @JvmName("djrreeqaiqcfjlwr")
    public suspend fun s3ObjectKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3ObjectKey = mapped
    }

    internal fun build(): AgentAgentActionGroupApiSchemaS3Args = AgentAgentActionGroupApiSchemaS3Args(
        s3BucketName = s3BucketName,
        s3ObjectKey = s3ObjectKey,
    )
}
