@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property memberFunctions Contains a list of functions.
 * Each function describes and action in the action group.
 * See `member_functions` Block for details.
 */
public data class AgentAgentActionGroupFunctionSchemaArgs(
    public val memberFunctions: Output<AgentAgentActionGroupFunctionSchemaMemberFunctionsArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaArgs =
        com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaArgs.builder()
            .memberFunctions(
                memberFunctions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AgentAgentActionGroupFunctionSchemaArgs].
 */
@PulumiTagMarker
public class AgentAgentActionGroupFunctionSchemaArgsBuilder internal constructor() {
    private var memberFunctions: Output<AgentAgentActionGroupFunctionSchemaMemberFunctionsArgs>? =
        null

    /**
     * @param value Contains a list of functions.
     * Each function describes and action in the action group.
     * See `member_functions` Block for details.
     */
    @JvmName("hlkigjdbvkndiarr")
    public suspend fun memberFunctions(`value`: Output<AgentAgentActionGroupFunctionSchemaMemberFunctionsArgs>) {
        this.memberFunctions = value
    }

    /**
     * @param value Contains a list of functions.
     * Each function describes and action in the action group.
     * See `member_functions` Block for details.
     */
    @JvmName("jqhnuokkcrjevoei")
    public suspend fun memberFunctions(`value`: AgentAgentActionGroupFunctionSchemaMemberFunctionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberFunctions = mapped
    }

    /**
     * @param argument Contains a list of functions.
     * Each function describes and action in the action group.
     * See `member_functions` Block for details.
     */
    @JvmName("rkfpqwsvcmqxrgdf")
    public suspend fun memberFunctions(argument: suspend AgentAgentActionGroupFunctionSchemaMemberFunctionsArgsBuilder.() -> Unit) {
        val toBeMapped = AgentAgentActionGroupFunctionSchemaMemberFunctionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.memberFunctions = mapped
    }

    internal fun build(): AgentAgentActionGroupFunctionSchemaArgs =
        AgentAgentActionGroupFunctionSchemaArgs(
            memberFunctions = memberFunctions,
        )
}
