@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property functions Functions that each define an action in the action group. See `functions` Block for details.
 */
public data class AgentAgentActionGroupFunctionSchemaMemberFunctionsArgs(
    public val functions: Output<List<AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsArgs =
        com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsArgs.builder()
            .functions(
                functions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AgentAgentActionGroupFunctionSchemaMemberFunctionsArgs].
 */
@PulumiTagMarker
public class AgentAgentActionGroupFunctionSchemaMemberFunctionsArgsBuilder internal constructor() {
    private var functions:
        Output<List<AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs>>? = null

    /**
     * @param value Functions that each define an action in the action group. See `functions` Block for details.
     */
    @JvmName("ejmhknswctpwuscc")
    public suspend fun functions(`value`: Output<List<AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs>>) {
        this.functions = value
    }

    @JvmName("whcrlhbnmmgooitr")
    public suspend fun functions(vararg values: Output<AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs>) {
        this.functions = Output.all(values.asList())
    }

    /**
     * @param values Functions that each define an action in the action group. See `functions` Block for details.
     */
    @JvmName("gqqnspmvirirgepm")
    public suspend fun functions(values: List<Output<AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs>>) {
        this.functions = Output.all(values)
    }

    /**
     * @param value Functions that each define an action in the action group. See `functions` Block for details.
     */
    @JvmName("vobxjfmcetlountw")
    public suspend fun functions(`value`: List<AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functions = mapped
    }

    /**
     * @param argument Functions that each define an action in the action group. See `functions` Block for details.
     */
    @JvmName("hvtebfpjwtylweys")
    public suspend fun functions(argument: List<suspend AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.functions = mapped
    }

    /**
     * @param argument Functions that each define an action in the action group. See `functions` Block for details.
     */
    @JvmName("ghckvvwaaouvihvr")
    public suspend fun functions(vararg argument: suspend AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.functions = mapped
    }

    /**
     * @param argument Functions that each define an action in the action group. See `functions` Block for details.
     */
    @JvmName("vvmmddhlgjjnnnia")
    public suspend fun functions(argument: suspend AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.functions = mapped
    }

    /**
     * @param values Functions that each define an action in the action group. See `functions` Block for details.
     */
    @JvmName("ghwgglgmdhwebrlk")
    public suspend fun functions(vararg values: AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functions = mapped
    }

    internal fun build(): AgentAgentActionGroupFunctionSchemaMemberFunctionsArgs =
        AgentAgentActionGroupFunctionSchemaMemberFunctionsArgs(
            functions = functions,
        )
}
