@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property description Description of the function and its purpose.
 * @property name Name for the function.
 * @property parameters Parameters that the agent elicits from the user to fulfill the function. See `parameters` Block for details.
 */
public data class AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>,
    public val parameters: Output<List<AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs =
        com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs].
 */
@PulumiTagMarker
public class AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters:
        Output<List<AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs>>? = null

    /**
     * @param value Description of the function and its purpose.
     */
    @JvmName("bkywnehanqsnxwtr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name for the function.
     */
    @JvmName("cgvtedrscsunjyos")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Parameters that the agent elicits from the user to fulfill the function. See `parameters` Block for details.
     */
    @JvmName("ujpetogbmmdwlckj")
    public suspend fun parameters(`value`: Output<List<AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("sknabvdahhmlclod")
    public suspend fun parameters(vararg values: Output<AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Parameters that the agent elicits from the user to fulfill the function. See `parameters` Block for details.
     */
    @JvmName("wtwrrnqrninbbngv")
    public suspend fun parameters(values: List<Output<AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Description of the function and its purpose.
     */
    @JvmName("innrpxlkgqxvysia")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name for the function.
     */
    @JvmName("hmtltkdxwvqojtcr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Parameters that the agent elicits from the user to fulfill the function. See `parameters` Block for details.
     */
    @JvmName("taebmmitnarnirfy")
    public suspend fun parameters(`value`: List<AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters that the agent elicits from the user to fulfill the function. See `parameters` Block for details.
     */
    @JvmName("gilrahaxtogcvdvt")
    public suspend fun parameters(argument: List<suspend AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Parameters that the agent elicits from the user to fulfill the function. See `parameters` Block for details.
     */
    @JvmName("tqqakvkgllymthpt")
    public suspend fun parameters(vararg argument: suspend AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Parameters that the agent elicits from the user to fulfill the function. See `parameters` Block for details.
     */
    @JvmName("ojbjxwhhocaglddf")
    public suspend fun parameters(argument: suspend AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters that the agent elicits from the user to fulfill the function. See `parameters` Block for details.
     */
    @JvmName("qoncluvsrscavnic")
    public suspend fun parameters(vararg values: AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs =
        AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionArgs(
            description = description,
            name = name ?: throw PulumiNullFieldException("name"),
            parameters = parameters,
        )
}
