@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description Description of the parameter. Helps the foundation model determine how to elicit the parameters from the user.
 * @property mapBlockKey Name of the parameter.
 * **Note:** The argument name `map_block_key` may seem out of context, but is necessary for backward compatibility reasons in the provider.
 * @property required Whether the parameter is required for the agent to complete the function for action group invocation.
 * @property type Data type of the parameter. Valid values: `string`, `number`, `integer`, `boolean`, `array`.
 */
public data class AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs(
    public val description: Output<String>? = null,
    public val mapBlockKey: Output<String>,
    public val required: Output<Boolean>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs =
        com.pulumi.aws.bedrock.inputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .mapBlockKey(mapBlockKey.applyValue({ args0 -> args0 }))
            .required(required?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs].
 */
@PulumiTagMarker
public class AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var mapBlockKey: Output<String>? = null

    private var required: Output<Boolean>? = null

    private var type: Output<String>? = null

    /**
     * @param value Description of the parameter. Helps the foundation model determine how to elicit the parameters from the user.
     */
    @JvmName("ujfmxlorpvcrpaji")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the parameter.
     * **Note:** The argument name `map_block_key` may seem out of context, but is necessary for backward compatibility reasons in the provider.
     */
    @JvmName("jradqcqxswkmqtgl")
    public suspend fun mapBlockKey(`value`: Output<String>) {
        this.mapBlockKey = value
    }

    /**
     * @param value Whether the parameter is required for the agent to complete the function for action group invocation.
     */
    @JvmName("auxhdfvivpbepksi")
    public suspend fun required(`value`: Output<Boolean>) {
        this.required = value
    }

    /**
     * @param value Data type of the parameter. Valid values: `string`, `number`, `integer`, `boolean`, `array`.
     */
    @JvmName("lrxfvphpvxqytcch")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Description of the parameter. Helps the foundation model determine how to elicit the parameters from the user.
     */
    @JvmName("nahlrxwicladroqw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the parameter.
     * **Note:** The argument name `map_block_key` may seem out of context, but is necessary for backward compatibility reasons in the provider.
     */
    @JvmName("gbieicnjcudejfni")
    public suspend fun mapBlockKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mapBlockKey = mapped
    }

    /**
     * @param value Whether the parameter is required for the agent to complete the function for action group invocation.
     */
    @JvmName("hmuqaakcuqgrqtnr")
    public suspend fun required(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.required = mapped
    }

    /**
     * @param value Data type of the parameter. Valid values: `string`, `number`, `integer`, `boolean`, `array`.
     */
    @JvmName("bnamdioikycavlpq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs =
        AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameterArgs(
            description = description,
            mapBlockKey = mapBlockKey ?: throw PulumiNullFieldException("mapBlockKey"),
            required = required,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
