@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentAgentAliasRoutingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property agentVersion Version of the agent with which the alias is associated.
 * @property provisionedThroughput ARN of the Provisioned Throughput assigned to the agent alias.
 */
public data class AgentAgentAliasRoutingConfigurationArgs(
    public val agentVersion: Output<String>,
    public val provisionedThroughput: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentAgentAliasRoutingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentAgentAliasRoutingConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentAgentAliasRoutingConfigurationArgs.builder()
            .agentVersion(agentVersion.applyValue({ args0 -> args0 }))
            .provisionedThroughput(provisionedThroughput.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentAgentAliasRoutingConfigurationArgs].
 */
@PulumiTagMarker
public class AgentAgentAliasRoutingConfigurationArgsBuilder internal constructor() {
    private var agentVersion: Output<String>? = null

    private var provisionedThroughput: Output<String>? = null

    /**
     * @param value Version of the agent with which the alias is associated.
     */
    @JvmName("mqtjkggasbbtqwoo")
    public suspend fun agentVersion(`value`: Output<String>) {
        this.agentVersion = value
    }

    /**
     * @param value ARN of the Provisioned Throughput assigned to the agent alias.
     */
    @JvmName("ujpolijyrnwlvscy")
    public suspend fun provisionedThroughput(`value`: Output<String>) {
        this.provisionedThroughput = value
    }

    /**
     * @param value Version of the agent with which the alias is associated.
     */
    @JvmName("ejucoaaebxixfowx")
    public suspend fun agentVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentVersion = mapped
    }

    /**
     * @param value ARN of the Provisioned Throughput assigned to the agent alias.
     */
    @JvmName("logcvxturxspldmk")
    public suspend fun provisionedThroughput(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisionedThroughput = mapped
    }

    internal fun build(): AgentAgentAliasRoutingConfigurationArgs =
        AgentAgentAliasRoutingConfigurationArgs(
            agentVersion = agentVersion ?: throw PulumiNullFieldException("agentVersion"),
            provisionedThroughput = provisionedThroughput ?: throw
                PulumiNullFieldException("provisionedThroughput"),
        )
}
