@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentAgentPromptOverrideConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property overrideLambda ARN of the Lambda function to use when parsing the raw foundation model output in parts of the agent sequence. If you specify this field, at least one of the `prompt_configurations` block must contain a `parser_mode` value that is set to `OVERRIDDEN`.
 * @property promptConfigurations Configurations to override a prompt template in one part of an agent sequence. See `prompt_configurations` Block for details.
 */
public data class AgentAgentPromptOverrideConfigurationArgs(
    public val overrideLambda: Output<String>,
    public val promptConfigurations: Output<List<AgentAgentPromptOverrideConfigurationPromptConfigurationArgs>>,
) : ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentAgentPromptOverrideConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentAgentPromptOverrideConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentAgentPromptOverrideConfigurationArgs.builder()
            .overrideLambda(overrideLambda.applyValue({ args0 -> args0 }))
            .promptConfigurations(
                promptConfigurations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AgentAgentPromptOverrideConfigurationArgs].
 */
@PulumiTagMarker
public class AgentAgentPromptOverrideConfigurationArgsBuilder internal constructor() {
    private var overrideLambda: Output<String>? = null

    private var promptConfigurations:
        Output<List<AgentAgentPromptOverrideConfigurationPromptConfigurationArgs>>? = null

    /**
     * @param value ARN of the Lambda function to use when parsing the raw foundation model output in parts of the agent sequence. If you specify this field, at least one of the `prompt_configurations` block must contain a `parser_mode` value that is set to `OVERRIDDEN`.
     */
    @JvmName("ylgdgclawxgupnjv")
    public suspend fun overrideLambda(`value`: Output<String>) {
        this.overrideLambda = value
    }

    /**
     * @param value Configurations to override a prompt template in one part of an agent sequence. See `prompt_configurations` Block for details.
     */
    @JvmName("xymtanjxpgyrlqxv")
    public suspend fun promptConfigurations(`value`: Output<List<AgentAgentPromptOverrideConfigurationPromptConfigurationArgs>>) {
        this.promptConfigurations = value
    }

    @JvmName("epluuffvmssjlkdk")
    public suspend fun promptConfigurations(vararg values: Output<AgentAgentPromptOverrideConfigurationPromptConfigurationArgs>) {
        this.promptConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Configurations to override a prompt template in one part of an agent sequence. See `prompt_configurations` Block for details.
     */
    @JvmName("pasnpdkxureafbfw")
    public suspend fun promptConfigurations(values: List<Output<AgentAgentPromptOverrideConfigurationPromptConfigurationArgs>>) {
        this.promptConfigurations = Output.all(values)
    }

    /**
     * @param value ARN of the Lambda function to use when parsing the raw foundation model output in parts of the agent sequence. If you specify this field, at least one of the `prompt_configurations` block must contain a `parser_mode` value that is set to `OVERRIDDEN`.
     */
    @JvmName("rajwsmjnsjvuqnlc")
    public suspend fun overrideLambda(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overrideLambda = mapped
    }

    /**
     * @param value Configurations to override a prompt template in one part of an agent sequence. See `prompt_configurations` Block for details.
     */
    @JvmName("fupogkildjofpfnh")
    public suspend fun promptConfigurations(`value`: List<AgentAgentPromptOverrideConfigurationPromptConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.promptConfigurations = mapped
    }

    /**
     * @param argument Configurations to override a prompt template in one part of an agent sequence. See `prompt_configurations` Block for details.
     */
    @JvmName("uadogqvrusbarbtg")
    public suspend fun promptConfigurations(argument: List<suspend AgentAgentPromptOverrideConfigurationPromptConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AgentAgentPromptOverrideConfigurationPromptConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.promptConfigurations = mapped
    }

    /**
     * @param argument Configurations to override a prompt template in one part of an agent sequence. See `prompt_configurations` Block for details.
     */
    @JvmName("apwicacnotpaorwv")
    public suspend fun promptConfigurations(vararg argument: suspend AgentAgentPromptOverrideConfigurationPromptConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AgentAgentPromptOverrideConfigurationPromptConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.promptConfigurations = mapped
    }

    /**
     * @param argument Configurations to override a prompt template in one part of an agent sequence. See `prompt_configurations` Block for details.
     */
    @JvmName("cengkjgtkfwuunje")
    public suspend fun promptConfigurations(argument: suspend AgentAgentPromptOverrideConfigurationPromptConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                AgentAgentPromptOverrideConfigurationPromptConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.promptConfigurations = mapped
    }

    /**
     * @param values Configurations to override a prompt template in one part of an agent sequence. See `prompt_configurations` Block for details.
     */
    @JvmName("guovektybxakfgqs")
    public suspend fun promptConfigurations(vararg values: AgentAgentPromptOverrideConfigurationPromptConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.promptConfigurations = mapped
    }

    internal fun build(): AgentAgentPromptOverrideConfigurationArgs =
        AgentAgentPromptOverrideConfigurationArgs(
            overrideLambda = overrideLambda ?: throw PulumiNullFieldException("overrideLambda"),
            promptConfigurations = promptConfigurations ?: throw
                PulumiNullFieldException("promptConfigurations"),
        )
}
