@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentAgentPromptOverrideConfigurationPromptConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property basePromptTemplate prompt template with which to replace the default prompt template. You can use placeholder variables in the base prompt template to customize the prompt. For more information, see [Prompt template placeholder variables](https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html).
 * @property inferenceConfigurations Inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the `prompt_type`. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html). See `inference_configuration` Block for details.
 * @property parserMode Whether to override the default parser Lambda function when parsing the raw foundation model output in the part of the agent sequence defined by the `prompt_type`. If you set the argument as `OVERRIDDEN`, the `override_lambda` argument in the `prompt_override_configuration` block must be specified with the ARN of a Lambda function. Valid values: `DEFAULT`, `OVERRIDDEN`.
 * @property promptCreationMode Whether to override the default prompt template for this `prompt_type`. Set this argument to `OVERRIDDEN` to use the prompt that you provide in the `base_prompt_template`. If you leave it as `DEFAULT`, the agent uses a default prompt template. Valid values: `DEFAULT`, `OVERRIDDEN`.
 * @property promptState Whether to allow the agent to carry out the step specified in the `prompt_type`. If you set this argument to `DISABLED`, the agent skips that step. Valid Values: `ENABLED`, `DISABLED`.
 * @property promptType Step in the agent sequence that this prompt configuration applies to. Valid values: `PRE_PROCESSING`, `ORCHESTRATION`, `POST_PROCESSING`, `KNOWLEDGE_BASE_RESPONSE_GENERATION`.
 */
public data class AgentAgentPromptOverrideConfigurationPromptConfigurationArgs(
    public val basePromptTemplate: Output<String>,
    public val inferenceConfigurations: Output<List<AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs>>,
    public val parserMode: Output<String>,
    public val promptCreationMode: Output<String>,
    public val promptState: Output<String>,
    public val promptType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentAgentPromptOverrideConfigurationPromptConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentAgentPromptOverrideConfigurationPromptConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentAgentPromptOverrideConfigurationPromptConfigurationArgs.builder()
            .basePromptTemplate(basePromptTemplate.applyValue({ args0 -> args0 }))
            .inferenceConfigurations(
                inferenceConfigurations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .parserMode(parserMode.applyValue({ args0 -> args0 }))
            .promptCreationMode(promptCreationMode.applyValue({ args0 -> args0 }))
            .promptState(promptState.applyValue({ args0 -> args0 }))
            .promptType(promptType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentAgentPromptOverrideConfigurationPromptConfigurationArgs].
 */
@PulumiTagMarker
public class AgentAgentPromptOverrideConfigurationPromptConfigurationArgsBuilder internal constructor() {
    private var basePromptTemplate: Output<String>? = null

    private var inferenceConfigurations:
        Output<List<AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs>>? =
        null

    private var parserMode: Output<String>? = null

    private var promptCreationMode: Output<String>? = null

    private var promptState: Output<String>? = null

    private var promptType: Output<String>? = null

    /**
     * @param value prompt template with which to replace the default prompt template. You can use placeholder variables in the base prompt template to customize the prompt. For more information, see [Prompt template placeholder variables](https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html).
     */
    @JvmName("fcrgycjctgmjayoi")
    public suspend fun basePromptTemplate(`value`: Output<String>) {
        this.basePromptTemplate = value
    }

    /**
     * @param value Inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the `prompt_type`. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html). See `inference_configuration` Block for details.
     */
    @JvmName("tleordubskniobkm")
    public suspend fun inferenceConfigurations(`value`: Output<List<AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs>>) {
        this.inferenceConfigurations = value
    }

    @JvmName("pdsimlnibijhpuug")
    public suspend fun inferenceConfigurations(vararg values: Output<AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs>) {
        this.inferenceConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the `prompt_type`. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html). See `inference_configuration` Block for details.
     */
    @JvmName("ydpewbjrnnfuwwjx")
    public suspend fun inferenceConfigurations(values: List<Output<AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs>>) {
        this.inferenceConfigurations = Output.all(values)
    }

    /**
     * @param value Whether to override the default parser Lambda function when parsing the raw foundation model output in the part of the agent sequence defined by the `prompt_type`. If you set the argument as `OVERRIDDEN`, the `override_lambda` argument in the `prompt_override_configuration` block must be specified with the ARN of a Lambda function. Valid values: `DEFAULT`, `OVERRIDDEN`.
     */
    @JvmName("swuicvmwxrouwbec")
    public suspend fun parserMode(`value`: Output<String>) {
        this.parserMode = value
    }

    /**
     * @param value Whether to override the default prompt template for this `prompt_type`. Set this argument to `OVERRIDDEN` to use the prompt that you provide in the `base_prompt_template`. If you leave it as `DEFAULT`, the agent uses a default prompt template. Valid values: `DEFAULT`, `OVERRIDDEN`.
     */
    @JvmName("fifamrfklvvyxvec")
    public suspend fun promptCreationMode(`value`: Output<String>) {
        this.promptCreationMode = value
    }

    /**
     * @param value Whether to allow the agent to carry out the step specified in the `prompt_type`. If you set this argument to `DISABLED`, the agent skips that step. Valid Values: `ENABLED`, `DISABLED`.
     */
    @JvmName("viycgkthcwfkqyvn")
    public suspend fun promptState(`value`: Output<String>) {
        this.promptState = value
    }

    /**
     * @param value Step in the agent sequence that this prompt configuration applies to. Valid values: `PRE_PROCESSING`, `ORCHESTRATION`, `POST_PROCESSING`, `KNOWLEDGE_BASE_RESPONSE_GENERATION`.
     */
    @JvmName("arpxhbummdxdllkg")
    public suspend fun promptType(`value`: Output<String>) {
        this.promptType = value
    }

    /**
     * @param value prompt template with which to replace the default prompt template. You can use placeholder variables in the base prompt template to customize the prompt. For more information, see [Prompt template placeholder variables](https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html).
     */
    @JvmName("jyyqusustggncnja")
    public suspend fun basePromptTemplate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.basePromptTemplate = mapped
    }

    /**
     * @param value Inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the `prompt_type`. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html). See `inference_configuration` Block for details.
     */
    @JvmName("paqvjrjtyvuwuldq")
    public suspend fun inferenceConfigurations(`value`: List<AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inferenceConfigurations = mapped
    }

    /**
     * @param argument Inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the `prompt_type`. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html). See `inference_configuration` Block for details.
     */
    @JvmName("hhhkgofytlorhcrv")
    public suspend fun inferenceConfigurations(argument: List<suspend AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inferenceConfigurations = mapped
    }

    /**
     * @param argument Inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the `prompt_type`. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html). See `inference_configuration` Block for details.
     */
    @JvmName("tiefkdhymevxmrbl")
    public suspend fun inferenceConfigurations(vararg argument: suspend AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inferenceConfigurations = mapped
    }

    /**
     * @param argument Inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the `prompt_type`. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html). See `inference_configuration` Block for details.
     */
    @JvmName("gtpvrliugltjgirj")
    public suspend fun inferenceConfigurations(argument: suspend AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.inferenceConfigurations = mapped
    }

    /**
     * @param values Inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the `prompt_type`. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html). See `inference_configuration` Block for details.
     */
    @JvmName("chqfgoownpnbvsqh")
    public suspend fun inferenceConfigurations(vararg values: AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inferenceConfigurations = mapped
    }

    /**
     * @param value Whether to override the default parser Lambda function when parsing the raw foundation model output in the part of the agent sequence defined by the `prompt_type`. If you set the argument as `OVERRIDDEN`, the `override_lambda` argument in the `prompt_override_configuration` block must be specified with the ARN of a Lambda function. Valid values: `DEFAULT`, `OVERRIDDEN`.
     */
    @JvmName("qjrouthuicordumi")
    public suspend fun parserMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parserMode = mapped
    }

    /**
     * @param value Whether to override the default prompt template for this `prompt_type`. Set this argument to `OVERRIDDEN` to use the prompt that you provide in the `base_prompt_template`. If you leave it as `DEFAULT`, the agent uses a default prompt template. Valid values: `DEFAULT`, `OVERRIDDEN`.
     */
    @JvmName("hufvpwqbcarxmdvx")
    public suspend fun promptCreationMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.promptCreationMode = mapped
    }

    /**
     * @param value Whether to allow the agent to carry out the step specified in the `prompt_type`. If you set this argument to `DISABLED`, the agent skips that step. Valid Values: `ENABLED`, `DISABLED`.
     */
    @JvmName("yyqsusbyaeicjjho")
    public suspend fun promptState(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.promptState = mapped
    }

    /**
     * @param value Step in the agent sequence that this prompt configuration applies to. Valid values: `PRE_PROCESSING`, `ORCHESTRATION`, `POST_PROCESSING`, `KNOWLEDGE_BASE_RESPONSE_GENERATION`.
     */
    @JvmName("dwbeyvetxryqjxod")
    public suspend fun promptType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.promptType = mapped
    }

    internal fun build(): AgentAgentPromptOverrideConfigurationPromptConfigurationArgs =
        AgentAgentPromptOverrideConfigurationPromptConfigurationArgs(
            basePromptTemplate = basePromptTemplate ?: throw PulumiNullFieldException("basePromptTemplate"),
            inferenceConfigurations = inferenceConfigurations ?: throw
                PulumiNullFieldException("inferenceConfigurations"),
            parserMode = parserMode ?: throw PulumiNullFieldException("parserMode"),
            promptCreationMode = promptCreationMode ?: throw PulumiNullFieldException("promptCreationMode"),
            promptState = promptState ?: throw PulumiNullFieldException("promptState"),
            promptType = promptType ?: throw PulumiNullFieldException("promptType"),
        )
}
