@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property maxLength Maximum number of tokens to allow in the generated response.
 * @property stopSequences List of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.
 * @property temperature Likelihood of the model selecting higher-probability options while generating a response. A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.
 * @property topK Number of top most-likely candidates, between 0 and 500, from which the model chooses the next token in the sequence.
 * @property topP Top percentage of the probability distribution of next tokens, between 0 and 1 (denoting 0% and 100%), from which the model chooses the next token in the sequence.
 */
public data class
AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs(
    public val maxLength: Output<Int>,
    public val stopSequences: Output<List<String>>,
    public val temperature: Output<Double>,
    public val topK: Output<Int>,
    public val topP: Output<Double>,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs.builder()
            .maxLength(maxLength.applyValue({ args0 -> args0 }))
            .stopSequences(stopSequences.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .temperature(temperature.applyValue({ args0 -> args0 }))
            .topK(topK.applyValue({ args0 -> args0 }))
            .topP(topP.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs].
 */
@PulumiTagMarker
public class
AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgsBuilder
internal constructor() {
    private var maxLength: Output<Int>? = null

    private var stopSequences: Output<List<String>>? = null

    private var temperature: Output<Double>? = null

    private var topK: Output<Int>? = null

    private var topP: Output<Double>? = null

    /**
     * @param value Maximum number of tokens to allow in the generated response.
     */
    @JvmName("nwbjlajpmkceegfi")
    public suspend fun maxLength(`value`: Output<Int>) {
        this.maxLength = value
    }

    /**
     * @param value List of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.
     */
    @JvmName("mysxlqmctyqlixbh")
    public suspend fun stopSequences(`value`: Output<List<String>>) {
        this.stopSequences = value
    }

    @JvmName("gggfhfbftbmicyqs")
    public suspend fun stopSequences(vararg values: Output<String>) {
        this.stopSequences = Output.all(values.asList())
    }

    /**
     * @param values List of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.
     */
    @JvmName("qemfldhtecnrpbum")
    public suspend fun stopSequences(values: List<Output<String>>) {
        this.stopSequences = Output.all(values)
    }

    /**
     * @param value Likelihood of the model selecting higher-probability options while generating a response. A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.
     */
    @JvmName("dqguywluynebhxnw")
    public suspend fun temperature(`value`: Output<Double>) {
        this.temperature = value
    }

    /**
     * @param value Number of top most-likely candidates, between 0 and 500, from which the model chooses the next token in the sequence.
     */
    @JvmName("ngqidhtprbisjype")
    public suspend fun topK(`value`: Output<Int>) {
        this.topK = value
    }

    /**
     * @param value Top percentage of the probability distribution of next tokens, between 0 and 1 (denoting 0% and 100%), from which the model chooses the next token in the sequence.
     */
    @JvmName("verboffyunwwlkss")
    public suspend fun topP(`value`: Output<Double>) {
        this.topP = value
    }

    /**
     * @param value Maximum number of tokens to allow in the generated response.
     */
    @JvmName("giqklxlxwmrcmfdn")
    public suspend fun maxLength(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxLength = mapped
    }

    /**
     * @param value List of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.
     */
    @JvmName("ysonncxrckhyxjih")
    public suspend fun stopSequences(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stopSequences = mapped
    }

    /**
     * @param values List of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.
     */
    @JvmName("jodnalvtllqrbjgd")
    public suspend fun stopSequences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stopSequences = mapped
    }

    /**
     * @param value Likelihood of the model selecting higher-probability options while generating a response. A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.
     */
    @JvmName("yedmsfdumhsnsrfy")
    public suspend fun temperature(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.temperature = mapped
    }

    /**
     * @param value Number of top most-likely candidates, between 0 and 500, from which the model chooses the next token in the sequence.
     */
    @JvmName("aludwgumtcyevlan")
    public suspend fun topK(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topK = mapped
    }

    /**
     * @param value Top percentage of the probability distribution of next tokens, between 0 and 1 (denoting 0% and 100%), from which the model chooses the next token in the sequence.
     */
    @JvmName("vuljqiatmxegouou")
    public suspend fun topP(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topP = mapped
    }

    internal fun build(): AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs =
        AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfigurationArgs(
            maxLength = maxLength ?: throw PulumiNullFieldException("maxLength"),
            stopSequences = stopSequences ?: throw PulumiNullFieldException("stopSequences"),
            temperature = temperature ?: throw PulumiNullFieldException("temperature"),
            topK = topK ?: throw PulumiNullFieldException("topK"),
            topP = topP ?: throw PulumiNullFieldException("topP"),
        )
}
