@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentDataSourceDataSourceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3Configuration Details about the configuration of the S3 object containing the data source. See `s3_data_source_configuration` block for details.
 * @property type Type of storage for the data source. Valid values: `S3`.
 */
public data class AgentDataSourceDataSourceConfigurationArgs(
    public val s3Configuration: Output<AgentDataSourceDataSourceConfigurationS3ConfigurationArgs>? =
        null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentDataSourceDataSourceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentDataSourceDataSourceConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentDataSourceDataSourceConfigurationArgs.builder()
            .s3Configuration(s3Configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentDataSourceDataSourceConfigurationArgs].
 */
@PulumiTagMarker
public class AgentDataSourceDataSourceConfigurationArgsBuilder internal constructor() {
    private var s3Configuration: Output<AgentDataSourceDataSourceConfigurationS3ConfigurationArgs>? =
        null

    private var type: Output<String>? = null

    /**
     * @param value Details about the configuration of the S3 object containing the data source. See `s3_data_source_configuration` block for details.
     */
    @JvmName("vmogcqnxfcmfbyrb")
    public suspend fun s3Configuration(`value`: Output<AgentDataSourceDataSourceConfigurationS3ConfigurationArgs>) {
        this.s3Configuration = value
    }

    /**
     * @param value Type of storage for the data source. Valid values: `S3`.
     */
    @JvmName("dykahpkevmxrvlrp")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Details about the configuration of the S3 object containing the data source. See `s3_data_source_configuration` block for details.
     */
    @JvmName("btqillolefiqhkqi")
    public suspend fun s3Configuration(`value`: AgentDataSourceDataSourceConfigurationS3ConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Configuration = mapped
    }

    /**
     * @param argument Details about the configuration of the S3 object containing the data source. See `s3_data_source_configuration` block for details.
     */
    @JvmName("vfiakacdoqaatqoj")
    public suspend fun s3Configuration(argument: suspend AgentDataSourceDataSourceConfigurationS3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            AgentDataSourceDataSourceConfigurationS3ConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3Configuration = mapped
    }

    /**
     * @param value Type of storage for the data source. Valid values: `S3`.
     */
    @JvmName("xdvlmkfoxpbgeyxi")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AgentDataSourceDataSourceConfigurationArgs =
        AgentDataSourceDataSourceConfigurationArgs(
            s3Configuration = s3Configuration,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
