@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentDataSourceDataSourceConfigurationS3ConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bucketArn ARN of the bucket that contains the data source.
 * @property bucketOwnerAccountId Bucket account owner ID for the S3 bucket.
 * @property inclusionPrefixes List of S3 prefixes that define the object containing the data sources. For more information, see [Organizing objects using prefixes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html).
 */
public data class AgentDataSourceDataSourceConfigurationS3ConfigurationArgs(
    public val bucketArn: Output<String>,
    public val bucketOwnerAccountId: Output<String>? = null,
    public val inclusionPrefixes: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentDataSourceDataSourceConfigurationS3ConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentDataSourceDataSourceConfigurationS3ConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentDataSourceDataSourceConfigurationS3ConfigurationArgs.builder()
            .bucketArn(bucketArn.applyValue({ args0 -> args0 }))
            .bucketOwnerAccountId(bucketOwnerAccountId?.applyValue({ args0 -> args0 }))
            .inclusionPrefixes(inclusionPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AgentDataSourceDataSourceConfigurationS3ConfigurationArgs].
 */
@PulumiTagMarker
public class AgentDataSourceDataSourceConfigurationS3ConfigurationArgsBuilder internal constructor() {
    private var bucketArn: Output<String>? = null

    private var bucketOwnerAccountId: Output<String>? = null

    private var inclusionPrefixes: Output<List<String>>? = null

    /**
     * @param value ARN of the bucket that contains the data source.
     */
    @JvmName("uwfcwirnfkjbqoqe")
    public suspend fun bucketArn(`value`: Output<String>) {
        this.bucketArn = value
    }

    /**
     * @param value Bucket account owner ID for the S3 bucket.
     */
    @JvmName("sqohfxwjbcurphyq")
    public suspend fun bucketOwnerAccountId(`value`: Output<String>) {
        this.bucketOwnerAccountId = value
    }

    /**
     * @param value List of S3 prefixes that define the object containing the data sources. For more information, see [Organizing objects using prefixes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html).
     */
    @JvmName("cltrgfbiywugxenl")
    public suspend fun inclusionPrefixes(`value`: Output<List<String>>) {
        this.inclusionPrefixes = value
    }

    @JvmName("debqnklclchkljni")
    public suspend fun inclusionPrefixes(vararg values: Output<String>) {
        this.inclusionPrefixes = Output.all(values.asList())
    }

    /**
     * @param values List of S3 prefixes that define the object containing the data sources. For more information, see [Organizing objects using prefixes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html).
     */
    @JvmName("jtujkypopooncgox")
    public suspend fun inclusionPrefixes(values: List<Output<String>>) {
        this.inclusionPrefixes = Output.all(values)
    }

    /**
     * @param value ARN of the bucket that contains the data source.
     */
    @JvmName("sebewyumvyxglabk")
    public suspend fun bucketArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketArn = mapped
    }

    /**
     * @param value Bucket account owner ID for the S3 bucket.
     */
    @JvmName("ortcyxvgnefiknby")
    public suspend fun bucketOwnerAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketOwnerAccountId = mapped
    }

    /**
     * @param value List of S3 prefixes that define the object containing the data sources. For more information, see [Organizing objects using prefixes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html).
     */
    @JvmName("nbwlsigvlcxvohma")
    public suspend fun inclusionPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inclusionPrefixes = mapped
    }

    /**
     * @param values List of S3 prefixes that define the object containing the data sources. For more information, see [Organizing objects using prefixes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html).
     */
    @JvmName("hjeuqdvwhoaehcta")
    public suspend fun inclusionPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inclusionPrefixes = mapped
    }

    internal fun build(): AgentDataSourceDataSourceConfigurationS3ConfigurationArgs =
        AgentDataSourceDataSourceConfigurationS3ConfigurationArgs(
            bucketArn = bucketArn ?: throw PulumiNullFieldException("bucketArn"),
            bucketOwnerAccountId = bucketOwnerAccountId,
            inclusionPrefixes = inclusionPrefixes,
        )
}
