@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentDataSourceServerSideEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyArn ARN of the AWS KMS key used to encrypt the resource.
 */
public data class AgentDataSourceServerSideEncryptionConfigurationArgs(
    public val kmsKeyArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentDataSourceServerSideEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentDataSourceServerSideEncryptionConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentDataSourceServerSideEncryptionConfigurationArgs.builder()
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentDataSourceServerSideEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class AgentDataSourceServerSideEncryptionConfigurationArgsBuilder internal constructor() {
    private var kmsKeyArn: Output<String>? = null

    /**
     * @param value ARN of the AWS KMS key used to encrypt the resource.
     */
    @JvmName("lpglgbxbljgpfaku")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value ARN of the AWS KMS key used to encrypt the resource.
     */
    @JvmName("wciaxsofnmoulcac")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    internal fun build(): AgentDataSourceServerSideEncryptionConfigurationArgs =
        AgentDataSourceServerSideEncryptionConfigurationArgs(
            kmsKeyArn = kmsKeyArn,
        )
}
