@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentDataSourceVectorIngestionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property chunkingConfiguration Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. See `chunking_configuration` block for details.
 */
public data class AgentDataSourceVectorIngestionConfigurationArgs(
    public val chunkingConfiguration: Output<AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentDataSourceVectorIngestionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentDataSourceVectorIngestionConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentDataSourceVectorIngestionConfigurationArgs.builder()
            .chunkingConfiguration(
                chunkingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AgentDataSourceVectorIngestionConfigurationArgs].
 */
@PulumiTagMarker
public class AgentDataSourceVectorIngestionConfigurationArgsBuilder internal constructor() {
    private var chunkingConfiguration:
        Output<AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgs>? = null

    /**
     * @param value Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. See `chunking_configuration` block for details.
     */
    @JvmName("vurbarqiwmtgcaev")
    public suspend fun chunkingConfiguration(`value`: Output<AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgs>) {
        this.chunkingConfiguration = value
    }

    /**
     * @param value Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. See `chunking_configuration` block for details.
     */
    @JvmName("dngaeetpgpaijrnq")
    public suspend fun chunkingConfiguration(`value`: AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chunkingConfiguration = mapped
    }

    /**
     * @param argument Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. See `chunking_configuration` block for details.
     */
    @JvmName("hnmccxlnbmvsjcoh")
    public suspend fun chunkingConfiguration(argument: suspend AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.chunkingConfiguration = mapped
    }

    internal fun build(): AgentDataSourceVectorIngestionConfigurationArgs =
        AgentDataSourceVectorIngestionConfigurationArgs(
            chunkingConfiguration = chunkingConfiguration,
        )
}
