@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property chunkingStrategy Option for chunking your source data, either in fixed-sized chunks or as one chunk. Valid values: `FIXED_SIZE`, `NONE`.
 * @property fixedSizeChunkingConfiguration Configurations for when you choose fixed-size chunking. If you set the chunking_strategy as `NONE`, exclude this field. See `fixed_size_chunking_configuration` for details.
 */
public data class AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgs(
    public val chunkingStrategy: Output<String>,
    public val fixedSizeChunkingConfiguration: Output<AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgs.builder()
            .chunkingStrategy(chunkingStrategy.applyValue({ args0 -> args0 }))
            .fixedSizeChunkingConfiguration(
                fixedSizeChunkingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgs].
 */
@PulumiTagMarker
public class AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgsBuilder internal constructor() {
    private var chunkingStrategy: Output<String>? = null

    private var fixedSizeChunkingConfiguration:
        Output<AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgs>? =
        null

    /**
     * @param value Option for chunking your source data, either in fixed-sized chunks or as one chunk. Valid values: `FIXED_SIZE`, `NONE`.
     */
    @JvmName("lyswbaxaovcthcqr")
    public suspend fun chunkingStrategy(`value`: Output<String>) {
        this.chunkingStrategy = value
    }

    /**
     * @param value Configurations for when you choose fixed-size chunking. If you set the chunking_strategy as `NONE`, exclude this field. See `fixed_size_chunking_configuration` for details.
     */
    @JvmName("ckjkyfjlpuaecppf")
    public suspend fun fixedSizeChunkingConfiguration(`value`: Output<AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgs>) {
        this.fixedSizeChunkingConfiguration = value
    }

    /**
     * @param value Option for chunking your source data, either in fixed-sized chunks or as one chunk. Valid values: `FIXED_SIZE`, `NONE`.
     */
    @JvmName("cgewjterboelkovo")
    public suspend fun chunkingStrategy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.chunkingStrategy = mapped
    }

    /**
     * @param value Configurations for when you choose fixed-size chunking. If you set the chunking_strategy as `NONE`, exclude this field. See `fixed_size_chunking_configuration` for details.
     */
    @JvmName("fbmmdewehjtuacfq")
    public suspend fun fixedSizeChunkingConfiguration(`value`: AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fixedSizeChunkingConfiguration = mapped
    }

    /**
     * @param argument Configurations for when you choose fixed-size chunking. If you set the chunking_strategy as `NONE`, exclude this field. See `fixed_size_chunking_configuration` for details.
     */
    @JvmName("ogokfdkpvflmyroc")
    public suspend fun fixedSizeChunkingConfiguration(argument: suspend AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fixedSizeChunkingConfiguration = mapped
    }

    internal fun build(): AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgs =
        AgentDataSourceVectorIngestionConfigurationChunkingConfigurationArgs(
            chunkingStrategy = chunkingStrategy ?: throw PulumiNullFieldException("chunkingStrategy"),
            fixedSizeChunkingConfiguration = fixedSizeChunkingConfiguration,
        )
}
